/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.faster.jackson.databind.deser.std;

import fish.payara.arquillian.faster.jackson.databind.BeanDescription;
import fish.payara.arquillian.faster.jackson.databind.DeserializationConfig;
import fish.payara.arquillian.faster.jackson.databind.JavaType;
import fish.payara.arquillian.faster.jackson.databind.JsonDeserializer;
import fish.payara.arquillian.faster.jackson.databind.JsonMappingException;
import fish.payara.arquillian.faster.jackson.databind.KeyDeserializer;
import fish.payara.arquillian.faster.jackson.databind.MapperFeature;
import fish.payara.arquillian.faster.jackson.databind.deser.KeyDeserializers;
import fish.payara.arquillian.faster.jackson.databind.deser.std.StdKeyDeserializer;
import fish.payara.arquillian.faster.jackson.databind.introspect.AnnotatedMethod;
import fish.payara.arquillian.faster.jackson.databind.util.ClassUtil;
import fish.payara.arquillian.faster.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod factory) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config, JavaType type, JsonDeserializer<?> deser) {
        return new StdKeyDeserializer.DelegatingKD(type.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config, JavaType type) {
        BeanDescription beanDesc = config.introspect(type);
        Constructor<?> ctor = beanDesc.findSingleArgConstructor(String.class);
        if (ctor != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(ctor, config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(ctor);
        }
        Method m = beanDesc.findFactoryMethod(String.class);
        if (m != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m, config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(m);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        return StdKeyDeserializer.forType(raw);
    }
}

