/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.RegionPane;
import eu.hansolo.fx.countries.tools.CRegion;
import eu.hansolo.fx.countries.tools.Connection;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class RegionPaneBuilder<B extends RegionPaneBuilder<B>> {
    private final HashMap<String, Property> properties = new HashMap();
    private final CRegion region;

    protected RegionPaneBuilder(CRegion region) {
        if (null == region) {
            throw new IllegalArgumentException("region cannot be null");
        }
        this.region = region;
    }

    public static final RegionPaneBuilder create(CRegion region) {
        return new RegionPaneBuilder(region);
    }

    public final B background(Paint paint) {
        this.properties.put("background", (Property)new SimpleObjectProperty((Object)paint));
        return (B)this;
    }

    public final B fill(Color fill) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)fill));
        return (B)this;
    }

    public final B lineWidth(double lineWidth) {
        this.properties.put("lineWidth", (Property)new SimpleDoubleProperty(lineWidth));
        return (B)this;
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)stroke));
        return (B)this;
    }

    public final B poiFill(Color poiFill) {
        this.properties.put("poiFill", (Property)new SimpleObjectProperty((Object)poiFill));
        return (B)this;
    }

    public final B poiStroke(Color poiStroke) {
        this.properties.put("poiStroke", (Property)new SimpleObjectProperty((Object)poiStroke));
        return (B)this;
    }

    public final B poiTextFill(Color poiTextFill) {
        this.properties.put("poiTextFill", (Property)new SimpleObjectProperty((Object)poiTextFill));
        return (B)this;
    }

    public final B poisVisible(boolean poisVisible) {
        this.properties.put("poisVisible", (Property)new SimpleBooleanProperty(poisVisible));
        return (B)this;
    }

    public final B poiTextVisible(boolean poiTextVisible) {
        this.properties.put("poiTextVisible", (Property)new SimpleBooleanProperty(poiTextVisible));
        return (B)this;
    }

    public final B pois(List<Poi> pois) {
        this.properties.put("pois", (Property)new SimpleObjectProperty(pois));
        return (B)this;
    }

    public final B heatmapVisible(boolean heatmapVisible) {
        this.properties.put("heatmapVisible", (Property)new SimpleBooleanProperty(heatmapVisible));
        return (B)this;
    }

    public final B heatmapSpots(List<Point> heatmapSpots) {
        this.properties.put("heatmapSpots", (Property)new SimpleObjectProperty(heatmapSpots));
        return (B)this;
    }

    public final B heatmapColorMapping(Mapping heatmapColorMapping) {
        this.properties.put("heatmapColorMapping", (Property)new SimpleObjectProperty((Object)heatmapColorMapping));
        return (B)this;
    }

    public final B heatmapSpotRadius(double heatmapSpotRadius) {
        this.properties.put("heatmapSpotRadius", (Property)new SimpleDoubleProperty(heatmapSpotRadius));
        return (B)this;
    }

    public final B heatmapFadeColors(boolean heatmapFadeColors) {
        this.properties.put("heatmapFadeColors", (Property)new SimpleBooleanProperty(heatmapFadeColors));
        return (B)this;
    }

    public final B heatmapOpacityDistribution(OpacityDistribution heatmapOpacityDistribution) {
        this.properties.put("heatmapOpacityDistribution", (Property)new SimpleObjectProperty((Object)heatmapOpacityDistribution));
        return (B)this;
    }

    public final B heatmapOpacity(double heatmapOpacity) {
        this.properties.put("heatmapOpacity", (Property)new SimpleDoubleProperty(heatmapOpacity));
        return (B)this;
    }

    public final B connections(List<Connection> connections) {
        this.properties.put("connections", (Property)new SimpleObjectProperty(connections));
        return (B)this;
    }

    public final B overlayVisible(boolean overlayVisible) {
        this.properties.put("overlayVisible", (Property)new SimpleBooleanProperty(overlayVisible));
        return (B)this;
    }

    public final B hoverEnabled(boolean hoverEnabled) {
        this.properties.put("hoverEnabled", (Property)new SimpleBooleanProperty(hoverEnabled));
        return (B)this;
    }

    public final B selectionEnabled(boolean selectionEnabled) {
        this.properties.put("selectionEnabled", (Property)new SimpleBooleanProperty(selectionEnabled));
        return (B)this;
    }

    public final B hoverColor(Color hoverColor) {
        this.properties.put("hoverColor", (Property)new SimpleObjectProperty((Object)hoverColor));
        return (B)this;
    }

    public final B pressedColor(Color pressedColor) {
        this.properties.put("pressedColor", (Property)new SimpleObjectProperty((Object)pressedColor));
        return (B)this;
    }

    public final B selectedColor(Color selectedColor) {
        this.properties.put("selectedColor", (Property)new SimpleObjectProperty((Object)selectedColor));
        return (B)this;
    }

    public final B mouseEnterHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseEnterHandler", (Property)new SimpleObjectProperty(handler));
        return (B)this;
    }

    public final B mousePressHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mousePressHandler", (Property)new SimpleObjectProperty(handler));
        return (B)this;
    }

    public final B mouseReleaseHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseReleaseHandler", (Property)new SimpleObjectProperty(handler));
        return (B)this;
    }

    public final B mouseExitHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseExitHandler", (Property)new SimpleObjectProperty(handler));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxheight) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(maxheight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)insets));
        return (B)this;
    }

    public final RegionPane build() {
        RegionPane regionPane = new RegionPane(this.region);
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    regionPane.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    regionPane.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    regionPane.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    regionPane.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    regionPane.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    regionPane.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    regionPane.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    regionPane.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    regionPane.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    regionPane.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    regionPane.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    regionPane.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    regionPane.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    regionPane.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    regionPane.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    regionPane.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "backgroundColor": {
                    regionPane.setBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "fill": {
                    regionPane.setFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "stroke": {
                    regionPane.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "lineWidth": {
                    regionPane.setLineWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "poiFill": {
                    regionPane.setPoiFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poiStroke": {
                    regionPane.setPoiStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poiTextFill": {
                    regionPane.setPoiTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poisVisible": {
                    regionPane.setPoisVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "poiTextVisible": {
                    regionPane.setPoiTextVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "pois": {
                    regionPane.addPois((List)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapVisible": {
                    regionPane.setHeatmapVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapSpots": {
                    regionPane.setHeatmapSpots((List)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapColorMapping": {
                    regionPane.setHeatmapColorMapping((Mapping)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapSpotRadius": {
                    regionPane.setHeatmapSpotRadius(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapFadeColors": {
                    regionPane.setHeatmapFadeColors(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapOpacityDistribution": {
                    regionPane.setHeatmapOpacityDistribution((OpacityDistribution)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapOpacity": {
                    regionPane.setHeatmapOpacity(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "connections": {
                    regionPane.setConnections((List)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "overlayVisible": {
                    regionPane.setOverlayVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "hoverEnabled": {
                    regionPane.setHoverEnabled(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectionEnabled": {
                    regionPane.setSelectionEnabled(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "hoverColor": {
                    regionPane.setHoverColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "pressedColor": {
                    regionPane.setPressedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectedColor": {
                    regionPane.setSelectedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "mouseEnterHandler": {
                    regionPane.setMouseEnterHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "mousePressHandler": {
                    regionPane.setMousePressHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "mouseReleaseHandler": {
                    regionPane.setMouseReleaseHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "mouseExitHandler": {
                    regionPane.setMouseExitHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                }
            }
        }
        return regionPane;
    }
}

