/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry.transform;

import eu.hansolo.fx.geometry.BaseBounds;
import eu.hansolo.fx.geometry.Path;
import eu.hansolo.fx.geometry.Rectangle;
import eu.hansolo.fx.geometry.Shape;
import eu.hansolo.fx.geometry.transform.Affine;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import eu.hansolo.toolboxfx.geom.Point;

public class Translate
extends BaseTransform {
    private double mxt;
    private double myt;

    public static BaseTransform getInstance(double mxt, double myt) {
        if (mxt == 0.0 && myt == 0.0) {
            return IDENTITY_TRANSFORM;
        }
        return new Translate(mxt, myt);
    }

    public Translate(double tx, double ty) {
        this.mxt = tx;
        this.myt = ty;
    }

    public Translate(BaseTransform tx) {
        if (!tx.isTranslateOrIdentity()) {
            Translate.degreeError(BaseTransform.Degree.TRANSLATE);
        }
        this.mxt = tx.getMxt();
        this.myt = tx.getMyt();
    }

    @Override
    public BaseTransform.Degree getDegree() {
        return BaseTransform.Degree.TRANSLATE;
    }

    @Override
    public double getDeterminant() {
        return 1.0;
    }

    @Override
    public double getMxt() {
        return this.mxt;
    }

    @Override
    public double getMyt() {
        return this.myt;
    }

    @Override
    public int getType() {
        return this.mxt == 0.0 && this.myt == 0.0 ? 0 : 1;
    }

    @Override
    public boolean isIdentity() {
        return this.mxt == 0.0 && this.myt == 0.0;
    }

    @Override
    public boolean isTranslateOrIdentity() {
        return true;
    }

    @Override
    public Point transform(Point src, Point dst) {
        if (dst == null) {
            dst = Translate.makePoint(src, dst);
        }
        dst.set(src.x + this.mxt, src.y + this.myt);
        return dst;
    }

    @Override
    public Point inverseTransform(Point src, Point dst) {
        if (dst == null) {
            dst = Translate.makePoint(src, dst);
        }
        dst.set(src.x - this.mxt, src.y - this.myt);
        return dst;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.mxt;
        double ty = this.myt;
        if (dstPts == srcPts) {
            if (dstOff > srcOff && dstOff < srcOff + numPts * 2) {
                System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
                srcOff = dstOff;
            }
            if ((double)Double.compare(dstOff, srcOff) == 0.0 && (double)Double.compare(tx, 0.0) == 0.0 && (double)Double.compare(ty, 0.0) == 0.0) {
                return;
            }
        }
        for (int i = 0; i < numPts; ++i) {
            dstPts[dstOff++] = srcPts[srcOff++] + tx;
            dstPts[dstOff++] = srcPts[srcOff++] + ty;
        }
    }

    @Override
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public void inverseDeltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.mxt;
        double ty = this.myt;
        if (dstPts == srcPts) {
            if (dstOff > srcOff && dstOff < srcOff + numPts * 2) {
                System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
                srcOff = dstOff;
            }
            if ((double)Double.compare(dstOff, srcOff) == 0.0 && (double)Double.compare(tx, 0.0) == 0.0 && (double)Double.compare(ty, 0.0) == 0.0) {
                return;
            }
        }
        for (int i = 0; i < numPts; ++i) {
            dstPts[dstOff++] = srcPts[srcOff++] - tx;
            dstPts[dstOff++] = srcPts[srcOff++] - ty;
        }
    }

    @Override
    public BaseBounds transform(BaseBounds bounds, BaseBounds result) {
        double minX = bounds.getMinX() + this.mxt;
        double minY = bounds.getMinY() + this.myt;
        double maxX = bounds.getMaxX() + this.mxt;
        double maxY = bounds.getMaxY() + this.myt;
        return result.deriveWithNewBounds(minX, minY, maxX, maxY);
    }

    @Override
    public void transform(Rectangle rect, Rectangle result) {
        Translate.transform(rect, result, this.mxt, this.myt);
    }

    @Override
    public BaseBounds inverseTransform(BaseBounds bounds, BaseBounds result) {
        double minX = bounds.getMinX() - this.mxt;
        double minY = bounds.getMinY() - this.myt;
        double maxX = bounds.getMaxX() - this.mxt;
        double maxY = bounds.getMaxY() - this.myt;
        return result.deriveWithNewBounds(minX, minY, maxX, maxY);
    }

    @Override
    public void inverseTransform(Rectangle rect, Rectangle result) {
        Translate.transform(rect, result, -this.mxt, -this.myt);
    }

    static void transform(Rectangle rect, Rectangle result, double mxt, double myt) {
        int imxt = (int)mxt;
        int imyt = (int)myt;
        if ((double)imxt == mxt && (double)imyt == myt) {
            result.setBounds(rect);
            result.translate(imxt, imyt);
        } else {
            double x1 = (double)rect.x + mxt;
            double y1 = (double)rect.y + myt;
            double x2 = Math.ceil(x1 + (double)rect.width);
            double y2 = Math.ceil(y1 + (double)rect.height);
            x1 = Math.floor(x1);
            y1 = Math.floor(y1);
            result.setBounds((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
        }
    }

    @Override
    public Shape createTransformedShape(Shape s) {
        return new Path(s, this);
    }

    @Override
    public void setToIdentity() {
        this.myt = 0.0;
        this.mxt = 0.0;
    }

    @Override
    public void setTransform(BaseTransform xform) {
        if (!xform.isTranslateOrIdentity()) {
            Translate.degreeError(BaseTransform.Degree.TRANSLATE);
        }
        this.mxt = xform.getMxt();
        this.myt = xform.getMyt();
    }

    @Override
    public void invert() {
        this.mxt = -this.mxt;
        this.myt = -this.myt;
    }

    @Override
    public void restoreTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        if (mxx != 1.0 || myx != 0.0 || mxy != 0.0 || myy != 1.0) {
            Translate.degreeError(BaseTransform.Degree.TRANSLATE);
        }
        this.mxt = mxt;
        this.myt = myt;
    }

    @Override
    public void restoreTransform(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxx != 1.0 || mxy != 0.0 || mxz != 0.0 || myx != 0.0 || myy != 1.0 || myz != 0.0 || mzx != 0.0 || mzy != 0.0 || mzz != 1.0 || mzt != 0.0) {
            Translate.degreeError(BaseTransform.Degree.TRANSLATE);
        }
        this.mxt = mxt;
        this.myt = myt;
    }

    @Override
    public BaseTransform deriveWithTranslation(double mxt, double myt) {
        this.mxt += mxt;
        this.myt += myt;
        return this;
    }

    @Override
    public BaseTransform deriveWithPreTranslation(double mxt, double myt) {
        this.mxt += mxt;
        this.myt += myt;
        return this;
    }

    @Override
    public BaseTransform deriveWithConcatenation(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        if (mxx == 1.0 && myx == 0.0 && mxy == 0.0 && myy == 1.0) {
            this.mxt += mxt;
            this.myt += myt;
            return this;
        }
        return new Affine(mxx, myx, mxy, myy, this.mxt + mxt, this.myt + myt);
    }

    @Override
    public BaseTransform deriveWithConcatenation(BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            this.mxt += tx.getMxt();
            this.myt += tx.getMyt();
            return this;
        }
        return Translate.getInstance(tx.getMxx(), tx.getMyx(), tx.getMxy(), tx.getMyy(), this.mxt + tx.getMxt(), this.myt + tx.getMyt());
    }

    @Override
    public BaseTransform deriveWithPreConcatenation(BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            this.mxt += tx.getMxt();
            this.myt += tx.getMyt();
            return this;
        }
        Affine t2d = new Affine(tx);
        t2d.translate(this.mxt, this.myt);
        return t2d;
    }

    @Override
    public BaseTransform deriveWithNewTransform(BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            this.mxt = tx.getMxt();
            this.myt = tx.getMyt();
            return this;
        }
        return Translate.getInstance(tx);
    }

    @Override
    public BaseTransform createInverse() {
        return this.isIdentity() ? IDENTITY_TRANSFORM : new Translate(-this.mxt, -this.myt);
    }

    private static double _matRound(double value) {
        return Math.rint(value * 1.0E15) / 1.0E15;
    }

    @Override
    public BaseTransform copy() {
        return new Translate(this.mxt, this.myt);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BaseTransform) {
            BaseTransform tx = (BaseTransform)obj;
            return tx.isTranslateOrIdentity() && tx.getMxt() == this.mxt && tx.getMyt() == this.myt;
        }
        return false;
    }
}

