/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import eu.hansolo.fx.charts.wafermap.ClassConfig;
import eu.hansolo.fx.charts.wafermap.KLA;
import eu.hansolo.fx.charts.wafermap.WaferMap;
import eu.hansolo.fx.heatmap.ColorMapping;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class WaferMapBuilder<B extends WaferMapBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected WaferMapBuilder() {
    }

    public static final WaferMapBuilder create() {
        return new WaferMapBuilder();
    }

    public final B filename(String filename) {
        this.properties.put("filename", (Property)new SimpleStringProperty(filename));
        return (B)this;
    }

    public final B kla(KLA kla) {
        this.properties.put("kla", (Property)new SimpleObjectProperty((Object)kla));
        return (B)this;
    }

    public final B waferFill(Color waferFill) {
        this.properties.put("waferFill", (Property)new SimpleObjectProperty((Object)waferFill));
        return (B)this;
    }

    public final B waferStroke(Color waferStroke) {
        this.properties.put("waferStroke", (Property)new SimpleObjectProperty((Object)waferStroke));
        return (B)this;
    }

    public final B notchFill(Color notchFill) {
        this.properties.put("notchFill", (Property)new SimpleObjectProperty((Object)notchFill));
        return (B)this;
    }

    public final B defectFill(Color defectFill) {
        this.properties.put("defectFill", (Property)new SimpleObjectProperty((Object)defectFill));
        return (B)this;
    }

    public final B defectStroke(Color defectStroke) {
        this.properties.put("defectStroke", (Property)new SimpleObjectProperty((Object)defectStroke));
        return (B)this;
    }

    public final B selectionColor(Color selectionColor) {
        this.properties.put("selectionColor", (Property)new SimpleObjectProperty((Object)selectionColor));
        return (B)this;
    }

    public final B dieTextFill(Color dieTextFill) {
        this.properties.put("dieTextFill", (Property)new SimpleObjectProperty((Object)dieTextFill));
        return (B)this;
    }

    public final B dieTextVisible(boolean dieTextVisible) {
        this.properties.put("dieTextVisible", (Property)new SimpleBooleanProperty(dieTextVisible));
        return (B)this;
    }

    public final B densityColorsVisible(boolean densityColorsVisible) {
        this.properties.put("densityColorsVisible", (Property)new SimpleBooleanProperty(densityColorsVisible));
        return (B)this;
    }

    public final B legendVisible(boolean legendVisible) {
        this.properties.put("legendVisible", (Property)new SimpleBooleanProperty(legendVisible));
        return (B)this;
    }

    public final B defectsVisible(boolean defectsVisible) {
        this.properties.put("defectsVisible", (Property)new SimpleBooleanProperty(defectsVisible));
        return (B)this;
    }

    public final B heatmapVisible(boolean heatmapVisible) {
        this.properties.put("heatmapVisible", (Property)new SimpleBooleanProperty(heatmapVisible));
        return (B)this;
    }

    public final B heatmapColorMapping(ColorMapping colorMapping) {
        this.properties.put("heatmapColorMapping", (Property)new SimpleObjectProperty((Object)colorMapping));
        return (B)this;
    }

    public final B heatmapSpotRadius(double spotRadius) {
        this.properties.put("heatmapSpotRadius", (Property)new SimpleDoubleProperty(spotRadius));
        return (B)this;
    }

    public final B heatmapOpacity(double opacity) {
        this.properties.put("heatmapOpacity", (Property)new SimpleDoubleProperty(opacity));
        return (B)this;
    }

    public final B classConfigMap(Map<Integer, ClassConfig> classConfigMap) {
        this.properties.put("classConfigMap", (Property)new SimpleObjectProperty(classConfigMap));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxHeight) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(maxHeight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)insets));
        return (B)this;
    }

    public final WaferMap build() {
        WaferMap wafermap;
        if (this.properties.keySet().contains("filename")) {
            String filename = (String)((StringProperty)this.properties.get("filename")).get();
            wafermap = new WaferMap(filename);
        } else {
            wafermap = new WaferMap();
        }
        if (this.properties.keySet().contains("kla")) {
            wafermap.setKla((KLA)((ObjectProperty)this.properties.get("kla")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    wafermap.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    wafermap.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    wafermap.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    wafermap.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    wafermap.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    wafermap.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    wafermap.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    wafermap.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    wafermap.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    wafermap.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    wafermap.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    wafermap.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    wafermap.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    wafermap.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    wafermap.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    wafermap.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "waferFill": {
                    wafermap.setWaferFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "waferStroke": {
                    wafermap.setWaferStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "notchFill": {
                    wafermap.setNotchFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "defectFill": {
                    wafermap.setDefectFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "defectStroke": {
                    wafermap.setDefectStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectionColor": {
                    wafermap.setSelectionColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "dieTextFill": {
                    wafermap.setDieTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "dieTextVisible": {
                    wafermap.setDieTextVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "densityColorsVisible": {
                    wafermap.setDensityColorsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "legendVisible": {
                    wafermap.setLegendVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "defectsVisible": {
                    wafermap.setDefectsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapVisible": {
                    wafermap.setHeatmapVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapColorMapping": {
                    wafermap.setHeatmapColorMapping((ColorMapping)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapSpotRadius": {
                    wafermap.setHeatmapSpotRadius(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapOpacity": {
                    wafermap.setHeatmapOpacity(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "classConfigMap": {
                    wafermap.setClassConfigMap((Map)((ObjectProperty)this.properties.get(key)).get());
                }
            }
        }
        return wafermap;
    }
}

