/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.wafermap.ClassConfig;
import eu.hansolo.fx.charts.wafermap.Constants;
import eu.hansolo.fx.charts.wafermap.Defect;
import eu.hansolo.fx.charts.wafermap.Die;
import eu.hansolo.fx.charts.wafermap.KLA;
import eu.hansolo.fx.charts.wafermap.KLAParser;
import eu.hansolo.fx.geometry.Rectangle;
import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.HeatMap;
import eu.hansolo.fx.heatmap.HeatMapBuilder;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class WaferMap
extends Region {
    private static final double PREFERRED_WIDTH = 500.0;
    private static final double PREFERRED_HEIGHT = 500.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private double size;
    private double width;
    private double height;
    private BooleanBinding showing;
    private Canvas canvas;
    private GraphicsContext ctx;
    private HeatMap heatmap;
    private StackPane pane;
    private KLA kla;
    private double factor;
    private double defectSize;
    private double halfDefectSize;
    private double centerX;
    private double centerY;
    private double diameter;
    private double notchSize;
    private double minDieSize;
    private double fontSize;
    private Color _waferFill;
    private ObjectProperty<Color> waferFill;
    private Color _waferStroke;
    private ObjectProperty<Color> waferStroke;
    private Color _notchFill;
    private ObjectProperty<Color> notchFill;
    private Color _defectFill;
    private ObjectProperty<Color> defectFill;
    private Color _defectStroke;
    private ObjectProperty<Color> defectStroke;
    private Color _dieTextFill;
    private ObjectProperty<Color> dieTextFill;
    private Color _selectionColor;
    private ObjectProperty<Color> selectionColor;
    private List<Color> defectDensityColors;
    private boolean _dieTextVisible;
    private BooleanProperty dieTextVisible;
    private boolean _densityColorsVisible;
    private BooleanProperty densityColorsVisible;
    private boolean _legendVisible;
    private BooleanProperty legendVisible;
    private boolean _defectsVisible;
    private BooleanProperty defectsVisible;
    private boolean _heatmapVisible;
    private BooleanProperty heatmapVisible;
    private ObservableMap<Integer, ClassConfig> classConfigMap;
    private ObjectProperty<Die> selectedDie;
    private Map<String, Rectangle> dieMap;
    private EventHandler<MouseEvent> mouseHandler;

    public WaferMap() {
        this("");
    }

    public WaferMap(String filename) {
        Optional<KLA> klaOpt;
        this.kla = null != filename && !filename.isEmpty() ? ((klaOpt = KLAParser.INSTANCE.parse(filename)).isPresent() ? klaOpt.get() : new KLA()) : new KLA();
        this.kla.createDieMap();
        this._waferFill = Constants.DEFAULT_WAFER_FILL;
        this._waferStroke = Constants.DEFAULT_WAFER_STROKE;
        this._notchFill = Constants.DEFAULT_NOTCH_FILL;
        this._defectFill = Constants.DEFAULT_DEFECT_FILL;
        this._defectStroke = Constants.DEFAULT_DEFECT_STROKE;
        this._dieTextFill = Constants.DEFAULT_DIE_LABEL_FILL;
        this._selectionColor = Constants.DEFAULT_SELECTION_COLOR;
        this.defectDensityColors = Constants.DEFAULT_DEFECT_DENSITY_COLORS;
        this._dieTextVisible = false;
        this._densityColorsVisible = false;
        this._legendVisible = false;
        this._defectsVisible = true;
        this._heatmapVisible = false;
        this.classConfigMap = FXCollections.observableHashMap();
        this.selectedDie = new SimpleObjectProperty(null);
        this.dieMap = new HashMap<String, Rectangle>();
        this.mouseHandler = e -> {
            EventType type = e.getEventType();
            if (MouseEvent.MOUSE_PRESSED.equals(type)) {
                this.mousePressed((MouseEvent)e);
            }
        };
        this.initGraphics();
        this.registerListeners();
        this.initBindings();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(500.0, 500.0);
            }
        }
        this.canvas = new Canvas(500.0, 500.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.heatmap = HeatMapBuilder.create().prefSize(500.0, 500.0).colorMapping((Mapping)ColorMapping.BLUE_CYAN_GREEN_YELLOW_RED).spotRadius(10.0).fadeColors(true).opacityDistribution(OpacityDistribution.LINEAR).heatMapOpacity(0.75).build();
        this.heatmap.setVisible(false);
        this.heatmap.setManaged(false);
        this.heatmap.setMouseTransparent(true);
        this.pane = new StackPane(new Node[]{this.canvas, this.heatmap});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.canvas.addEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.classConfigMap.addListener(change -> this.redraw());
    }

    private void initBindings() {
        this.showing = Bindings.selectBoolean((ObservableValue)this.sceneProperty(), (String[])new String[]{"window", "showing"});
        this.showing.addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                // empty if block
            }
        });
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 2048.0;
    }

    protected double computeMaxHeight(double width) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void setKla(KLA kla) {
        this.heatmap.clearHeatMap();
        this.kla = kla;
        this.kla.createDieMap();
        this.resize();
        this.redraw();
    }

    public Color getWaferFill() {
        return null == this.waferFill ? this._waferFill : (Color)this.waferFill.get();
    }

    public void setWaferFill(Color waferFill) {
        if (null == this.waferFill) {
            this._waferFill = waferFill;
            this.redraw();
        } else {
            this.waferFill.set((Object)waferFill);
        }
    }

    public ObjectProperty<Color> waferFillProperty() {
        if (null == this.waferFill) {
            this.waferFill = new ObjectPropertyBase<Color>(this._waferFill){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "waferdsFill";
                }
            };
            this._waferFill = null;
        }
        return this.waferFill;
    }

    public Color getWaferStroke() {
        return null == this.waferStroke ? this._waferStroke : (Color)this.waferStroke.get();
    }

    public void setWaferStroke(Color waferStroke) {
        if (null == this.waferStroke) {
            this._waferStroke = waferStroke;
            this.redraw();
        } else {
            this.waferStroke.set((Object)waferStroke);
        }
    }

    public ObjectProperty<Color> waferStrokeProperty() {
        if (null == this.waferStroke) {
            this.waferStroke = new ObjectPropertyBase<Color>(this._waferStroke){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "waferStroke";
                }
            };
            this._waferStroke = null;
        }
        return this.waferStroke;
    }

    public Color getNotchFill() {
        return null == this.notchFill ? this._notchFill : (Color)this.notchFill.get();
    }

    public void setNotchFill(Color notchFill) {
        if (null == this.notchFill) {
            this._notchFill = notchFill;
            this.redraw();
        } else {
            this.notchFill.set((Object)notchFill);
        }
    }

    public ObjectProperty<Color> notchFillProperty() {
        if (null == this.notchFill) {
            this.notchFill = new ObjectPropertyBase<Color>(this._notchFill){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "notchFill";
                }
            };
            this._notchFill = null;
        }
        return this.notchFill;
    }

    public Color getDefectFill() {
        return null == this.defectFill ? this._defectFill : (Color)this.defectFill.get();
    }

    public void setDefectFill(Color defectFill) {
        if (null == this.defectFill) {
            this._defectFill = defectFill;
            this.redraw();
        } else {
            this.defectFill.set((Object)defectFill);
        }
    }

    public ObjectProperty<Color> defectFillProperty() {
        if (null == this.defectFill) {
            this.defectFill = new ObjectPropertyBase<Color>(this._defectFill){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "defectFill";
                }
            };
            this._defectFill = null;
        }
        return this.defectFill;
    }

    public Color getDefectStroke() {
        return null == this.defectStroke ? this._defectStroke : (Color)this.defectStroke.get();
    }

    public void setDefectStroke(Color defectStroke) {
        if (null == this.defectStroke) {
            this._defectStroke = defectStroke;
            this.redraw();
        } else {
            this.defectStroke.set((Object)defectStroke);
        }
    }

    public ObjectProperty<Color> defectStrokeProperty() {
        if (null == this.defectStroke) {
            this.defectStroke = new ObjectPropertyBase<Color>(this._defectStroke){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "defectStroke";
                }
            };
            this._defectStroke = null;
        }
        return this.defectStroke;
    }

    public Color getDieTextFill() {
        return null == this.dieTextFill ? this._dieTextFill : (Color)this.dieTextFill.get();
    }

    public void setDieTextFill(Color dieTextFill) {
        if (null == this.dieTextFill) {
            this._dieTextFill = dieTextFill;
            this.redraw();
        } else {
            this.dieTextFill.set((Object)dieTextFill);
        }
    }

    public ObjectProperty<Color> dieTextFillProperty() {
        if (null == this.dieTextFill) {
            this.dieTextFill = new ObjectPropertyBase<Color>(this._dieTextFill){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "dieLabelFill";
                }
            };
            this._dieTextFill = null;
        }
        return this.dieTextFill;
    }

    public Color getSelectionColor() {
        return null == this.selectionColor ? this._selectionColor : (Color)this.selectionColor.get();
    }

    public void setSelectionColor(Color selectionColor) {
        if (null == this.selectionColor) {
            this._selectionColor = selectionColor;
            this.redraw();
        } else {
            this.selectionColor.set((Object)selectionColor);
        }
    }

    public ObjectProperty<Color> selectionColorProperty() {
        if (null == this.selectionColor) {
            this.selectionColor = new ObjectPropertyBase<Color>(this._selectionColor){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "selectionColor";
                }
            };
            this._selectionColor = null;
        }
        return this.selectionColor;
    }

    public boolean getDieTextVisible() {
        return null == this.dieTextVisible ? this._dieTextVisible : this.dieTextVisible.get();
    }

    public void setDieTextVisible(boolean dieTextVisible) {
        if (null == this.dieTextVisible) {
            this._dieTextVisible = dieTextVisible;
            this.redraw();
        } else {
            this.dieTextVisible.set(dieTextVisible);
        }
    }

    public BooleanProperty dieTextVisibleProperty() {
        if (null == this.dieTextVisible) {
            this.dieTextVisible = new BooleanPropertyBase(this._dieTextVisible){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "dieLabelsVisible";
                }
            };
        }
        return this.dieTextVisible;
    }

    public boolean getDensityColorsVisible() {
        return null == this.densityColorsVisible ? this._densityColorsVisible : this.densityColorsVisible.get();
    }

    public void setDensityColorsVisible(boolean densityColorsVisible) {
        if (null == this.densityColorsVisible) {
            this._densityColorsVisible = densityColorsVisible;
            this.redraw();
        } else {
            this.densityColorsVisible.set(densityColorsVisible);
        }
    }

    public BooleanProperty densityColorsVisibleProperty() {
        if (null == this.densityColorsVisible) {
            this.densityColorsVisible = new BooleanPropertyBase(this._densityColorsVisible){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "densityColorsVisible";
                }
            };
        }
        return this.densityColorsVisible;
    }

    public boolean getLegendVisible() {
        return null == this.legendVisible ? this._legendVisible : this.legendVisible.get();
    }

    public void setLegendVisible(boolean legendVisible) {
        if (null == this.legendVisible) {
            this._legendVisible = legendVisible;
            this.redraw();
        } else {
            this.legendVisible.set(legendVisible);
        }
    }

    public BooleanProperty legendVisibleProperty() {
        if (null == this.legendVisible) {
            this.legendVisible = new BooleanPropertyBase(this._legendVisible){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "legendVisible";
                }
            };
        }
        return this.legendVisible;
    }

    public boolean getDefectsVisible() {
        return null == this.defectsVisible ? this._defectsVisible : this.defectsVisible.get();
    }

    public void setDefectsVisible(boolean defectsVisible) {
        if (null == this.defectsVisible) {
            this._defectsVisible = defectsVisible;
            this.redraw();
        } else {
            this.defectsVisible.set(defectsVisible);
        }
    }

    public BooleanProperty defectsVisibleProperty() {
        if (null == this.defectsVisible) {
            this.defectsVisible = new BooleanPropertyBase(this._defectsVisible){

                protected void invalidated() {
                    WaferMap.this.redraw();
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "defectsVisible";
                }
            };
        }
        return this.defectsVisible;
    }

    public boolean getHeatmapVisible() {
        return null == this.heatmapVisible ? this._heatmapVisible : this.heatmapVisible.get();
    }

    public void setHeatmapVisible(boolean heatmapVisible) {
        if (null == this.heatmapVisible) {
            this._heatmapVisible = heatmapVisible;
            this.heatmap.setVisible(heatmapVisible);
            this.heatmap.setManaged(heatmapVisible);
            if (heatmapVisible) {
                this.heatmap.clearHeatMap();
                this.resize();
            }
            this.resize();
        } else {
            this.heatmapVisible.set(heatmapVisible);
        }
    }

    public BooleanProperty heatmapVisibleProperty() {
        if (null == this.heatmapVisible) {
            this.heatmapVisible = new BooleanPropertyBase(this._heatmapVisible){

                protected void invalidated() {
                    WaferMap.this.heatmap.setVisible(this.get());
                    WaferMap.this.heatmap.setManaged(this.get());
                    if (this.get()) {
                        WaferMap.this.heatmap.clearHeatMap();
                        WaferMap.this.resize();
                    }
                }

                public Object getBean() {
                    return WaferMap.this;
                }

                public String getName() {
                    return "heatmapVisible";
                }
            };
        }
        return this.heatmapVisible;
    }

    public void setHeatmapColorMapping(ColorMapping colorMapping) {
        this.heatmap.setColorMapping((Mapping)colorMapping);
        if (this.getHeatmapVisible()) {
            this.heatmap.clearHeatMap();
            this.resize();
        }
    }

    public void setHeatmapSpotRadius(double spotRadius) {
        this.heatmap.setSpotRadius(Helper.clamp(1.0, 20.0, spotRadius));
        if (this.getHeatmapVisible()) {
            this.heatmap.clearHeatMap();
            this.resize();
        }
    }

    public void setHeatmapOpacity(double opacity) {
        this.heatmap.setOpacity(Helper.clamp(0.0, 1.0, opacity));
    }

    public void setClassConfigMap(Map<Integer, ClassConfig> classConfigMap) {
        this.classConfigMap.clear();
        this.classConfigMap.putAll(classConfigMap);
    }

    public void setClassConfig(int classNumber, ClassConfig classConfig) {
        if (classNumber < 0) {
            throw new IllegalArgumentException("ClassNumber cannot be smaller than 0");
        }
        this.classConfigMap.put((Object)classNumber, (Object)classConfig);
    }

    public void removeClassConfig(int classNumber) {
        if (this.classConfigMap.containsKey((Object)classNumber)) {
            this.classConfigMap.remove((Object)classNumber);
        }
    }

    public void clearClassConfig() {
        this.classConfigMap.clear();
        this.redraw();
    }

    public Die getSelectedDie() {
        return (Die)this.selectedDie.get();
    }

    public ReadOnlyObjectProperty<Die> selectedDieProperty() {
        return this.selectedDie;
    }

    public void dispose() {
        this.canvas.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    private void createHeatmap() {
        this.heatmap.clearHeatMap();
        ArrayList<Point> spots = new ArrayList<Point>();
        for (Die die : this.kla.getDies().values()) {
            for (Defect defect : die.getDefects()) {
                double tmpXAbsolute = (die.getOriginX() + (die.getSizeX() * (double)die.getXIndex() + defect.getXRel()) / 1000.0) * this.factor;
                double tmpYAbsolute = (die.getOriginY() + (die.getSizeY() * (double)die.getYIndex() + defect.getYRel()) / 1000.0) * this.factor;
                spots.add(new Point(tmpXAbsolute, tmpYAbsolute));
            }
        }
        this.heatmap.setSpots(spots);
    }

    private void mousePressed(MouseEvent e) {
        Optional optDieName;
        Optional<Rectangle> optRect = this.dieMap.values().stream().filter(rect -> rect.contains(e.getX(), e.getY())).findFirst();
        if (optRect.isPresent() && (optDieName = Helper.getKeysByValue(this.dieMap, optRect.get()).stream().findFirst()).isPresent()) {
            Die selected = this.kla.getDies().get(optDieName.get());
            if (null == this.selectedDie.get()) {
                this.selectedDie.set((Object)selected);
            } else {
                this.selectedDie.set((Object)(((Die)this.selectedDie.get()).equals(selected) ? null : selected));
            }
            this.redraw();
        }
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.factor = this.size / this.kla.getSampleSize();
            this.defectSize = Helper.clamp(1.0, 3.0, this.size / 150.0);
            this.halfDefectSize = this.defectSize * 0.5;
            this.centerX = this.size * 0.5;
            this.centerY = this.size * 0.5;
            this.diameter = this.kla.getSampleSize() * this.factor;
            this.notchSize = this.diameter / 200.0;
            this.minDieSize = Math.min(this.kla.getDiePitchX(), this.kla.getDiePitchY()) / 2000.0;
            this.fontSize = this.minDieSize * this.factor;
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.canvas.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.heatmap.setFitWidth(this.size);
            this.heatmap.setFitHeight(this.size);
            this.heatmap.relocate((this.getWidth() - this.canvas.getWidth()) * 0.5, (this.getHeight() - this.canvas.getHeight()) * 0.5);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            if (this.getHeatmapVisible() && this.heatmap.getSpots().isEmpty()) {
                this.createHeatmap();
            }
            this.redraw();
        }
    }

    private void redraw() {
        this.dieMap.clear();
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        Color waferFill = this.getWaferFill();
        Color waferStroke = this.getWaferStroke();
        this.ctx.setLineWidth(0.5);
        this.ctx.setFill((Paint)waferFill);
        this.ctx.setStroke((Paint)waferStroke);
        this.ctx.fillOval(0.0, 0.0, this.diameter, this.diameter);
        this.ctx.strokeOval(0.0, 0.0, this.diameter, this.diameter);
        switch (this.kla.getOrientationMarkLocation()) {
            case UP: {
                this.ctx.setFill((Paint)this.getNotchFill());
                this.ctx.fillOval(this.centerX - this.notchSize, this.notchSize * 1.5, this.notchSize * 1.5, this.notchSize * 3.0);
                break;
            }
            case RIGHT: {
                this.ctx.setFill((Paint)this.getNotchFill());
                this.ctx.fillOval(this.diameter - this.notchSize * 1.5, this.centerY - this.notchSize, this.notchSize * 3.0, this.notchSize * 1.5);
                break;
            }
            case DOWN: {
                this.ctx.setFill((Paint)this.getNotchFill());
                this.ctx.fillOval(this.centerX - this.notchSize, this.diameter - this.notchSize * 1.5, this.notchSize * 1.5, this.notchSize * 3.0);
                break;
            }
            case LEFT: {
                this.ctx.setFill((Paint)this.getNotchFill());
                this.ctx.fillOval(this.notchSize * 1.5, this.centerY - this.notchSize, this.notchSize * 3.0, this.notchSize * 1.5);
                break;
            }
        }
        this.ctx.setFont(Font.font((double)this.fontSize));
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.kla.getDies().entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            Die die = (Die)entry.getValue();
            double x = die.getOriginX() * this.factor;
            double y = die.getOriginY() * this.factor;
            double w = die.getSizeX() * this.factor;
            double h = die.getSizeY() * this.factor;
            if (this.getDensityColorsVisible()) {
                this.ctx.save();
                int d = die.getNoOfDefects();
                if (d > 100) {
                    this.ctx.setFill((Paint)this.defectDensityColors.get(6));
                } else if (d > 60) {
                    this.ctx.setFill((Paint)this.defectDensityColors.get(5));
                } else if (d > 40) {
                    this.ctx.setFill((Paint)this.defectDensityColors.get(4));
                } else if (d > 20) {
                    this.ctx.setFill((Paint)this.defectDensityColors.get(3));
                } else if (d > 10) {
                    this.ctx.setFill((Paint)this.defectDensityColors.get(2));
                } else if (d > 0) {
                    this.ctx.setFill((Paint)this.defectDensityColors.get(1));
                } else {
                    this.ctx.setFill((Paint)Color.TRANSPARENT);
                }
                this.ctx.fillRect(x, y, w, h);
                this.ctx.restore();
            }
            this.ctx.setStroke((Paint)waferStroke);
            this.ctx.strokeRect(x, y, w, h);
            this.dieMap.put(die.getName(), new Rectangle(x, y, w, h));
            if (this.fontSize > 5.0 && this.getDieTextVisible()) {
                this.ctx.setFill((Paint)this.getDieTextFill());
                this.ctx.fillText(name, x + w * 0.5, y + h * 0.5, w);
            }
        });
        if (null != this.getSelectedDie()) {
            this.ctx.save();
            this.ctx.setLineWidth(1.0);
            Rectangle selectionRect = this.dieMap.get(this.getSelectedDie().getName());
            this.ctx.setStroke((Paint)this.getSelectionColor());
            this.ctx.strokeRect((double)selectionRect.x, (double)selectionRect.y, (double)selectionRect.width, (double)selectionRect.height);
            this.ctx.restore();
        }
        if (this.getDefectsVisible()) {
            for (Die die : this.kla.getDies().values()) {
                for (Defect defect : die.getDefects()) {
                    boolean drawDefect;
                    if (this.classConfigMap.isEmpty()) {
                        this.ctx.setFill((Paint)this.getDefectFill());
                        this.ctx.setStroke((Paint)this.getDefectStroke());
                        drawDefect = true;
                    } else {
                        int classNumber = defect.getClassNumber();
                        if (this.classConfigMap.containsKey((Object)classNumber)) {
                            drawDefect = ((ClassConfig)this.classConfigMap.get((Object)classNumber)).visible();
                            this.ctx.setFill((Paint)((ClassConfig)this.classConfigMap.get((Object)classNumber)).fill());
                            this.ctx.setStroke((Paint)((ClassConfig)this.classConfigMap.get((Object)classNumber)).stroke());
                        } else {
                            drawDefect = false;
                            this.ctx.setFill((Paint)this.getDefectFill());
                            this.ctx.setStroke((Paint)this.getDefectStroke());
                        }
                    }
                    if (!drawDefect || this.kla.getClasses().stream().filter(clazz -> clazz.getId() == defect.getClassNumber()).count() <= 0L) continue;
                    double tmpXAbsolute = (die.getOriginX() + (die.getSizeX() * (double)die.getXIndex() + defect.getXRel()) / 1000.0) * this.factor;
                    double tmpYAbsolute = (die.getOriginY() + (die.getSizeY() * (double)die.getYIndex() + defect.getYRel()) / 1000.0) * this.factor;
                    this.ctx.fillOval(tmpXAbsolute - this.halfDefectSize, tmpYAbsolute - this.halfDefectSize, this.defectSize, this.defectSize);
                    this.ctx.strokeOval(tmpXAbsolute - this.halfDefectSize, tmpYAbsolute - this.halfDefectSize, this.defectSize, this.defectSize);
                }
            }
        }
        if (this.size > 320.0 && this.getLegendVisible()) {
            double boxSize = 0.02 * this.size;
            block16: for (int i = 6; i > 0; --i) {
                double y = this.size - 10.0 - (double)i * (boxSize + 5.0);
                this.ctx.setFill((Paint)this.defectDensityColors.get(i));
                this.ctx.fillRect(10.0, y, boxSize, boxSize);
                this.ctx.setFill((Paint)Color.BLACK);
                switch (i) {
                    case 6: {
                        this.ctx.fillText(" > 100", 3.0 * boxSize, y + boxSize * 0.5);
                        continue block16;
                    }
                    case 5: {
                        this.ctx.fillText(" >  60", 3.0 * boxSize, y + boxSize * 0.5);
                        continue block16;
                    }
                    case 4: {
                        this.ctx.fillText(" >  40", 3.0 * boxSize, y + boxSize * 0.5);
                        continue block16;
                    }
                    case 3: {
                        this.ctx.fillText(" >  20", 3.0 * boxSize, y + boxSize * 0.5);
                        continue block16;
                    }
                    case 2: {
                        this.ctx.fillText(" >  10", 3.0 * boxSize, y + boxSize * 0.5);
                        continue block16;
                    }
                    case 1: {
                        this.ctx.fillText(" >   0", 3.0 * boxSize, y + boxSize * 0.5);
                    }
                }
            }
        }
    }
}

