/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import eu.hansolo.fx.charts.wafermap.Defect;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Die {
    private final int indexX;
    private final int indexY;
    private final int parentId;
    private final double originX;
    private final double originY;
    private final double sizeX;
    private final double sizeY;
    private final String name;
    private final double offsetX;
    private final double offsetY;
    private final ArrayList<Defect> defects;
    private boolean visible;
    private int rectangleArrayID;

    public Die(int xIndex, int yIndex, int parentId, double originX, double originY, double sizeX, double sizeY, String name, double offsetX, double offsetY) {
        this.indexX = xIndex;
        this.indexY = yIndex;
        this.parentId = parentId;
        this.originX = originX;
        this.originY = originY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.name = name;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.defects = new ArrayList();
        this.visible = false;
        this.rectangleArrayID = -1;
    }

    public ArrayList<Defect> getDefects() {
        return new ArrayList<Defect>(this.defects);
    }

    public void setDefects(List<Defect> defects) {
        this.defects.clear();
        this.defects.addAll(defects);
    }

    public void addDefect(Defect defect) {
        if (this.defects.contains(defect)) {
            return;
        }
        this.defects.add(defect);
    }

    public void removeDefect(Defect defect) {
        if (this.defects.contains(defect)) {
            this.defects.remove(defect);
        }
    }

    public void clearDefects() {
        this.defects.clear();
    }

    public int getNoOfDefects() {
        return this.defects.size();
    }

    public Optional<Defect> getDefect(int index) {
        if (index < 0 || index > this.defects.size()) {
            return Optional.empty();
        }
        return Optional.of(this.defects.get(index));
    }

    public Optional<Defect> getDefectById(int defectId) {
        return this.defects.stream().filter(defect -> defect.equals(defectId)).findFirst();
    }

    public int getRectangleArrayId() {
        return this.rectangleArrayID;
    }

    public void setRectangleArrayId(int id) {
        this.rectangleArrayID = id;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public int getXIndex() {
        return this.indexX;
    }

    public int getYIndex() {
        return this.indexY;
    }

    public int getParentId() {
        return this.parentId;
    }

    public double getOriginX() {
        return this.originX;
    }

    public double getOriginY() {
        return this.originY;
    }

    public double getSizeX() {
        return this.sizeX;
    }

    public double getSizeY() {
        return this.sizeY;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

