/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ArraySet<E>
extends AbstractSet<E> {
    private ArrayList<E> items;

    public ArraySet() {
        this(new ArrayList(3));
    }

    public ArraySet(int initialCapacity) {
        this(new ArrayList(initialCapacity));
    }

    public ArraySet(Collection<? extends E> collection) {
        this.items = new ArrayList(collection.size());
        for (E item : collection) {
            if (this.items.contains(item)) continue;
            this.items.add(item);
        }
    }

    public E get(int index) throws IndexOutOfBoundsException {
        return this.items.get(index);
    }

    public boolean containsAny(Collection<?> collection) {
        return collection.stream().filter(item -> this.contains(item)).findFirst().isPresent();
    }

    @Override
    public boolean add(E item) {
        if (this.items.contains(item)) {
            return false;
        }
        return this.items.add(item);
    }

    @Override
    public Iterator<E> iterator() {
        return this.items.iterator();
    }

    @Override
    public int size() {
        return this.items.size();
    }
}

