/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.tools.P2d;
import eu.hansolo.fx.charts.tools.P3d;

public class PMatrix {
    public P2d xAxis;
    public P2d yAxis;
    public P2d zAxis;
    public P3d depth;
    public P2d origin;

    public PMatrix(P2d xAxis, P2d yAxis, P2d zAxis, P3d depth, P2d origin) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        this.depth = depth;
        this.origin = origin;
    }

    public void setProjection(PMatrix pMatrix) {
        this.xAxis = pMatrix.xAxis;
        this.yAxis = pMatrix.yAxis;
        this.zAxis = pMatrix.zAxis;
        if (null == pMatrix.depth) {
            this.depth = null == pMatrix.depth ? new P3d(this.xAxis.y, this.yAxis.y, -this.zAxis.y) : pMatrix.depth;
        }
    }

    public P3d project(P3d p) {
        double x = p.x * this.xAxis.x + p.y * this.yAxis.x + p.z * this.zAxis.x + this.origin.x;
        double y = p.x * this.xAxis.y + p.y * this.yAxis.y + p.z * this.zAxis.y + this.origin.y;
        double z = p.x * this.depth.x + p.y * this.depth.y + p.z * this.depth.z;
        return new P3d(x, y, z);
    }
}

