/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.data.BubbleGridChartItem;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.event.SelectionEvt;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.toolboxfx.font.Fonts;
import java.util.Locale;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.LongProperty;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Duration;

public class InfoPopup
extends Popup {
    public static long MAX_TIMEOUT = 10000L;
    public static int MAX_DECIMALS = 6;
    public static Color DEFAULT_BACKGROUND_COLOR = Color.rgb((int)0, (int)0, (int)0, (double)0.75);
    public static Color DEFAULT_TEXT_COLOR = Color.WHITE;
    private HBox hBox;
    private Text seriesText;
    private Text seriesSumText;
    private Text itemText;
    private Text valueText;
    private Line line;
    private Text seriesNameText;
    private Text seriesValueText;
    private Text itemNameText;
    private Text itemValueText;
    private FadeTransition fadeIn;
    private FadeTransition fadeOut;
    private PauseTransition delay;
    private Color _backgroundColor = DEFAULT_BACKGROUND_COLOR;
    private ObjectProperty<Color> backgroundColor;
    private Color _textColor = DEFAULT_TEXT_COLOR;
    private ObjectProperty<Color> textColor;
    private long _timeout = 4000L;
    private LongProperty timeout;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private String _unit = "";
    private StringProperty unit;
    private String formatString = "%." + this._decimals + "f " + this._unit;

    public InfoPopup() {
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        this.setAutoFix(true);
        this.fadeIn = new FadeTransition(Duration.millis((double)200.0), (Node)this.hBox);
        this.fadeIn.setFromValue(0.0);
        this.fadeIn.setToValue(0.75);
        this.fadeOut = new FadeTransition(Duration.millis((double)200.0), (Node)this.hBox);
        this.fadeOut.setFromValue(0.75);
        this.fadeOut.setToValue(0.0);
        this.fadeOut.setOnFinished(e -> this.hide());
        this.delay = new PauseTransition(Duration.millis((double)this._timeout));
        this.delay.setOnFinished(e -> this.animatedHide());
    }

    private void initGraphics() {
        Font regularFont = Fonts.latoRegular((double)10.0);
        Font lightFont = Fonts.latoLight((double)10.0);
        this.seriesText = new Text("SERIES");
        this.seriesText.setFill((Paint)this._textColor);
        this.seriesText.setFont(regularFont);
        this.seriesNameText = new Text("-");
        this.seriesNameText.setFill((Paint)this._textColor);
        this.seriesNameText.setFont(lightFont);
        this.seriesSumText = new Text("SUM");
        this.seriesSumText.setFill((Paint)this._textColor);
        this.seriesSumText.setFont(regularFont);
        this.seriesValueText = new Text("-");
        this.seriesValueText.setFill((Paint)this._textColor);
        this.seriesValueText.setFont(lightFont);
        this.itemText = new Text("ITEM");
        this.itemText.setFill((Paint)this._textColor);
        this.itemText.setFont(regularFont);
        this.itemNameText = new Text("-");
        this.itemNameText.setFill((Paint)this._textColor);
        this.itemNameText.setFont(lightFont);
        this.valueText = new Text("VALUE");
        this.valueText.setFill((Paint)this._textColor);
        this.valueText.setFont(regularFont);
        this.itemValueText = new Text("-");
        this.itemValueText.setFill((Paint)this._textColor);
        this.itemValueText.setFont(lightFont);
        this.line = new Line(0.0, 0.0, 0.0, 56.0);
        this.line.setStroke((Paint)this._textColor);
        VBox vBoxTitles = new VBox(2.0, new Node[]{this.seriesText, this.seriesSumText, this.itemText, this.valueText});
        vBoxTitles.setAlignment(Pos.CENTER_LEFT);
        VBox.setMargin((Node)this.itemText, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
        VBox vBoxValues = new VBox(2.0, new Node[]{this.seriesNameText, this.seriesValueText, this.itemNameText, this.itemValueText});
        vBoxValues.setAlignment(Pos.CENTER_RIGHT);
        VBox.setMargin((Node)this.itemNameText, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
        HBox.setHgrow((Node)vBoxValues, (Priority)Priority.ALWAYS);
        this.hBox = new HBox(5.0, new Node[]{vBoxTitles, this.line, vBoxValues});
        this.hBox.setPrefSize(120.0, 69.0);
        this.hBox.setPadding(new Insets(5.0));
        this.hBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this._backgroundColor, new CornerRadii(3.0), Insets.EMPTY)}));
        this.hBox.setMouseTransparent(true);
        this.getContent().addAll((Object[])new Node[]{this.hBox});
    }

    private void registerListeners() {
    }

    public void animatedShow(Window WINDOW) {
        this.show(WINDOW);
        this.fadeIn.play();
        this.delay.playFromStart();
    }

    public void animatedHide() {
        this.fadeOut.play();
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color COLOR) {
        if (null == this.backgroundColor) {
            this._backgroundColor = COLOR;
            this.hBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this._backgroundColor, new CornerRadii(3.0), Insets.EMPTY)}));
        } else {
            this.backgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    InfoPopup.this.hBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.get(), new CornerRadii(3.0), Insets.EMPTY)}));
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.updateTextColor(this._textColor);
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    InfoPopup.this.updateTextColor((Color)this.get());
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public long getTimeout() {
        return null == this.timeout ? this._timeout : this.timeout.get();
    }

    public void setTimeout(long TIMEOUT) {
        if (null == this.timeout) {
            this._timeout = Helper.clamp(0L, MAX_TIMEOUT, TIMEOUT);
        } else {
            this.timeout.set(TIMEOUT);
        }
    }

    public LongProperty timeoutProperty() {
        if (null == this.timeout) {
            this.timeout = new LongPropertyBase(this._timeout){

                protected void invalidated() {
                    Helper.clamp(0L, MAX_TIMEOUT, this.get());
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "timeout";
                }
            };
        }
        return this.timeout;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this._decimals + "f " + this.getUnit();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, MAX_DECIMALS, this.get()));
                    InfoPopup.this.formatString = "%." + this.get() + "f " + InfoPopup.this._unit;
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
            this.formatString = "%." + this.getDecimals() + "f " + this._unit;
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new StringPropertyBase(this._unit){

                protected void invalidated() {
                    InfoPopup.this.formatString = "%." + InfoPopup.this.getDecimals() + "f " + this.get();
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "unit";
                }
            };
            this._unit = null;
        }
        return this.unit;
    }

    public void update(SelectionEvt EVENT) {
        ChartItemSeries series = EVENT.getSeries();
        Object item = EVENT.getItem();
        if (null == series && null == item) {
            this.setOpacity(0.0);
        } else {
            this.setOpacity(1.0);
        }
        if (null == series) {
            Helper.enableNode((Node)this.seriesText, false);
            Helper.enableNode((Node)this.seriesSumText, false);
            Helper.enableNode((Node)this.seriesNameText, false);
            Helper.enableNode((Node)this.seriesValueText, false);
            this.setTo2Rows();
        } else {
            this.seriesNameText.setText(EVENT.getSeries().getName());
            this.seriesValueText.setText(String.format(Locale.US, this.formatString, EVENT.getSeries().getSumOfAllItems()));
            Helper.enableNode((Node)this.seriesText, true);
            Helper.enableNode((Node)this.seriesSumText, true);
            Helper.enableNode((Node)this.seriesNameText, true);
            Helper.enableNode((Node)this.seriesValueText, true);
            this.setTo4Rows();
        }
        if (null == item) {
            Helper.enableNode((Node)this.itemText, false);
            Helper.enableNode((Node)this.valueText, false);
            Helper.enableNode((Node)this.itemNameText, false);
            Helper.enableNode((Node)this.itemValueText, false);
            VBox.setMargin((Node)this.itemNameText, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            this.setTo2Rows();
        } else {
            this.itemNameText.setText(null == EVENT.getItem() ? "-" : ((ChartItem)EVENT.getItem()).getName());
            this.itemValueText.setText(null == EVENT.getItem() ? "-" : String.format(Locale.US, this.formatString, ((ChartItem)EVENT.getItem()).getValue()));
            Helper.enableNode((Node)this.itemText, true);
            Helper.enableNode((Node)this.valueText, true);
            Helper.enableNode((Node)this.itemNameText, true);
            Helper.enableNode((Node)this.itemValueText, true);
            VBox.setMargin((Node)this.itemNameText, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
            if (null == series) {
                VBox.setMargin((Node)this.itemText, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
                VBox.setMargin((Node)this.itemNameText, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            } else {
                VBox.setMargin((Node)this.itemText, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
                VBox.setMargin((Node)this.itemNameText, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
                this.setTo4Rows();
            }
        }
    }

    public void update(Item item) {
        this.update(item, -1.0);
    }

    public void update(Item item, boolean useDescription) {
        this.update(item, -1.0, useDescription);
    }

    public void update(Item item, double sum) {
        this.update(item, sum, false);
    }

    public void update(Item item, double sum, boolean useDescription) {
        String value;
        String text;
        Helper.enableNode((Node)this.seriesText, false);
        Helper.enableNode((Node)this.seriesSumText, false);
        Helper.enableNode((Node)this.seriesNameText, false);
        Helper.enableNode((Node)this.seriesValueText, false);
        this.setTo2Rows();
        if (item instanceof BubbleGridChartItem) {
            BubbleGridChartItem i = (BubbleGridChartItem)item;
            text = item.getName();
            value = sum != -1.0 ? String.join((CharSequence)"/", String.format(Locale.US, this.formatString, i.getValue()), String.format(Locale.US, "%.0f%%", i.getValue() / sum * 100.0)) : String.format(Locale.US, this.formatString, i.getValue());
        } else if (item instanceof ChartItem) {
            ChartItem i = (ChartItem)item;
            String string = text = useDescription ? i.getDescription() : item.getName();
            value = sum != -1.0 ? String.join((CharSequence)"/", String.format(Locale.US, this.formatString, i.getValue()), String.format(Locale.US, "%.0f%%", i.getValue() / sum * 100.0)) : String.format(Locale.US, this.formatString, i.getValue());
        } else {
            text = "-";
            value = "-";
        }
        this.itemNameText.setText(null == text ? "-" : text);
        this.itemValueText.setText(null == value ? "-" : value);
        Helper.enableNode((Node)this.itemText, true);
        Helper.enableNode((Node)this.valueText, true);
        Helper.enableNode((Node)this.itemNameText, true);
        Helper.enableNode((Node)this.itemValueText, true);
        VBox.setMargin((Node)this.itemNameText, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.itemText, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.itemNameText, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
    }

    private void setTo2Rows() {
        this.setHeight(38.0);
        this.line.setEndY(24.0);
        this.hBox.setPrefHeight(36.0);
        this.hBox.setMinHeight(36.0);
        this.hBox.setMaxHeight(36.0);
    }

    private void setTo3Rows() {
        this.setHeight(56.0);
        this.line.setEndY(40.0);
        this.hBox.setPrefHeight(54.0);
        this.hBox.setMinHeight(54.0);
        this.hBox.setMaxHeight(54.0);
    }

    private void setTo4Rows() {
        this.setHeight(71.0);
        this.line.setEndY(56.0);
        this.hBox.setPrefHeight(69.0);
        this.hBox.setMinHeight(69.0);
        this.hBox.setMaxHeight(69.0);
    }

    private void updateTextColor(Color COLOR) {
        this.seriesText.setFill((Paint)COLOR);
        this.seriesSumText.setFill((Paint)COLOR);
        this.itemText.setFill((Paint)COLOR);
        this.valueText.setFill((Paint)COLOR);
        this.line.setStroke((Paint)COLOR);
        this.seriesNameText.setFill((Paint)COLOR);
        this.seriesValueText.setFill((Paint)COLOR);
        this.itemNameText.setFill((Paint)COLOR);
        this.itemValueText.setFill((Paint)COLOR);
    }
}

