/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.series;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ChartItemSeriesBuilder<B extends ChartItemSeriesBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected ChartItemSeriesBuilder() {
    }

    public static final ChartItemSeriesBuilder create() {
        return new ChartItemSeriesBuilder();
    }

    public final B items(ChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<ChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B fill(Paint FILL) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B stroke(Paint STROKE) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)STROKE));
        return (B)this;
    }

    public final B textFill(Color FILL) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B symbolFill(Color FILL) {
        this.properties.put("symbolFill", (Property)new SimpleObjectProperty((Object)FILL));
        return (B)this;
    }

    public final B symbolStroke(Color STROKE) {
        this.properties.put("symbolStroke", (Property)new SimpleObjectProperty((Object)STROKE));
        return (B)this;
    }

    public final B symbol(Symbol SYMBOL) {
        this.properties.put("symbol", (Property)new SimpleObjectProperty((Object)SYMBOL));
        return (B)this;
    }

    public final B chartType(ChartType TYPE) {
        this.properties.put("chartType", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B symbolsVisible(boolean VISIBLE) {
        this.properties.put("symbolsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B symbolSize(double SIZE) {
        this.properties.put("symbolSize", (Property)new SimpleDoubleProperty(SIZE));
        return (B)this;
    }

    public final B strokeWidth(double WIDTH) {
        this.properties.put("strokeWidth", (Property)new SimpleDoubleProperty(WIDTH));
        return (B)this;
    }

    public final B animated(boolean AUTO) {
        this.properties.put("animated", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B animationDuration(long DURATION) {
        this.properties.put("animationDuration", (Property)new SimpleLongProperty(DURATION));
        return (B)this;
    }

    public final ChartItemSeries build() {
        ChartItemSeries chartItemSeries = new ChartItemSeries();
        if (this.properties.keySet().contains("itemsArray")) {
            chartItemSeries.setItems((Item[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            chartItemSeries.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "name": {
                    chartItemSeries.setName((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "fill": {
                    chartItemSeries.setFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "stroke": {
                    chartItemSeries.setStroke((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textFill": {
                    chartItemSeries.setTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "symbolFill": {
                    chartItemSeries.setSymbolFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "symbolStroke": {
                    chartItemSeries.setSymbolStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "symbol": {
                    chartItemSeries.setSymbol((Symbol)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "chartType": {
                    chartItemSeries.setChartType((ChartType)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "symbolSize": {
                    chartItemSeries.setSymbolSize(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "strokeWidth": {
                    chartItemSeries.setStrokeWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "animated": {
                    chartItemSeries.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "animationDuration": {
                    chartItemSeries.setAnimationDuration(((LongProperty)this.properties.get(key)).get());
                }
            }
        }
        return chartItemSeries;
    }
}

