/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.MapPoint;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class MapConnection {
    private final ChartEvt SELECTED_EVENT = new ChartEvt(this, ChartEvt.CONNECTION_SELECTED);
    private final ChartEvt UPDATED_EVENT = new ChartEvt(this, ChartEvt.CONNECTION_UPDATE);
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
    private MapPoint _incomingItem;
    private ObjectProperty<MapPoint> incomingItem;
    private MapPoint _outgoingItem;
    private ObjectProperty<MapPoint> outgoingItem;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Color _startColor;
    private ObjectProperty<Color> startColor;
    private Color _endColor;
    private ObjectProperty<Color> endColor;
    private boolean _gradientFill;
    private BooleanProperty gradientFill;
    private double _value;
    private DoubleProperty value;
    private double _lineWidth;
    private DoubleProperty lineWidth;
    private String _tooltipText;
    private StringProperty tooltipText;

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM) {
        this(OUTGOING_ITEM, INCOMING_ITEM, 0.0, Color.BLACK, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, Color STROKE) {
        this(OUTGOING_ITEM, INCOMING_ITEM, 0.0, STROKE, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color STROKE) {
        this(OUTGOING_ITEM, INCOMING_ITEM, VALUE, STROKE, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color START_COLOR, Color END_COLOR, boolean GRADIENT_FILL) {
        this(OUTGOING_ITEM, INCOMING_ITEM, VALUE, Color.BLACK, START_COLOR, END_COLOR, GRADIENT_FILL, 1.0, "");
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color START_COLOR, Color END_COLOR, boolean GRADIENT_FILL, String TOOLTIP_TEXT) {
        this(OUTGOING_ITEM, INCOMING_ITEM, VALUE, Color.BLACK, START_COLOR, END_COLOR, GRADIENT_FILL, 1.0, TOOLTIP_TEXT);
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color STROKE, String TOOLTIP_TEXT) {
        this(OUTGOING_ITEM, INCOMING_ITEM, VALUE, STROKE, Color.BLUE, Color.RED, false, 1.0, TOOLTIP_TEXT);
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color STROKE, Color START_COLOR, Color END_COLOR, boolean GRADIENT_FILL, double LINE_WIDTH, String TOOLTIP_TEXT) {
        this._outgoingItem = OUTGOING_ITEM;
        this._incomingItem = INCOMING_ITEM;
        this._value = VALUE;
        this._stroke = STROKE;
        this._tooltipText = TOOLTIP_TEXT;
        this._startColor = START_COLOR;
        this._endColor = END_COLOR;
        this._gradientFill = GRADIENT_FILL;
        this._lineWidth = Helper.clamp(0.5, 10.0, LINE_WIDTH);
    }

    public MapPoint getIncomingItem() {
        return null == this.incomingItem ? this._incomingItem : (MapPoint)((Object)this.incomingItem.get());
    }

    public void setIncomingItem(MapPoint ITEM1) {
        if (null == this.incomingItem) {
            this._incomingItem = ITEM1;
            this.fireChartEvt(this.UPDATED_EVENT);
        } else {
            this.incomingItem.set((Object)ITEM1);
        }
    }

    public ObjectProperty<MapPoint> incomingItemProperty() {
        if (null == this.incomingItem) {
            this.incomingItem = new ObjectPropertyBase<MapPoint>(this._incomingItem){

                protected void invalidated() {
                    MapConnection.this.fireChartEvt(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "item1";
                }
            };
            this._incomingItem = null;
        }
        return this.incomingItem;
    }

    public MapPoint getOutgoingItem() {
        return null == this.outgoingItem ? this._outgoingItem : (MapPoint)((Object)this.outgoingItem.get());
    }

    public void setOutgoingItem(MapPoint ITEM2) {
        if (null == this.outgoingItem) {
            this._outgoingItem = ITEM2;
            this.fireChartEvt(this.UPDATED_EVENT);
        } else {
            this.outgoingItem.set((Object)ITEM2);
        }
    }

    public ObjectProperty<MapPoint> outgoingItemProperty() {
        if (null == this.outgoingItem) {
            this.outgoingItem = new ObjectPropertyBase<MapPoint>(this._outgoingItem){

                protected void invalidated() {
                    MapConnection.this.fireChartEvt(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "item2";
                }
            };
            this._outgoingItem = null;
        }
        return this.outgoingItem;
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public ReadOnlyDoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color FILL) {
        if (null == this.stroke) {
            this._stroke = FILL;
            this.fireChartEvt(this.UPDATED_EVENT);
        } else {
            this.stroke.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    MapConnection.this.fireChartEvt(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public Color getStartColor() {
        return null == this.startColor ? this._startColor : (Color)this.startColor.get();
    }

    public void setStartColor(Color START_COLOR) {
        if (null == this.startColor) {
            this._startColor = START_COLOR;
            this.fireChartEvt(this.UPDATED_EVENT);
        } else {
            this.startColor.set((Object)START_COLOR);
        }
    }

    public ObjectProperty<Color> startColorProperty() {
        if (null == this.startColor) {
            this.startColor = new ObjectPropertyBase<Color>(this._startColor){

                protected void invalidated() {
                    MapConnection.this.fireChartEvt(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "startColor";
                }
            };
            this._startColor = null;
        }
        return this.startColor;
    }

    public Color getEndColor() {
        return null == this.endColor ? this._endColor : (Color)this.endColor.get();
    }

    public void setEndColor(Color END_COLOR) {
        if (null == this.endColor) {
            this._endColor = END_COLOR;
            this.fireChartEvt(this.UPDATED_EVENT);
        } else {
            this.endColor.set((Object)END_COLOR);
        }
    }

    public ObjectProperty<Color> endColorProperty() {
        if (null == this.endColor) {
            this.endColor = new ObjectPropertyBase<Color>(this._endColor){

                protected void invalidated() {
                    MapConnection.this.fireChartEvt(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "endColor";
                }
            };
            this._endColor = null;
        }
        return this.endColor;
    }

    public boolean getGradientFill() {
        return null == this.gradientFill ? this._gradientFill : this.gradientFill.get();
    }

    public void setGradientFill(boolean GRADIENT_FILL) {
        if (null == this.gradientFill) {
            this._gradientFill = GRADIENT_FILL;
            this.fireChartEvt(this.UPDATED_EVENT);
        } else {
            this.gradientFill.set(GRADIENT_FILL);
        }
    }

    public BooleanProperty gradientFillProperty() {
        if (null == this.gradientFill) {
            this.gradientFill = new BooleanPropertyBase(this._gradientFill){

                protected void invalidated() {
                    MapConnection.this.fireChartEvt(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "gradientFill";
                }
            };
        }
        return this.gradientFill;
    }

    public double getLineWidth() {
        return null == this.lineWidth ? this._lineWidth : this.lineWidth.get();
    }

    public void setLineWidth(double LINE_WIDTH) {
        if (null == this.lineWidth) {
            this._lineWidth = Helper.clamp(0.5, 10.0, LINE_WIDTH);
            this.fireChartEvt(this.UPDATED_EVENT);
        } else {
            this.lineWidth.set(LINE_WIDTH);
        }
    }

    public DoubleProperty lineWidthProperty() {
        if (null == this.lineWidth) {
            this.lineWidth = new DoublePropertyBase(this._lineWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(0.5, 10.0, this.get()));
                    MapConnection.this.fireChartEvt(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "lineWidth";
                }
            };
        }
        return this.lineWidth;
    }

    public String getTooltipText() {
        return null == this.tooltipText ? this._tooltipText : (String)this.tooltipText.get();
    }

    public void setTooltipText(String TOOLTIP_TEXT) {
        if (null == this.tooltipText) {
            this._tooltipText = TOOLTIP_TEXT;
        } else {
            this.tooltipText.set((Object)TOOLTIP_TEXT);
        }
    }

    public StringProperty tooltipTextProperty() {
        if (null == this.tooltipText) {
            this.tooltipText = new StringPropertyBase(this._tooltipText){

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "tooltipText";
                }
            };
        }
        return this.tooltipText;
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }
}

