/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Category;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.data.Metadata;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.WritableValue;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class ChartItem
implements Item,
Comparable<ChartItem> {
    protected final ChartEvt UPDATE_EVENT = new ChartEvt(this, ChartEvt.ITEM_UPDATE);
    protected final ChartEvt FINISHED_EVENT = new ChartEvt(this, ChartEvt.FINISHED);
    protected final ChartEvt SELECTED_EVENT = new ChartEvt(this, ChartEvt.SELECTED);
    protected Map<EvtType, List<EvtObserver<ChartEvt>>> observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
    private int _index = -1;
    private IntegerProperty index;
    private String _name;
    private StringProperty name;
    private String _unit;
    private StringProperty unit;
    private String _description;
    private StringProperty description;
    private Category _category;
    private ObjectProperty<Category> category;
    private double _value;
    private DoubleProperty value;
    private double oldValue;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Color _textFill;
    private ObjectProperty<Color> textFill;
    private Instant _timestamp;
    private ObjectProperty<Instant> timestamp;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private boolean _animated;
    private BooleanProperty animated;
    private double _x;
    private DoubleProperty x;
    private double _y;
    private DoubleProperty y;
    private boolean _isEmpty;
    private BooleanProperty isEmpty;
    private boolean _selected;
    private BooleanProperty selected;
    private Metadata _metadata;
    private ObjectProperty<Metadata> metadata;
    private long animationDuration;
    private DoubleProperty currentValue;
    private Timeline timeline;

    public ChartItem() {
        this("", 0.0, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, false, null);
    }

    public ChartItem(boolean IS_EMPTY) {
        this("", 0.0, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME) {
        this(NAME, 0.0, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, false, null);
    }

    public ChartItem(String NAME, boolean IS_EMPTY) {
        this(NAME, 0.0, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, IS_EMPTY, null);
    }

    public ChartItem(double VALUE) {
        this("", VALUE, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, false, null);
    }

    public ChartItem(double VALUE, boolean IS_EMPTY) {
        this("", VALUE, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, IS_EMPTY, null);
    }

    public ChartItem(double VALUE, Instant TIMESTAMP) {
        this("", VALUE, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, TIMESTAMP, false, 800L, false, null);
    }

    public ChartItem(double VALUE, Instant TIMESTAMP, boolean IS_EMPTY) {
        this("", VALUE, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, TIMESTAMP, false, 800L, IS_EMPTY, null);
    }

    public ChartItem(double VALUE, Color FILL_COLOR) {
        this("", VALUE, FILL_COLOR, Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, false, null);
    }

    public ChartItem(double VALUE, Color FILL_COLOR, boolean IS_EMPTY) {
        this("", VALUE, FILL_COLOR, Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME, Color FILL_COLOR) {
        this(NAME, 0.0, FILL_COLOR, Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, false, null);
    }

    public ChartItem(String NAME, Color FILL_COLOR, boolean IS_EMPTY) {
        this(NAME, 0.0, FILL_COLOR, Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE) {
        this(NAME, VALUE, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, false, null);
    }

    public ChartItem(String NAME, double VALUE, boolean IS_EMPTY) {
        this(NAME, VALUE, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Instant TIMESTAMP) {
        this(NAME, VALUE, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, TIMESTAMP, true, 800L, false, null);
    }

    public ChartItem(String NAME, double VALUE, Instant TIMESTAMP, boolean IS_EMPTY) {
        this(NAME, VALUE, Color.rgb((int)233, (int)30, (int)99), Color.TRANSPARENT, Color.BLACK, TIMESTAMP, true, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, false, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, boolean IS_EMPTY) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, Color.BLACK, Instant.now(), false, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color TEXT_FILL) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, TEXT_FILL, Instant.now(), false, 800L, false, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color TEXT_FILL, boolean IS_EMPTY) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, TEXT_FILL, Instant.now(), false, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Instant TIMESTAMP) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, Color.BLACK, TIMESTAMP, false, 800L, false, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Instant TIMESTAMP, boolean IS_EMPTY) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, Color.BLACK, TIMESTAMP, false, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color TEXT_FILL, Instant TIMESTAMP) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, TEXT_FILL, TIMESTAMP, false, 800L, false, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color TEXT_FILL, Instant TIMESTAMP, boolean IS_EMPTY) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, TEXT_FILL, TIMESTAMP, false, 800L, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, Color.BLACK, TIMESTAMP, ANIMATED, ANIMATION_DURATION, false, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION, boolean IS_EMPTY) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, Color.BLACK, TIMESTAMP, ANIMATED, ANIMATION_DURATION, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color TEXT_FILL, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, TEXT_FILL, TIMESTAMP, ANIMATED, ANIMATION_DURATION, false, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color TEXT_FILL, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION, boolean IS_EMPTY) {
        this(NAME, VALUE, FILL, Color.TRANSPARENT, TEXT_FILL, TIMESTAMP, ANIMATED, ANIMATION_DURATION, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color STROKE, Color TEXT_FILL, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION) {
        this(NAME, VALUE, FILL, STROKE, TEXT_FILL, TIMESTAMP, ANIMATED, ANIMATION_DURATION, false, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color STROKE, Color TEXT_FILL, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION, boolean IS_EMPTY) {
        this(NAME, VALUE, FILL, STROKE, TEXT_FILL, TIMESTAMP, ANIMATED, ANIMATION_DURATION, IS_EMPTY, null);
    }

    public ChartItem(String NAME, double VALUE, Color FILL, Color STROKE, Color TEXT_FILL, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION, boolean IS_EMPTY, Metadata METADATA) {
        this._name = NAME;
        this._unit = "";
        this._description = "";
        this._category = null;
        this._value = VALUE;
        this.oldValue = 0.0;
        this._fill = FILL;
        this._stroke = STROKE;
        this._textFill = TEXT_FILL;
        this._timestamp = TIMESTAMP;
        this._symbol = Symbol.NONE;
        this._animated = ANIMATED;
        this._x = 0.0;
        this._y = 0.0;
        this._isEmpty = IS_EMPTY;
        this._selected = false;
        this._metadata = METADATA;
        this.currentValue = new DoublePropertyBase(this._value){

            protected void invalidated() {
                ChartItem.this.oldValue = ChartItem.this.getValue();
                ChartItem.this.setValue(this.get());
                ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
            }

            public Object getBean() {
                return ChartItem.this;
            }

            public String getName() {
                return "currentValue";
            }
        };
        this.timeline = new Timeline();
        this.animationDuration = ANIMATION_DURATION;
        this.timeline.setOnFinished(e -> this.fireChartEvt(this.FINISHED_EVENT));
    }

    public int getIndex() {
        return null == this.index ? this._index : this.index.get();
    }

    public void setIndex(int index) {
        if (null == this.index) {
            this._index = index;
        } else {
            this.index.set(index);
        }
    }

    public IntegerProperty indexProperty() {
        if (null == this.index) {
            this.index = new IntegerPropertyBase(this._index){

                protected void invalidated() {
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "index";
                }
            };
        }
        return this.index;
    }

    @Override
    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (null == this.name) {
            this._name = NAME;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new StringPropertyBase(this._unit){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "unit";
                }
            };
            this._unit = null;
        }
        return this.unit;
    }

    public String getDescription() {
        return null == this.description ? this._description : (String)this.description.get();
    }

    public void setDescription(String DESCRIPTION) {
        if (null == this.description) {
            this._description = DESCRIPTION;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.description.set((Object)DESCRIPTION);
        }
    }

    public StringProperty descriptionProperty() {
        if (null == this.description) {
            this.description = new StringPropertyBase(this._description){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "description";
                }
            };
            this._description = null;
        }
        return this.description;
    }

    public Category getCategory() {
        return null == this.category ? this._category : (Category)this.category.get();
    }

    public void setCategory(Category CATEGORY) {
        if (null == this.category) {
            this._category = CATEGORY;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.category.set((Object)CATEGORY);
        }
    }

    public ObjectProperty<Category> categoryProperty() {
        if (null == this.category) {
            this.category = new ObjectPropertyBase<Category>(this._category){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "category";
                }
            };
            this._category = null;
        }
        return this.category;
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public void setValue(double VALUE) {
        if (null == this.value) {
            if (this.isAnimated()) {
                if (this.timeline.getCurrentRate() > 0.0) {
                    this.oldValue = this._value;
                    this._value = VALUE;
                } else {
                    this.oldValue = this._value;
                    this._value = VALUE;
                    this.timeline.stop();
                    KeyValue kv1 = new KeyValue((WritableValue)this.currentValue, (Object)this.oldValue, Interpolator.EASE_BOTH);
                    KeyValue kv2 = new KeyValue((WritableValue)this.currentValue, (Object)VALUE, Interpolator.EASE_BOTH);
                    KeyFrame kf1 = new KeyFrame(Duration.ZERO, new KeyValue[]{kv1});
                    KeyFrame kf2 = new KeyFrame(Duration.millis((double)this.animationDuration), new KeyValue[]{kv2});
                    this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf1, kf2});
                    this.timeline.play();
                }
            } else {
                this.oldValue = this._value;
                this._value = VALUE;
                this.fireChartEvt(this.FINISHED_EVENT);
            }
        } else {
            this.value.set(VALUE);
        }
    }

    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                public void set(double VALUE) {
                    ChartItem.this.oldValue = this.get();
                    super.set(VALUE);
                }

                protected void invalidated() {
                    if (ChartItem.this.isAnimated()) {
                        if (Double.compare(ChartItem.this.timeline.getCurrentRate(), 0.0) == 0) {
                            ChartItem.this.timeline.stop();
                            KeyValue kv1 = new KeyValue((WritableValue)ChartItem.this.currentValue, (Object)ChartItem.this.oldValue, Interpolator.EASE_BOTH);
                            KeyValue kv2 = new KeyValue((WritableValue)ChartItem.this.currentValue, (Object)this.get(), Interpolator.EASE_BOTH);
                            KeyFrame kf1 = new KeyFrame(Duration.ZERO, new KeyValue[]{kv1});
                            KeyFrame kf2 = new KeyFrame(Duration.millis((double)ChartItem.this.animationDuration), new KeyValue[]{kv2});
                            ChartItem.this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf1, kf2});
                            ChartItem.this.timeline.play();
                        }
                    } else {
                        ChartItem.this.fireChartEvt(ChartItem.this.FINISHED_EVENT);
                    }
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public double getOldValue() {
        return this.oldValue;
    }

    @Override
    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (null == this.fill) {
            this._fill = FILL;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (null == this.stroke) {
            this._stroke = STROKE;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public Color getTextFill() {
        return null == this.textFill ? this._textFill : (Color)this.textFill.get();
    }

    public void setTextFill(Color COLOR) {
        if (null == this.textFill) {
            this._textFill = COLOR;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.textFill.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textFillProperty() {
        if (null == this.textFill) {
            this.textFill = new ObjectPropertyBase<Color>(this._textFill){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "textFill";
                }
            };
            this._textFill = null;
        }
        return this.textFill;
    }

    @Override
    public Symbol getSymbol() {
        return null == this.symbol ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    @Override
    public void setSymbol(Symbol SYMBOL) {
        if (null == this.symbol) {
            this._symbol = SYMBOL;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (null == this.symbol) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    public Instant getTimestamp() {
        return null == this.timestamp ? this._timestamp : (Instant)this.timestamp.get();
    }

    public void setTimestamp(ZonedDateTime TIMESTAMP) {
        this.setTimestamp(TIMESTAMP.toInstant());
    }

    public void setTimestamp(long TIMESTAMP_EPOCH_SECOND) {
        this.setTimestamp(Instant.ofEpochSecond(TIMESTAMP_EPOCH_SECOND));
    }

    public void setTimestamp(Instant TIMESTAMP) {
        if (null == this.timestamp) {
            this._timestamp = TIMESTAMP;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.timestamp.set((Object)TIMESTAMP);
        }
    }

    public ObjectProperty<Instant> timestampProperty() {
        if (null == this.timestamp) {
            this.timestamp = new ObjectPropertyBase<Instant>(this._timestamp){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "timestamp";
                }
            };
            this._timestamp = null;
        }
        return this.timestamp;
    }

    public ZonedDateTime getTimestampAdDateTime() {
        return this.getTimestampAsDateTime(ZoneId.systemDefault());
    }

    public ZonedDateTime getTimestampAsDateTime(ZoneId ZONE_ID) {
        return ZonedDateTime.ofInstant(this.getTimestamp(), ZONE_ID);
    }

    public LocalDate getTimestampAsLocalDate() {
        return this.getTimestampAsLocalDate(ZoneId.systemDefault());
    }

    public LocalDate getTimestampAsLocalDate(ZoneId ZONE_ID) {
        return this.getTimestampAsDateTime(ZONE_ID).toLocalDate();
    }

    public boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new BooleanPropertyBase(this._animated){

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "animated";
                }
            };
        }
        return this.animated;
    }

    public double getX() {
        return null == this.x ? this._x : this.x.get();
    }

    public void setX(double X) {
        if (null == this.x) {
            this._x = X;
        } else {
            this.x.set(X);
        }
    }

    public DoubleProperty xProperty() {
        if (null == this.x) {
            this.x = new DoublePropertyBase(this._x){

                protected void invalidated() {
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public double getY() {
        return null == this.y ? this._y : this.y.get();
    }

    public void setY(double Y) {
        if (null == this.y) {
            this._y = Y;
        } else {
            this.y.set(Y);
        }
    }

    public DoubleProperty yProperty() {
        if (null == this.y) {
            this.y = new DoublePropertyBase(this._y){

                protected void invalidated() {
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    @Override
    public boolean isEmptyItem() {
        return null == this.isEmpty ? this._isEmpty : this.isEmpty.get();
    }

    public void setIsEmpty(boolean isEmpty) {
        if (null == this.isEmpty) {
            this._isEmpty = isEmpty;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.isEmpty.set(isEmpty);
        }
    }

    public BooleanProperty isEmptyProperty() {
        if (null == this.isEmpty) {
            this.isEmpty = new BooleanPropertyBase(this._isEmpty){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "isEmpty";
                }
            };
        }
        return this.isEmpty;
    }

    public boolean isSelected() {
        return null == this.selected ? this._selected : this.selected.get();
    }

    public void setSelected(boolean selected) {
        if (null == this.selected) {
            this._selected = selected;
            this.fireChartEvt(this.SELECTED_EVENT);
        } else {
            this.selected.set(selected);
        }
    }

    public BooleanProperty selectedProperty() {
        if (null == this.selected) {
            this.selected = new BooleanPropertyBase(this._selected){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.SELECTED_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public Metadata getMetadata() {
        return null == this.metadata ? this._metadata : (Metadata)this.metadata.get();
    }

    public void setMetadata(Metadata metadata) {
        if (null == this.metadata) {
            this._metadata = metadata;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.metadata.set((Object)metadata);
        }
    }

    public ObjectProperty<Metadata> metadataProperty() {
        if (null == this.metadata) {
            this.metadata = new ObjectPropertyBase<Metadata>(){

                protected void invalidated() {
                    ChartItem.this.fireChartEvt(ChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return ChartItem.this;
                }

                public String getName() {
                    return "metadata";
                }
            };
            this._metadata = null;
        }
        return this.metadata;
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(long DURATION) {
        this.animationDuration = Helper.clamp(10L, 10000L, DURATION);
    }

    public String toString() {
        return "{\n" + "  \"name\":" + this.getName() + ",\n" + "  \"unit\":" + this.getUnit() + ",\n" + "  \"description\":" + this.getDescription() + ",\n" + "  \"category\":" + this.getCategory() + ",\n" + "  \"value\":" + this.getValue() + ",\n" + "  \"timestamp\":" + this.getTimestamp().toEpochMilli() + ",\n" + "  \"metadata\":" + "\"" + (null == this.getMetadata() ? "" : this.getMetadata().toString()) + "\"\n" + "}";
    }

    @Override
    public int compareTo(ChartItem ITEM) {
        return Double.compare(this.getValue(), ITEM.getValue());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartItem)) {
            return false;
        }
        ChartItem item = (ChartItem)o;
        return item.getName().equals(this.getName()) && item.getUnit().equals(this.getUnit()) && item.getDescription().equals(this.getDescription()) && item.getTimestamp().equals(this.getTimestamp()) && item.isEmptyItem() == this.isEmptyItem() && Double.compare(item.getValue(), this.getValue()) == 0;
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }
}

