/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.SunburstChart;
import eu.hansolo.fx.charts.data.TreeNode;
import eu.hansolo.fx.charts.tools.TextOrientation;
import eu.hansolo.fx.charts.tools.VisibleData;
import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class SunburstChartBuilder<B extends SunburstChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SunburstChartBuilder() {
    }

    public static final SunburstChartBuilder create() {
        return new SunburstChartBuilder();
    }

    public final B tree(TreeNode TREE) {
        this.properties.put("tree", (Property)new SimpleObjectProperty((Object)TREE));
        return (B)this;
    }

    public final B visibleData(VisibleData VISIBLE_DATA) {
        this.properties.put("visibleData", (Property)new SimpleObjectProperty((Object)VISIBLE_DATA));
        return (B)this;
    }

    public final B textOrientation(TextOrientation ORIENTATION) {
        this.properties.put("textOrientation", (Property)new SimpleObjectProperty((Object)ORIENTATION));
        return (B)this;
    }

    public final B backgroundColor(Color COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B useColorFromParent(boolean USE) {
        this.properties.put("useColorFromParent", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B interactive(boolean INTERACTIVE) {
        this.properties.put("interactive", (Property)new SimpleBooleanProperty(INTERACTIVE));
        return (B)this;
    }

    public final B autoTextColor(boolean AUTOMATIC) {
        this.properties.put("autoTextColor", (Property)new SimpleBooleanProperty(AUTOMATIC));
        return (B)this;
    }

    public final B brightTextColor(Color COLOR) {
        this.properties.put("brightTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B darkTextColor(Color COLOR) {
        this.properties.put("darkTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B useChartItemTextColor(boolean USE) {
        this.properties.put("useChartItemTextColor", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final SunburstChart build() {
        SunburstChart sunburstChart = this.properties.containsKey("tree") ? new SunburstChart((TreeNode)((ObjectProperty)this.properties.get("tree")).get()) : new SunburstChart();
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    sunburstChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    sunburstChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    sunburstChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    sunburstChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    sunburstChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    sunburstChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    sunburstChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    sunburstChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    sunburstChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    sunburstChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    sunburstChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    sunburstChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    sunburstChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    sunburstChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    sunburstChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    sunburstChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "visibleData": {
                    sunburstChart.setVisibleData((VisibleData)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "textOrientation": {
                    sunburstChart.setTextOrientation((TextOrientation)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "backgroundColor": {
                    sunburstChart.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textColor": {
                    sunburstChart.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "useColorFromParent": {
                    sunburstChart.setUseColorFromParent(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    sunburstChart.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "interactive": {
                    sunburstChart.setInteractive(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "autoTextColor": {
                    sunburstChart.setAutoTextColor(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "brightTextColor": {
                    sunburstChart.setBrightTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "darkTextColor": {
                    sunburstChart.setDarkTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "useChartItemTextColor": {
                    sunburstChart.setUseChartItemTextColor(((BooleanProperty)this.properties.get(key)).get());
                }
            }
        }
        return sunburstChart;
    }
}

