/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ParallelCoordinatesChart;
import eu.hansolo.fx.charts.data.DataObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class ParallelCoordinatesChartBuilder<B extends ParallelCoordinatesChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected ParallelCoordinatesChartBuilder() {
    }

    public static final ParallelCoordinatesChartBuilder create() {
        return new ParallelCoordinatesChartBuilder();
    }

    public final B items(DataObject ... ITEMS) {
        this.properties.put("itemArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<DataObject> ITEMS) {
        this.properties.put("itemList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B axisColor(Color COLOR) {
        this.properties.put("axisColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B headerColor(Color COLOR) {
        this.properties.put("headerColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B unitColor(Color COLOR) {
        this.properties.put("unitColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickLabelColor(Color COLOR) {
        this.properties.put("tickLabelColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B tickMarksVisible(boolean VISIBLE) {
        this.properties.put("tickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B selectedColor(Color COLOR) {
        this.properties.put("selectedColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B unselectedColor(Color COLOR) {
        this.properties.put("unselectedColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B selectionRectColor(Color COLOR) {
        this.properties.put("selectionRectColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B smoothConnections(boolean SMOOTH) {
        this.properties.put("smoothConnections", (Property)new SimpleBooleanProperty(SMOOTH));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final ParallelCoordinatesChart build() {
        ParallelCoordinatesChart parallelCoordinatesChart = new ParallelCoordinatesChart();
        if (this.properties.keySet().contains("itemArray")) {
            parallelCoordinatesChart.setItems((DataObject[])((ObjectProperty)this.properties.get("itemArray")).get());
        }
        if (this.properties.keySet().contains("itemList")) {
            parallelCoordinatesChart.setItems((List)((ObjectProperty)this.properties.get("itemList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    parallelCoordinatesChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    parallelCoordinatesChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    parallelCoordinatesChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    parallelCoordinatesChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    parallelCoordinatesChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    parallelCoordinatesChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    parallelCoordinatesChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    parallelCoordinatesChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    parallelCoordinatesChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    parallelCoordinatesChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    parallelCoordinatesChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    parallelCoordinatesChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    parallelCoordinatesChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    parallelCoordinatesChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    parallelCoordinatesChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    parallelCoordinatesChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "axisColor": {
                    parallelCoordinatesChart.setAxisColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "headerColor": {
                    parallelCoordinatesChart.setHeaderColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "unitColor": {
                    parallelCoordinatesChart.setUnitColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickLabelColor": {
                    parallelCoordinatesChart.setTickLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "locale": {
                    parallelCoordinatesChart.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    parallelCoordinatesChart.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickMarksVisible": {
                    parallelCoordinatesChart.setTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectedColor": {
                    parallelCoordinatesChart.setSelectedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "unselectedColor": {
                    parallelCoordinatesChart.setUnselectedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectionRectColor": {
                    parallelCoordinatesChart.setSelectionRectColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "smoothConnections": {
                    parallelCoordinatesChart.setSmoothConnections(((BooleanProperty)this.properties.get(key)).get());
                }
            }
        }
        return parallelCoordinatesChart;
    }
}

