/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.CubeChart;
import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class CubeChartBuilder<B extends CubeChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected CubeChartBuilder() {
    }

    public static final CubeChartBuilder create() {
        return new CubeChartBuilder();
    }

    public final B chartBackground(Paint chartBackground) {
        this.properties.put("chartBackground", (Property)new SimpleObjectProperty((Object)chartBackground));
        return (B)this;
    }

    public final B cubeColor(Color cubeColor) {
        this.properties.put("cubeColor", (Property)new SimpleObjectProperty((Object)cubeColor));
        return (B)this;
    }

    public final B cubeFrameColor(Color cubeFrameColor) {
        this.properties.put("cubeFrameColor", (Property)new SimpleObjectProperty((Object)cubeFrameColor));
        return (B)this;
    }

    public final B leftFill(Paint leftFill) {
        this.properties.put("leftFill", (Property)new SimpleObjectProperty((Object)leftFill));
        return (B)this;
    }

    public final B rightFill(Paint rightFill) {
        this.properties.put("rightFill", (Property)new SimpleObjectProperty((Object)rightFill));
        return (B)this;
    }

    public final B leftTextColor(Color leftTextColor) {
        this.properties.put("leftTextColor", (Property)new SimpleObjectProperty((Object)leftTextColor));
        return (B)this;
    }

    public final B leftEmptyTextColor(Color leftEmptyTextColor) {
        this.properties.put("leftEmptyTextColor", (Property)new SimpleObjectProperty((Object)leftEmptyTextColor));
        return (B)this;
    }

    public final B rightTextColor(Color rightTextColor) {
        this.properties.put("rightTextColor", (Property)new SimpleObjectProperty((Object)rightTextColor));
        return (B)this;
    }

    public final B rightEmptyTextColor(Color rightEmptyTextColor) {
        this.properties.put("rightEmptyTextColor", (Property)new SimpleObjectProperty((Object)rightEmptyTextColor));
        return (B)this;
    }

    public final B leftValue(double leftValue) {
        this.properties.put("leftValue", (Property)new SimpleDoubleProperty(leftValue));
        return (B)this;
    }

    public final B rightValue(double rightValue) {
        this.properties.put("rightValue", (Property)new SimpleDoubleProperty(rightValue));
        return (B)this;
    }

    public final B leftText(String leftText) {
        this.properties.put("leftText", (Property)new SimpleStringProperty(leftText));
        return (B)this;
    }

    public final B rightText(String rightText) {
        this.properties.put("rightText", (Property)new SimpleStringProperty(rightText));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final CubeChart build() {
        CubeChart cubeChart = new CubeChart();
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    cubeChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    cubeChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    cubeChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    cubeChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    cubeChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    cubeChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    cubeChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    cubeChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    cubeChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    cubeChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    cubeChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    cubeChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    cubeChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    cubeChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    cubeChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    cubeChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "chartBackground": {
                    cubeChart.setChartBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "cubeColor": {
                    cubeChart.setCubeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "cubeFrameColor": {
                    cubeChart.setCubeFrameColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "leftFill": {
                    cubeChart.setLeftFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "rightFill": {
                    cubeChart.setRightFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "leftTextColor": {
                    cubeChart.setLeftTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "leftEmptyTextColor": {
                    cubeChart.setLeftEmptyTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "rightTextColor": {
                    cubeChart.setLeftTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "rightEmptyTextColor": {
                    cubeChart.setLeftEmptyTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "leftValue": {
                    cubeChart.setLeftValue(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "rightValue": {
                    cubeChart.setRightValue(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "leftText": {
                    cubeChart.setLeftText((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "rightText": {
                    cubeChart.setRightText((String)((StringProperty)this.properties.get(key)).get());
                }
            }
        }
        return cubeChart;
    }
}

