/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.CoxcombChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.tools.Order;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class CoxcombChartBuilder<B extends CoxcombChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected CoxcombChartBuilder() {
    }

    public static final CoxcombChartBuilder create() {
        return new CoxcombChartBuilder();
    }

    public final B items(ChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<ChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B order(Order ORDER) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B autoTextColor(boolean AUTO) {
        this.properties.put("autoTextColor", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B useChartItemTextFill(boolean USE) {
        this.properties.put("useChartItemTextFill", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B equalSegmentAngles(boolean EQUAL) {
        this.properties.put("equalSegmentAngles", (Property)new SimpleBooleanProperty(EQUAL));
        return (B)this;
    }

    public final B onMousePressed(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("onMousePressed", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B onMouseReleased(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("onMouseReleased", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B onMouseMoved(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("onMouseMoved", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B showPopup(boolean SHOW) {
        this.properties.put("showPopup", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B formatString(String FORMAT_STRING) {
        this.properties.put("formatString", (Property)new SimpleStringProperty(FORMAT_STRING));
        return (B)this;
    }

    public final B showItemName(boolean SHOW) {
        this.properties.put("showItemName", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B selectedItemFill(Color SELECTED_ITEM_FILL) {
        this.properties.put("selectedItemFill", (Property)new SimpleObjectProperty((Object)SELECTED_ITEM_FILL));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final CoxcombChart build() {
        CoxcombChart coxcombChart = new CoxcombChart();
        if (this.properties.keySet().contains("itemsArray")) {
            coxcombChart.setItems((ChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            coxcombChart.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    coxcombChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    coxcombChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    coxcombChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    coxcombChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    coxcombChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    coxcombChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    coxcombChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    coxcombChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    coxcombChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    coxcombChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    coxcombChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    coxcombChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    coxcombChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    coxcombChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    coxcombChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    coxcombChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textColor": {
                    coxcombChart.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "order": {
                    coxcombChart.setOrder((Order)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "autoTextColor": {
                    coxcombChart.setAutoTextColor(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useChartItemTextFill": {
                    coxcombChart.setUseChartItemTextFill(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "equalSegmentAngles": {
                    coxcombChart.setEqualSegmentAngles(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "onMousePressed": {
                    coxcombChart.onMousePressed((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "onMouseReleased": {
                    coxcombChart.onMouseReleased((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "onMouseMoved": {
                    coxcombChart.onMouseMoved((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "showPopup": {
                    coxcombChart.setShowPopup(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "formatString": {
                    coxcombChart.setFormatString((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "showItemName": {
                    coxcombChart.setShowItemName(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectedItemFill": {
                    coxcombChart.setSelectedItemFill((Color)((ObjectProperty)this.properties.get(key)).get());
                }
            }
        }
        return coxcombChart;
    }
}

