/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ComparisonBarChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.NumberFormat;
import eu.hansolo.fx.charts.tools.Order;
import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ComparisonBarChartBuilder<B extends ComparisonBarChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private ChartItemSeries<ChartItem> series1;
    private ChartItemSeries<ChartItem> series2;

    protected ComparisonBarChartBuilder(ChartItemSeries<ChartItem> SERIES_1, ChartItemSeries<ChartItem> SERIES_2) {
        this.series1 = SERIES_1;
        this.series2 = SERIES_2;
    }

    public static final ComparisonBarChartBuilder create(ChartItemSeries<ChartItem> series1, ChartItemSeries<ChartItem> series2) {
        return new ComparisonBarChartBuilder(series1, series2);
    }

    public final B backgroundFill(Paint backgroundFill) {
        this.properties.put("backgroundFill", (Property)new SimpleObjectProperty((Object)backgroundFill));
        return (B)this;
    }

    public final B categoryBackgroundFill(Paint categoryBackgroundFill) {
        this.properties.put("categoryBackgroundFill", (Property)new SimpleObjectProperty((Object)categoryBackgroundFill));
        return (B)this;
    }

    public final B barBackgroundFill(Color barBackgroundFill) {
        this.properties.put("barBackgroundFill", (Property)new SimpleObjectProperty((Object)barBackgroundFill));
        return (B)this;
    }

    public final B textFill(Color textFill) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)textFill));
        return (B)this;
    }

    public final B categoryTextFill(Color categoryTextFill) {
        this.properties.put("categoryTextFill", (Property)new SimpleObjectProperty((Object)categoryTextFill));
        return (B)this;
    }

    public final B betterColor(Color betterColor) {
        this.properties.put("betterColor", (Property)new SimpleObjectProperty((Object)betterColor));
        return (B)this;
    }

    public final B poorerColor(Color poorerColor) {
        this.properties.put("poorerColor", (Property)new SimpleObjectProperty((Object)poorerColor));
        return (B)this;
    }

    public final B betterDarkerColor(Color betterDarkerColor) {
        this.properties.put("betterDarkerColor", (Property)new SimpleObjectProperty((Object)betterDarkerColor));
        return (B)this;
    }

    public final B betterBrighterColor(Color betterBrighterColor) {
        this.properties.put("betterBrighterColor", (Property)new SimpleObjectProperty((Object)betterBrighterColor));
        return (B)this;
    }

    public final B poorerDarkerColor(Color poorerDarkerColor) {
        this.properties.put("poorerDarkerColor", (Property)new SimpleObjectProperty((Object)poorerDarkerColor));
        return (B)this;
    }

    public final B poorerBrighterColor(Color poorerBrighterColor) {
        this.properties.put("poorerBrighterColor", (Property)new SimpleObjectProperty((Object)poorerBrighterColor));
        return (B)this;
    }

    public final B barBackgroundVisible(boolean barBackgroundVisible) {
        this.properties.put("barBackgroundVisible", (Property)new SimpleBooleanProperty(barBackgroundVisible));
        return (B)this;
    }

    public final B shadowsVisible(boolean shadowsVisible) {
        this.properties.put("shadowsVisible", (Property)new SimpleBooleanProperty(shadowsVisible));
        return (B)this;
    }

    public final B categorySumVisible(boolean categorySumVisible) {
        this.properties.put("categorySumVisible", (Property)new SimpleBooleanProperty(categorySumVisible));
        return (B)this;
    }

    public final B numberFormat(NumberFormat numberFormat) {
        this.properties.put("numberFormat", (Property)new SimpleObjectProperty((Object)numberFormat));
        return (B)this;
    }

    public final B doCompare(boolean doCompare) {
        this.properties.put("doCompare", (Property)new SimpleBooleanProperty(doCompare));
        return (B)this;
    }

    public final B useItemTextFill(boolean useItemTextFill) {
        this.properties.put("useItemTextFill", (Property)new SimpleBooleanProperty(useItemTextFill));
        return (B)this;
    }

    public final B useCategoryTextFill(boolean useCategoryTextFill) {
        this.properties.put("useCategoryTextFill", (Property)new SimpleBooleanProperty(useCategoryTextFill));
        return (B)this;
    }

    public final B shortenNumbers(boolean shortenNumbers) {
        this.properties.put("shortenNumbers", (Property)new SimpleBooleanProperty(shortenNumbers));
        return (B)this;
    }

    public final B sorted(boolean sorted) {
        this.properties.put("sorted", (Property)new SimpleBooleanProperty(sorted));
        return (B)this;
    }

    public final B order(Order order) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)order));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxHeight) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(maxHeight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)insets));
        return (B)this;
    }

    public final ComparisonBarChart build() {
        ComparisonBarChart comparisonBarChart = new ComparisonBarChart(this.series1, this.series2);
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    comparisonBarChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    comparisonBarChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    comparisonBarChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    comparisonBarChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    comparisonBarChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    comparisonBarChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    comparisonBarChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    comparisonBarChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    comparisonBarChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    comparisonBarChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    comparisonBarChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    comparisonBarChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    comparisonBarChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    comparisonBarChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    comparisonBarChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    comparisonBarChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "backgroundFill": {
                    comparisonBarChart.setBackgroundFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "categoryBackgroundFill": {
                    comparisonBarChart.setCategoryBackgroundFill((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "barBackgroundFill": {
                    comparisonBarChart.setBarBackgroundFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textFill": {
                    comparisonBarChart.setTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "categoryTextFill": {
                    comparisonBarChart.setCategoryTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "betterColor": {
                    comparisonBarChart.setBetterColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poorer": {
                    comparisonBarChart.setPoorerColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "betterDarkerColor": {
                    comparisonBarChart.setBetterDarkerColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "betterBrighterColor": {
                    comparisonBarChart.setBetterBrighterColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poorerDarkerColor": {
                    comparisonBarChart.setPoorerDarkerColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poorerBrighterColor": {
                    comparisonBarChart.setPoorerBrighterColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "barBackgroundVisible": {
                    comparisonBarChart.setBarBackgroundVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "shadowsVisible": {
                    comparisonBarChart.setShadowsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "categorySumVisible": {
                    comparisonBarChart.setCategorySumVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "numberFormat": {
                    comparisonBarChart.setNumberFormat((NumberFormat)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "doCompare": {
                    comparisonBarChart.setDoCompare(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useItemTextFill": {
                    comparisonBarChart.setUseItemTextFill(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useCategoryTextFill": {
                    comparisonBarChart.setUseCategoryTextFill(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "shortenNumbers": {
                    comparisonBarChart.setShortenNumbers(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "sorted": {
                    comparisonBarChart.setSorted(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "order": {
                    comparisonBarChart.setOrder((Order)((Object)((ObjectProperty)this.properties.get(key)).get()));
                }
            }
        }
        return comparisonBarChart;
    }
}

