/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.CircularPlot;
import eu.hansolo.fx.charts.data.PlotItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class CircularPlotBuilder<B extends CircularPlotBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected CircularPlotBuilder() {
    }

    public static final CircularPlotBuilder create() {
        return new CircularPlotBuilder();
    }

    public final B items(PlotItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<PlotItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B tickMarkColor(Color COLOR) {
        this.properties.put("tickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B segmentGap(double GAP) {
        this.properties.put("segmentGap", (Property)new SimpleDoubleProperty(GAP));
        return (B)this;
    }

    public final B showFlowDirection(boolean SHOW) {
        this.properties.put("showFlowDirection", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B minorTickMarksVisible(boolean VISIBLE) {
        this.properties.put("minorTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumTickMarksVisible(boolean VISIBLE) {
        this.properties.put("mediumTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B majorTickMarksVisible(boolean VISIBLE) {
        this.properties.put("majorTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B tickLabelsVisible(boolean VISIBLE) {
        this.properties.put("tickLabelsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B onlyFirstAndLastTickLabelVisible(boolean VISIBLE) {
        this.properties.put("onlyFirstAndLastTickLabelVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B connectionOpacity(double OPACITY) {
        this.properties.put("connectionOpacity", (Property)new SimpleDoubleProperty(OPACITY));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final CircularPlot build() {
        CircularPlot circularPlot = new CircularPlot();
        if (this.properties.keySet().contains("itemsArray")) {
            circularPlot.setItems((PlotItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            circularPlot.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    circularPlot.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    circularPlot.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    circularPlot.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    circularPlot.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    circularPlot.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    circularPlot.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    circularPlot.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    circularPlot.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    circularPlot.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    circularPlot.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    circularPlot.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    circularPlot.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    circularPlot.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    circularPlot.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    circularPlot.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    circularPlot.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickMarkColor": {
                    circularPlot.setTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textColor": {
                    circularPlot.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    circularPlot.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "segmentGap": {
                    circularPlot.setSegmentGap(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "showFlowDirection": {
                    circularPlot.setShowFlowDirection(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "minorTickMarksVisible": {
                    circularPlot.setMinorTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "mediumTickMarksVisible": {
                    circularPlot.setMediumTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "majorTickMarksVisible": {
                    circularPlot.setMajorTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickLabelsVisible": {
                    circularPlot.setTickLabelsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "onlyFirstAndLastTickLabelVisible": {
                    circularPlot.setOnlyFirstAndLastTickLabelVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "connectionOpactiy": {
                    circularPlot.setConnectionOpacity(((DoubleProperty)this.properties.get(key)).get());
                }
            }
        }
        return circularPlot;
    }
}

