/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.BubbleGridChart;
import eu.hansolo.fx.charts.data.BubbleGridChartItem;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.fx.charts.tools.Topic;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;

public class BubbleGridChartBuilder<B extends BubbleGridChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected BubbleGridChartBuilder() {
    }

    public static final BubbleGridChartBuilder create() {
        return new BubbleGridChartBuilder();
    }

    public final B items(BubbleGridChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<BubbleGridChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B chartBackground(Color COLOR) {
        this.properties.put("chartBackground", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B gridColor(Color COLOR) {
        this.properties.put("gridColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B autoBubbleTextColor(boolean AUTO) {
        this.properties.put("autoBubbleTextColor", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B showGrid(boolean SHOW) {
        this.properties.put("showGrid", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B showValues(boolean SHOW) {
        this.properties.put("showValues", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B showPercentage(boolean SHOW) {
        this.properties.put("showPercentage", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B useXCategoryFill() {
        this.properties.put("useXCategoryFill", null);
        return (B)this;
    }

    public final B useYCategoryFill() {
        this.properties.put("useXCategoryFill", null);
        return (B)this;
    }

    public final B sortCategoryX(Topic TOPIC, Order ORDER) {
        this.properties.put("sortCategoryXTopic", (Property)new SimpleObjectProperty((Object)TOPIC));
        this.properties.put("sortCategoryXOrder", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B sortCategoryY(Topic TOPIC, Order ORDER) {
        this.properties.put("sortCategoryYTopic", (Property)new SimpleObjectProperty((Object)TOPIC));
        this.properties.put("sortCategoryYOrder", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B useGradientFill(boolean USE) {
        this.properties.put("useGradientFill", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B shortenNumbers(boolean SHORTEN) {
        this.properties.put("shortenNumbers", (Property)new SimpleBooleanProperty(SHORTEN));
        return (B)this;
    }

    public final B minColor(Color MIN_COLOR) {
        this.properties.put("minColor", (Property)new SimpleObjectProperty((Object)MIN_COLOR));
        return (B)this;
    }

    public final B maxColor(Color MAX_COLOR) {
        this.properties.put("maxColor", (Property)new SimpleObjectProperty((Object)MAX_COLOR));
        return (B)this;
    }

    public final B gradient(LinearGradient GRADIENT) {
        this.properties.put("gradient", (Property)new SimpleObjectProperty((Object)GRADIENT));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final BubbleGridChart build() {
        BubbleGridChart bubbleGridChart = new BubbleGridChart();
        if (this.properties.keySet().contains("itemsArray")) {
            bubbleGridChart.setItems((BubbleGridChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            bubbleGridChart.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    bubbleGridChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    bubbleGridChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    bubbleGridChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    bubbleGridChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    bubbleGridChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    bubbleGridChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    bubbleGridChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    bubbleGridChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    bubbleGridChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    bubbleGridChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    bubbleGridChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    bubbleGridChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    bubbleGridChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    bubbleGridChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    bubbleGridChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    bubbleGridChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "chartBackground": {
                    bubbleGridChart.setChartBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textColor": {
                    bubbleGridChart.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "autoBubbleTextColor": {
                    bubbleGridChart.setAutoBubbleTextColor(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "gridColor": {
                    bubbleGridChart.setGridColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "showGrid": {
                    bubbleGridChart.setShowGrid(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "showValues": {
                    bubbleGridChart.setShowValues(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "showPercentage": {
                    bubbleGridChart.setShowPercentage(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useXCategoryFill": {
                    bubbleGridChart.useXCategoryFill();
                    break;
                }
                case "useYCategoryFill": {
                    bubbleGridChart.useYCategoryFill();
                    break;
                }
                case "sortCategoryXTopic": {
                    bubbleGridChart.sortCategoryX((Topic)((Object)((ObjectProperty)this.properties.get("sortCategoryXTopic")).get()), (Order)((Object)((ObjectProperty)this.properties.get("sortCategoryXOrder")).get()));
                    break;
                }
                case "sortCategoryYTopic": {
                    bubbleGridChart.sortCategoryY((Topic)((Object)((ObjectProperty)this.properties.get("sortCategoryYTopic")).get()), (Order)((Object)((ObjectProperty)this.properties.get("sortCategoryYOrder")).get()));
                    break;
                }
                case "useGradientFill": {
                    bubbleGridChart.setUseGradientFill(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "shortenNumbers": {
                    bubbleGridChart.setShortenNumbers(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "minColor": {
                    bubbleGridChart.setMinColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxColor": {
                    bubbleGridChart.setMaxColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "gradient": {
                    bubbleGridChart.setGradient((LinearGradient)((ObjectProperty)this.properties.get(key)).get());
                }
            }
        }
        return bubbleGridChart;
    }
}

