/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.BubbleGridChartItem;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.fx.charts.tools.Topic;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolboxfx.FontMetrix;
import eu.hansolo.toolboxfx.font.Fonts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class BubbleGridChart
extends Region {
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private ObservableList<BubbleGridChartItem> items = FXCollections.observableArrayList();
    private List<ChartItem> xCategoryItems = new ArrayList<ChartItem>();
    private List<ChartItem> yCategoryItems = new ArrayList<ChartItem>();
    private Map<ChartItem, Double> sumsOfXCategoryItems = new HashMap<ChartItem, Double>();
    private Map<ChartItem, Double> sumsOfYCategoryItems = new HashMap<ChartItem, Double>();
    private double sumOfValues = 0.0;
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private EvtObserver<ChartEvt> itemObserver;
    private ListChangeListener<BubbleGridChartItem> itemListListener;
    private InfoPopup popup;
    private Paint _chartBackground;
    private ObjectProperty<Paint> chartBackground;
    private Color _gridColor;
    private ObjectProperty<Color> gridColor;
    private boolean _showGrid = true;
    private BooleanProperty showGrid;
    private Color _textColor = Color.BLACK;
    private ObjectProperty<Color> textColor;
    private boolean _autoBubbleTextColor = false;
    private BooleanProperty autoBubbleTextColor;
    private boolean useXCategoryFill = true;
    private boolean _showValues = true;
    private BooleanProperty showValues;
    private boolean _showPercentage = false;
    private BooleanProperty showPercentage;
    private boolean _useGradientFill = false;
    private BooleanProperty useGradientFill;
    private boolean _shortenNumbers = false;
    private BooleanProperty shortenNumbers;
    private Color _minColor;
    private ObjectProperty<Color> minColor;
    private Color _maxColor;
    private ObjectProperty<Color> maxColor;
    private LinearGradient gradient;
    private Topic sortTopicX;
    private Topic sortTopicY;
    private Order sortOrderX;
    private Order sortOrderY;
    private List<Bubble> bubbles;

    public BubbleGridChart() {
        this._chartBackground = Color.TRANSPARENT;
        this._gridColor = Color.rgb((int)0, (int)0, (int)0, (double)0.1);
        this._minColor = Color.web((String)"#2C67D5");
        this._maxColor = Color.web((String)"#F23C5A");
        this.gradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this._minColor), new Stop(1.0, this._maxColor)});
        this.bubbles = new ArrayList<Bubble>();
        this.sortTopicX = Topic.INDEX;
        this.sortTopicY = Topic.INDEX;
        this.sortOrderX = Order.ASCENDING;
        this.sortOrderY = Order.ASCENDING;
        this.itemObserver = e -> {
            this.minValue = this.items.parallelStream().min(Comparator.comparingDouble(BubbleGridChartItem::getValue)).map(bgci -> bgci.getValue()).orElse(0.0);
            this.maxValue = this.items.parallelStream().max(Comparator.comparingDouble(BubbleGridChartItem::getValue)).map(bgci -> bgci.getValue()).orElse(0.0);
            this.sumOfValues = this.items.parallelStream().mapToDouble(bgci -> bgci.getValue()).sum();
            this.sort();
        };
        this.itemListListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addChartEvtObserver(ChartEvt.ANY, this.itemObserver));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartEvtObserver(ChartEvt.ANY, this.itemObserver));
            }
            this.xCategoryItems = this.items.stream().map(bgci -> bgci.getCategoryX()).distinct().collect(Collectors.toList());
            this.yCategoryItems = this.items.stream().map(bgci -> bgci.getCategoryY()).distinct().collect(Collectors.toList());
            this.xCategoryItems.forEach(xCategoryItem -> this.sumsOfXCategoryItems.put((ChartItem)xCategoryItem, this.items.stream().filter(bgci -> bgci.getCategoryX().equals(xCategoryItem)).mapToDouble(bgci -> bgci.getValue()).sum()));
            this.yCategoryItems.forEach(yCategoryItem -> this.sumsOfYCategoryItems.put((ChartItem)yCategoryItem, this.items.stream().filter(bgci -> bgci.getCategoryY().equals(yCategoryItem)).mapToDouble(bgci -> bgci.getValue()).sum()));
            this.minValue = this.items.parallelStream().min(Comparator.comparingDouble(BubbleGridChartItem::getValue)).map(bgci -> bgci.getValue()).orElse(0.0);
            this.maxValue = this.items.parallelStream().max(Comparator.comparingDouble(BubbleGridChartItem::getValue)).map(bgci -> bgci.getValue()).orElse(0.0);
            this.sumOfValues = this.items.parallelStream().mapToDouble(bgci -> bgci.getValue()).sum();
            this.sort();
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 400.0);
            }
        }
        this.canvas = new Canvas(600.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.popup = new InfoPopup();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.addListener(this.itemListListener);
        this.items.forEach(item -> item.addChartEvtObserver(ChartEvt.ANY, this.itemObserver));
        this.canvas.setOnMouseClicked(e -> this.bubbles.forEach(bubble -> {
            if (Helper.isInCircle(e.getX(), e.getY(), bubble.x, bubble.y, bubble.r)) {
                this.popup.setX(e.getScreenX());
                this.popup.setY(e.getScreenY() - this.popup.getHeight());
                this.popup.update((Item)bubble.item, this.sumOfValues);
                this.popup.animatedShow(this.getScene().getWindow());
            }
        }));
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.forEach(item -> item.removeChartEvtObserver(ChartEvt.ANY, this.itemObserver));
        this.items.removeListener(this.itemListListener);
    }

    public Paint getChartBackground() {
        return null == this.chartBackground ? this._chartBackground : (Paint)this.chartBackground.get();
    }

    public void setChartBackground(Paint PAINT) {
        if (null == this.chartBackground) {
            this._chartBackground = PAINT;
            this.redraw();
        } else {
            this.chartBackground.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> chartBackgroundProperty() {
        if (null == this.chartBackground) {
            this.chartBackground = new ObjectPropertyBase<Paint>(this._chartBackground){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
            this._chartBackground = null;
        }
        return this.chartBackground;
    }

    public Color getGridColor() {
        return null == this.gridColor ? this._gridColor : (Color)this.gridColor.get();
    }

    public void setGridColor(Color COLOR) {
        if (null == this.gridColor) {
            this._gridColor = COLOR;
            this.redraw();
        } else {
            this.gridColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> gridColorProperty() {
        if (null == this.gridColor) {
            this.gridColor = new ObjectPropertyBase<Color>(this._gridColor){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "gridColor";
                }
            };
            this._gridColor = null;
        }
        return this.gridColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public boolean isAutoBubbleTextColor() {
        return null == this.autoBubbleTextColor ? this._autoBubbleTextColor : this.autoBubbleTextColor.get();
    }

    public void setAutoBubbleTextColor(boolean AUTO) {
        if (null == this.autoBubbleTextColor) {
            this._autoBubbleTextColor = AUTO;
            this.redraw();
        } else {
            this.autoBubbleTextColor.set(AUTO);
        }
    }

    public BooleanProperty autoBubbleTextColorProperty() {
        if (null == this.autoBubbleTextColor) {
            this.autoBubbleTextColor = new BooleanPropertyBase(this._autoBubbleTextColor){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "autoBubbleTextColor";
                }
            };
        }
        return this.autoBubbleTextColor;
    }

    public boolean getShowGrid() {
        return null == this.showGrid ? this._showGrid : this.showGrid.get();
    }

    public void setShowGrid(boolean SHOW) {
        if (null == this.showGrid) {
            this._showGrid = SHOW;
            this.redraw();
        } else {
            this.showGrid.set(SHOW);
        }
    }

    public BooleanProperty showGridProperty() {
        if (null == this.showGrid) {
            this.showGrid = new BooleanPropertyBase(this._showGrid){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "gridVisible";
                }
            };
        }
        return this.showGrid;
    }

    public boolean getShowValues() {
        return null == this.showValues ? this._showValues : this.showValues.get();
    }

    public void setShowValues(boolean SHOW) {
        if (null == this.showValues) {
            this._showValues = SHOW;
            this.redraw();
        } else {
            this.showValues.set(SHOW);
        }
    }

    public BooleanProperty showValuesProperty() {
        if (null == this.showValues) {
            this.showValues = new BooleanPropertyBase(){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "showValues";
                }
            };
        }
        return this.showValues;
    }

    public boolean getShowPercentage() {
        return null == this.showPercentage ? this._showPercentage : this.showPercentage.get();
    }

    public void setShowPercentage(boolean SHOW) {
        if (null == this.showPercentage) {
            this._showPercentage = SHOW;
            this.redraw();
        } else {
            this.showPercentage.set(SHOW);
        }
    }

    public BooleanProperty showPercentageProperty() {
        if (null == this.showPercentage) {
            this.showPercentage = new BooleanPropertyBase(this._showPercentage){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "showPercentage";
                }
            };
        }
        return this.showPercentage;
    }

    public List<BubbleGridChartItem> getItems() {
        return this.items;
    }

    public void setItems(BubbleGridChartItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<BubbleGridChartItem> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void addItem(BubbleGridChartItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
    }

    public void removeItem(BubbleGridChartItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
    }

    public void useXCategoryFill() {
        this.useXCategoryFill = true;
    }

    public void useYCategoryFill() {
        this.useXCategoryFill = false;
    }

    public boolean getUseGradientFill() {
        return null == this.useGradientFill ? this._useGradientFill : this.useGradientFill.get();
    }

    public void setUseGradientFill(boolean USE) {
        if (null == this.useGradientFill) {
            this._useGradientFill = USE;
            this.redraw();
        } else {
            this.useGradientFill.set(USE);
        }
    }

    public BooleanProperty useGradientFillProperty() {
        if (null == this.useGradientFill) {
            this.useGradientFill = new BooleanPropertyBase(this._useGradientFill){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "useGradientFill";
                }
            };
        }
        return this.useGradientFill;
    }

    public boolean getShortenNumbers() {
        return null == this.shortenNumbers ? this._shortenNumbers : this.shortenNumbers.get();
    }

    public void setShortenNumbers(boolean SHORTEN) {
        if (null == this.shortenNumbers) {
            this._shortenNumbers = SHORTEN;
            this.redraw();
        } else {
            this.shortenNumbers.set(SHORTEN);
        }
    }

    public BooleanProperty shortenNumbersProperty() {
        if (null == this.shortenNumbers) {
            this.shortenNumbers = new BooleanPropertyBase(this._shortenNumbers){

                protected void invalidated() {
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "shortenNumbers";
                }
            };
        }
        return this.shortenNumbers;
    }

    public Color getMinColor() {
        return null == this.minColor ? this._minColor : (Color)this.minColor.get();
    }

    public void setMinColor(Color MIN_COLOR) {
        if (null == this.minColor) {
            this._minColor = MIN_COLOR;
            this.gradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this._minColor), new Stop(1.0, this.getMaxColor())});
            this.redraw();
        } else {
            this.minColor.set((Object)MIN_COLOR);
        }
    }

    public ObjectProperty<Color> minColorProperty() {
        if (null == this.minColor) {
            this.minColor = new ObjectPropertyBase<Color>(this._minColor){

                protected void invalidated() {
                    BubbleGridChart.this.gradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, (Color)this.get()), new Stop(1.0, BubbleGridChart.this.getMaxColor())});
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "minColor";
                }
            };
            this._minColor = null;
        }
        return this.minColor;
    }

    public Color getMaxColor() {
        return null == this.maxColor ? this._maxColor : (Color)this.maxColor.get();
    }

    public void setMaxColor(Color MAX_COLOR) {
        if (null == this.maxColor) {
            this._maxColor = MAX_COLOR;
            this.gradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.getMinColor()), new Stop(1.0, this._minColor)});
            this.redraw();
        } else {
            this.maxColor.set((Object)MAX_COLOR);
        }
    }

    public ObjectProperty<Color> maxColorProperty() {
        if (null == this.maxColor) {
            this.maxColor = new ObjectPropertyBase<Color>(this._maxColor){

                protected void invalidated() {
                    BubbleGridChart.this.gradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, BubbleGridChart.this.getMinColor()), new Stop(1.0, (Color)this.get())});
                    BubbleGridChart.this.redraw();
                }

                public Object getBean() {
                    return BubbleGridChart.this;
                }

                public String getName() {
                    return "maxColor";
                }
            };
            this._maxColor = null;
        }
        return this.maxColor;
    }

    public void setGradient(LinearGradient gradient) {
        this.gradient = gradient;
        this.redraw();
    }

    public Topic getSortTopicX() {
        return this.sortTopicX;
    }

    public void setSortTopicX(Topic TOPIC) {
        this.sortCategoryX(TOPIC, this.getSortOrderX());
    }

    public Topic getSortTopicY() {
        return this.sortTopicY;
    }

    public void setSortTopicY(Topic TOPIC) {
        this.sortCategoryY(TOPIC, this.getSortOrderY());
    }

    public Order getSortOrderX() {
        return this.sortOrderX;
    }

    public void setSortOrderX(Order ORDER) {
        this.sortCategoryX(this.getSortTopicX(), ORDER);
    }

    public Order getSortOrderY() {
        return this.sortOrderY;
    }

    public void setSortOrderY(Order ORDER) {
        this.sortCategoryY(this.getSortTopicY(), ORDER);
    }

    public void sortCategoryX(Topic TOPIC, Order ORDER) {
        this.sortTopicX = TOPIC;
        this.sortOrderX = ORDER;
        block0 : switch (TOPIC) {
            case INDEX: {
                switch (ORDER) {
                    case ASCENDING: {
                        Collections.sort(this.xCategoryItems, Comparator.comparing(ChartItem::getIndex));
                        break;
                    }
                    case DESCENDING: {
                        Collections.sort(this.xCategoryItems, Comparator.comparing(ChartItem::getIndex).reversed());
                    }
                }
                break;
            }
            case VALUE: {
                switch (ORDER) {
                    case ASCENDING: {
                        Map sortedByValue = this.sumsOfXCategoryItems.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                        this.xCategoryItems.clear();
                        this.xCategoryItems.addAll(sortedByValue.keySet());
                        break;
                    }
                    case DESCENDING: {
                        Map sortedByValue = this.sumsOfXCategoryItems.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                        this.xCategoryItems.clear();
                        this.xCategoryItems.addAll(sortedByValue.keySet());
                    }
                }
                break;
            }
            case NAME: {
                switch (ORDER) {
                    case ASCENDING: {
                        List sorted = this.xCategoryItems.stream().sorted(Comparator.comparing(ChartItem::getName)).collect(Collectors.toList());
                        this.xCategoryItems.clear();
                        this.xCategoryItems.addAll(sorted);
                        break block0;
                    }
                    case DESCENDING: {
                        List sorted = this.xCategoryItems.stream().sorted(Comparator.comparing(ChartItem::getName).reversed()).collect(Collectors.toList());
                        this.xCategoryItems.clear();
                        this.xCategoryItems.addAll(sorted);
                    }
                }
            }
        }
        this.redraw();
    }

    public void sortCategoryY(Topic TOPIC, Order ORDER) {
        this.sortTopicY = TOPIC;
        this.sortOrderY = ORDER;
        block0 : switch (TOPIC) {
            case INDEX: {
                switch (ORDER) {
                    case ASCENDING: {
                        Collections.sort(this.yCategoryItems, Comparator.comparing(ChartItem::getIndex).reversed());
                        break;
                    }
                    case DESCENDING: {
                        Collections.sort(this.yCategoryItems, Comparator.comparing(ChartItem::getIndex));
                    }
                }
                break;
            }
            case VALUE: {
                switch (ORDER) {
                    case ASCENDING: {
                        Map sortedByValue = this.sumsOfYCategoryItems.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                        this.yCategoryItems.clear();
                        this.yCategoryItems.addAll(sortedByValue.keySet());
                        break;
                    }
                    case DESCENDING: {
                        Map sortedByValue = this.sumsOfYCategoryItems.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                        this.yCategoryItems.clear();
                        this.yCategoryItems.addAll(sortedByValue.keySet());
                    }
                }
                break;
            }
            case NAME: {
                switch (ORDER) {
                    case ASCENDING: {
                        List sorted = this.yCategoryItems.stream().sorted(Comparator.comparing(ChartItem::getName)).collect(Collectors.toList());
                        this.yCategoryItems.clear();
                        this.yCategoryItems.addAll(sorted);
                        break block0;
                    }
                    case DESCENDING: {
                        List sorted = this.yCategoryItems.stream().sorted(Comparator.comparing(ChartItem::getName).reversed()).collect(Collectors.toList());
                        this.yCategoryItems.clear();
                        this.yCategoryItems.addAll(sorted);
                    }
                }
            }
        }
        this.redraw();
    }

    public void removeAllData() {
        this.items.clear();
        this.xCategoryItems.clear();
        this.yCategoryItems.clear();
        this.sumsOfXCategoryItems.clear();
        this.sumsOfYCategoryItems.clear();
        this.sumOfValues = 0.0;
        this.minValue = Double.MAX_VALUE;
        this.maxValue = 0.0;
        this.redraw();
    }

    private void sort() {
        this.sortCategoryX(this.getSortTopicX(), this.getSortOrderX());
        this.sortCategoryY(this.getSortTopicY(), this.getSortOrderY());
    }

    private static <T> Predicate<T> distinctByName(Function<? super T, ?> nameExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(nameExtractor.apply(t));
    }

    protected void drawChart() {
        double cellCenterX;
        int x;
        this.bubbles.clear();
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        double noOfXCategoryItems = this.xCategoryItems.size();
        double noOfYCategoryItems = this.yCategoryItems.size();
        double yCategoryWidth = this.width * 0.14;
        double xCategoryHeight = this.height * 0.08333333;
        double maxYCategoryWidth = this.width * 0.12;
        double dataWidth = this.width - yCategoryWidth;
        double dataHeight = this.height - xCategoryHeight;
        double stepX = 0.0 == noOfXCategoryItems ? dataWidth : dataWidth / noOfXCategoryItems;
        double stepY = 0.0 == noOfYCategoryItems ? dataHeight : dataHeight / noOfYCategoryItems;
        double fontsize = this.height * 0.024;
        double dataFontSize = this.height * 0.021;
        double valueFontSize = this.height * 0.019;
        double maxBubbleDiameter = (stepX < stepY ? stepX : stepY) * 0.95;
        double maxBubbleRadius = maxBubbleDiameter * 0.5;
        double maxBubbleArea = Math.PI * maxBubbleRadius * maxBubbleRadius;
        double factor = maxBubbleArea / this.maxValue;
        Font chartFont = Fonts.latoLight((double)fontsize);
        Font dataFont = Fonts.latoRegular((double)dataFontSize);
        Font valueFont = Fonts.latoLight((double)valueFontSize);
        Font sumFont = Fonts.latoRegular((double)fontsize);
        this.ctx.setFill(this.getChartBackground());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        this.ctx.setTextBaseline(VPos.CENTER);
        if (this.getShowGrid()) {
            x = 0;
            while ((double)x < noOfXCategoryItems) {
                cellCenterX = yCategoryWidth + (double)x * stepX + stepX * 0.5;
                int y = 0;
                while ((double)y < noOfYCategoryItems) {
                    double cellCenterY = this.height - xCategoryHeight - (double)y * stepY - stepY * 0.5;
                    this.ctx.setStroke((Paint)this.getGridColor());
                    this.ctx.setLineDashes(new double[]{4.0, 2.0});
                    this.ctx.strokeLine(yCategoryWidth, cellCenterY, this.width, cellCenterY);
                    this.ctx.strokeLine(cellCenterX, this.height - xCategoryHeight, cellCenterX, 0.0);
                    ++y;
                }
                ++x;
            }
        }
        x = 0;
        while ((double)x < noOfXCategoryItems) {
            cellCenterX = yCategoryWidth + (double)x * stepX + stepX * 0.5;
            ChartItem xItem = this.xCategoryItems.get(x);
            this.ctx.setTextAlign(TextAlignment.CENTER);
            this.ctx.setFill((Paint)this.getTextColor());
            if (this.getShowValues() | this.getShowPercentage()) {
                this.ctx.setFont(chartFont);
                this.ctx.fillText(xItem.getName(), cellCenterX, this.height - xCategoryHeight * 0.68, stepX);
                this.ctx.setFont(valueFont);
                if (this.getShowValues() && !this.getShowPercentage()) {
                    if (this.getShortenNumbers()) {
                        this.ctx.fillText("(" + Helper.shortenNumber(this.sumsOfXCategoryItems.get(xItem).longValue()) + ")", cellCenterX, this.height - xCategoryHeight * 0.3, stepX);
                    } else {
                        this.ctx.fillText("(" + String.format(Locale.US, "%.0f", this.sumsOfXCategoryItems.get(xItem)) + ")", cellCenterX, this.height - xCategoryHeight * 0.3, stepX);
                    }
                } else if (!this.getShowValues() && this.getShowPercentage()) {
                    this.ctx.fillText("(" + String.format(Locale.US, "%.0f%%", this.sumsOfXCategoryItems.get(xItem) / this.sumOfValues * 100.0) + ")", cellCenterX, this.height - xCategoryHeight * 0.3, stepX);
                } else if (this.getShortenNumbers()) {
                    this.ctx.fillText("(" + String.join((CharSequence)"/", Helper.shortenNumber(this.sumsOfXCategoryItems.get(xItem).longValue()), String.format(Locale.US, "%.0f%%", this.sumsOfXCategoryItems.get(xItem) / this.sumOfValues * 100.0)) + ")", cellCenterX, this.height - xCategoryHeight * 0.3, stepX);
                } else {
                    this.ctx.fillText("(" + String.join((CharSequence)"/", String.format(Locale.US, "%.0f", this.sumsOfXCategoryItems.get(xItem)), String.format(Locale.US, "%.0f%%", this.sumsOfXCategoryItems.get(xItem) / this.sumOfValues * 100.0)) + ")", cellCenterX, this.height - xCategoryHeight * 0.3, stepX);
                }
            } else {
                this.ctx.setFont(chartFont);
                this.ctx.fillText(xItem.getName(), cellCenterX, this.height - xCategoryHeight * 0.5, stepX);
            }
            int y = 0;
            while ((double)y < noOfYCategoryItems) {
                Optional<BubbleGridChartItem> item;
                this.ctx.setFont(chartFont);
                double cellCenterY = this.height - xCategoryHeight - (double)y * stepY - stepY * 0.5;
                ChartItem yItem = this.yCategoryItems.get(y);
                if (x == 0) {
                    this.ctx.setTextAlign(TextAlignment.CENTER);
                    this.ctx.setFill((Paint)this.getTextColor());
                    if (this.getShowValues() | this.getShowPercentage()) {
                        this.ctx.setFont(chartFont);
                        this.ctx.fillText(yItem.getName(), yCategoryWidth * 0.5, cellCenterY - stepY * 0.18, maxYCategoryWidth);
                        this.ctx.setFont(valueFont);
                        if (this.getShowValues() && !this.getShowPercentage()) {
                            if (this.getShortenNumbers()) {
                                this.ctx.fillText("(" + Helper.shortenNumber(this.sumsOfYCategoryItems.get(yItem).longValue()) + ")", yCategoryWidth * 0.5, cellCenterY + stepY * 0.18, maxYCategoryWidth);
                            } else {
                                this.ctx.fillText("(" + String.format(Locale.US, "%.0f", this.sumsOfYCategoryItems.get(yItem)) + ")", yCategoryWidth * 0.5, cellCenterY + stepY * 0.18, maxYCategoryWidth);
                            }
                        } else if (!this.getShowValues() && this.getShowPercentage()) {
                            this.ctx.fillText("(" + String.format(Locale.US, "%.0f%%", this.sumsOfYCategoryItems.get(yItem) / this.sumOfValues * 100.0) + ")", yCategoryWidth * 0.5, cellCenterY + stepY * 0.18, maxYCategoryWidth);
                        } else if (this.getShortenNumbers()) {
                            this.ctx.fillText("(" + String.join((CharSequence)"/", Helper.shortenNumber(this.sumsOfYCategoryItems.get(yItem).longValue()), String.format(Locale.US, "%.0f%%", this.sumsOfYCategoryItems.get(yItem) / this.sumOfValues * 100.0)) + ")", yCategoryWidth * 0.5, cellCenterY + stepY * 0.18, maxYCategoryWidth);
                        } else {
                            this.ctx.fillText("(" + String.join((CharSequence)"/", String.format(Locale.US, "%.0f", this.sumsOfYCategoryItems.get(yItem)), String.format(Locale.US, "%.0f%%", this.sumsOfYCategoryItems.get(yItem) / this.sumOfValues * 100.0)) + ")", yCategoryWidth * 0.5, cellCenterY + stepY * 0.18, maxYCategoryWidth);
                        }
                    } else {
                        this.ctx.fillText(yItem.getName(), yCategoryWidth * 0.5, cellCenterY, maxYCategoryWidth);
                    }
                }
                if ((item = this.items.stream().filter(ci -> ci.getCategoryY().equals(yItem)).filter(ci -> ci.getCategoryX().equals(xItem)).findFirst()).isPresent()) {
                    Color fill;
                    BubbleGridChartItem bgci = item.get();
                    double bubbleArea = bgci.getValue() * factor;
                    double radius = Math.sqrt(bubbleArea / Math.PI);
                    double diameter = radius * 2.0;
                    Color color = fill = this.useXCategoryFill ? xItem.getFill() : yItem.getFill();
                    if (this.getUseGradientFill()) {
                        fill = Helper.getColorAt(this.gradient, bgci.getValue() / (this.maxValue - this.minValue));
                    }
                    this.bubbles.add(new Bubble(cellCenterX, cellCenterY, radius, bgci));
                    this.ctx.setFill((Paint)fill);
                    this.ctx.fillOval(cellCenterX - radius, cellCenterY - radius, diameter, diameter);
                    if (diameter > dataFontSize * 1.5 && dataFontSize > 7.0 && this.getShowValues()) {
                        this.ctx.setFont(dataFont);
                        this.ctx.setTextAlign(TextAlignment.CENTER);
                        if (this.isAutoBubbleTextColor()) {
                            this.ctx.setFill((Paint)(Helper.isDark(fill) ? Color.WHITE : Color.BLACK));
                        } else {
                            this.ctx.setFill((Paint)this.getTextColor());
                        }
                        String bubbleText = this.getShortenNumbers() ? Helper.shortenNumber((long)bgci.getValue()) : String.format(Locale.US, "%.0f", bgci.getValue());
                        FontMetrix metrix = new FontMetrix(dataFont);
                        metrix.computeStringWidth(bubbleText);
                        if (metrix.computeStringWidth(bubbleText) < radius * 2.0) {
                            this.ctx.fillText(bubbleText, cellCenterX, cellCenterY, maxBubbleDiameter);
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
        if (this.getShowValues()) {
            this.ctx.setFill((Paint)this.getTextColor());
            this.ctx.setFont(sumFont);
            if (this.getShortenNumbers()) {
                this.ctx.fillText("Sum\n" + Helper.shortenNumber((long)this.sumOfValues), yCategoryWidth * 0.5, this.height - xCategoryHeight * 0.5, yCategoryWidth);
            } else {
                this.ctx.fillText("Sum\n" + String.format(Locale.US, "%.0f", this.sumOfValues), yCategoryWidth * 0.5, this.height - xCategoryHeight * 0.5, yCategoryWidth);
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.redraw();
        }
    }

    public void redraw() {
        this.drawChart();
    }

    private record Bubble(double x, double y, double r, BubbleGridChartItem item) {
    }
}

