/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.color.MaterialDesignColors;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.fx.charts.tools.TooltipPopup;
import eu.hansolo.toolbox.Statistics;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolboxfx.font.Fonts;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class BoxPlots<T extends ChartItem>
extends Region {
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.TRANSPARENT;
    public static final Color DEFAULT_WHISKER_STROKE_COLOR = Color.BLACK;
    public static final Color DEFAULT_IQR_FILL_COLOR = Color.TRANSPARENT;
    public static final Color DEFAULT_IQR_STROKE_COLOR = Color.BLACK;
    public static final Color DEFAULT_MEDIAN_STROKE_COLOR = Color.RED;
    public static final Color DEFAULT_OUTLIER_FILL_COLOR = MaterialDesignColors.LIGHT_BLUE_300.get();
    public static final Color DEFAULT_OUTLIER_STROKE_COLOR = Color.TRANSPARENT;
    public static final Color DEFAULT_TEXT_FILL_COLOR = Color.BLACK;
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private List<ChartItemSeries<T>> seriesList = new LinkedList<ChartItemSeries<T>>();
    private EvtObserver<ChartEvt> itemObserver = e -> this.redraw();
    private ListChangeListener<T> itemListListener;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private String formatString;
    private TooltipPopup popup;
    private double median = 0.0;
    private double q1 = 0.0;
    private double q3 = 0.0;
    private double iqr = 0.0;
    private double iqrFraction;
    private double minimum = 0.0;
    private double maximum = 0.0;
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private double min;
    private double max;
    private String _name;
    private StringProperty name;
    private Color _backgroundColor;
    private ObjectProperty<Color> backgroundColor;
    private Color _whiskerStrokeColor;
    private ObjectProperty<Color> whiskerStrokeColor;
    private Color _iqrFillColor;
    private ObjectProperty<Color> iqrFillColor;
    private Color _iqrStrokeColor;
    private ObjectProperty<Color> iqrStrokeColor;
    private Color _medianStrokeColor;
    private ObjectProperty<Color> medianStrokeColor;
    private Color _outlierFillColor;
    private ObjectProperty<Color> outlierFillColor;
    private Color _outlierStrokeColor;
    private ObjectProperty<Color> outlierStrokeColor;
    private boolean _nameVisible = false;
    private BooleanProperty nameVisible;
    private Color _textFillColor;
    private ObjectProperty<Color> textFillColor;
    private boolean sorted = false;
    private Map<ChartItemSeries<T>, BoxPlotData> data = new LinkedHashMap<ChartItemSeries<T>, BoxPlotData>();
    private Axis _yAxis = null;
    private ObjectProperty<Axis> yAxis;

    public BoxPlots() {
        this(new ArrayList<ChartItemSeries<T>>());
    }

    public BoxPlots(List<ChartItemSeries<T>> SERIES_LIST) {
        this.itemListListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver));
            }
            this.data.clear();
            this.seriesList.forEach(series -> {
                ObservableList items = series.getItems();
                List values = items.stream().map(item -> item.getValue()).collect(Collectors.toList());
                this.median = Statistics.getMedian(values);
                this.q1 = Statistics.percentile(values, (double)25.0);
                this.q3 = Statistics.percentile(values, (double)75.0);
                this.iqr = this.q3 - this.q1;
                this.iqrFraction = this.iqr * 1.5;
                this.minValue = items.stream().min(Comparator.comparing(ChartItem::getValue)).get().getValue();
                this.maxValue = items.stream().max(Comparator.comparing(ChartItem::getValue)).get().getValue();
                this.minimum = values.stream().filter(v -> v > this.q1 - this.iqrFraction).min(Comparator.naturalOrder()).get();
                this.maximum = values.stream().filter(v -> v < this.q3 + this.iqrFraction).max(Comparator.naturalOrder()).get();
                List outliers = items.stream().filter(item -> item.getValue() < this.minimum).collect(Collectors.toList());
                outliers.addAll(items.stream().filter(item -> item.getValue() > this.maximum).collect(Collectors.toList()));
                this.data.put((ChartItemSeries<T>)series, new BoxPlotData(series.getName(), this.median, this.q1, this.q3, this.iqr, this.minValue, this.maxValue, this.minimum, this.maximum, outliers));
            });
            this.sorted = false;
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
            for (Map.Entry<ChartItemSeries<T>, BoxPlotData> d : this.data.entrySet()) {
                BoxPlotData boxPlotData = d.getValue();
                this.min = Math.min(this.min, Math.min(boxPlotData.minValue, boxPlotData.minimum));
                this.max = Math.max(this.max, Math.max(boxPlotData.maxValue, boxPlotData.maximum));
            }
            if (null != this.getYAxis()) {
                this.getYAxis().setMinValue(this.min);
                this.getYAxis().setMaxValue(this.max);
            }
        };
        this._backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this._whiskerStrokeColor = DEFAULT_WHISKER_STROKE_COLOR;
        this._iqrFillColor = DEFAULT_IQR_FILL_COLOR;
        this._iqrStrokeColor = DEFAULT_IQR_STROKE_COLOR;
        this._medianStrokeColor = DEFAULT_MEDIAN_STROKE_COLOR;
        this._outlierFillColor = DEFAULT_OUTLIER_FILL_COLOR;
        this._outlierStrokeColor = DEFAULT_OUTLIER_STROKE_COLOR;
        this._textFillColor = DEFAULT_TEXT_FILL_COLOR;
        this._locale = Locale.getDefault();
        this.formatString = "%." + this._decimals + "f";
        this.popup = new TooltipPopup("", 3500L, true);
        this.seriesList.addAll(null == SERIES_LIST ? new LinkedList() : SERIES_LIST);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 400.0);
            }
        }
        this.canvas = new Canvas(600.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.popup.setOnHiding(e -> this.popup.setText(""));
        this.seriesList.forEach(series -> series.getItems().addListener(this.itemListListener));
        this.canvas.setOnMousePressed(e -> {
            double x = e.getSceneX();
            double y = e.getSceneY();
            double boxPlotWidth = this.width / (double)this.seriesList.size();
            for (int i = 0; i < this.seriesList.size(); ++i) {
                if (!(x > (double)i * boxPlotWidth) || !(x < (double)i * boxPlotWidth + boxPlotWidth)) continue;
                BoxPlotData boxPlotData = this.data.get(this.seriesList.get(i));
                String tooltipText = "Name    : " + boxPlotData.name() + "\n" + "maxValue: " + String.format(this.getLocale(), this.formatString, boxPlotData.maxValue()) + "\n" + "Maximum : " + String.format(this.getLocale(), this.formatString, boxPlotData.maximum()) + "\n" + "Q3      : " + String.format(this.getLocale(), this.formatString, boxPlotData.q3()) + "\n" + "IQR     : " + String.format(this.getLocale(), this.formatString, boxPlotData.iqr()) + "\n" + "Median  : " + String.format(this.getLocale(), this.formatString, boxPlotData.median()) + "\n" + "Q1      : " + String.format(this.getLocale(), this.formatString, boxPlotData.q1()) + "\n" + "Minimum : " + String.format(this.getLocale(), this.formatString, boxPlotData.minimum()) + "\n" + "minValue: " + String.format(this.getLocale(), this.formatString, boxPlotData.minValue());
                if (tooltipText.isEmpty()) continue;
                this.popup.setX(e.getScreenX() - this.popup.getWidth() * 0.5);
                this.popup.setY(e.getScreenY() - 30.0);
                this.popup.setText(tooltipText);
                this.popup.animatedShow(this.getScene().getWindow());
            }
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.seriesList.forEach(series -> series.getItems().removeListener(this.itemListListener));
    }

    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String name) {
        if (null == this.name) {
            this._name = name;
            this.redraw();
        } else {
            this.name.set((Object)name);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public List<ChartItemSeries<T>> getSeriesList() {
        return this.seriesList;
    }

    public void setSeriesList(List<ChartItemSeries<T>> SERIES_LIST) {
        this.seriesList.forEach(series -> series.getItems().removeListener(this.itemListListener));
        this.seriesList.clear();
        this.seriesList.addAll(null == SERIES_LIST ? new LinkedList() : SERIES_LIST);
        this.seriesList.forEach(series -> series.getItems().addListener(this.itemListListener));
        this.redraw();
    }

    public void addSeries(ChartItemSeries<T> SERIES) {
        if (!this.seriesList.contains(SERIES)) {
            this.seriesList.add(SERIES);
            SERIES.getItems().addListener(this.itemListListener);
            this.redraw();
        }
    }

    public void removeSeries(ChartItemSeries<T> SERIES) {
        if (this.seriesList.contains(SERIES)) {
            SERIES.getItems().removeListener(this.itemListListener);
            this.seriesList.remove(SERIES);
            this.redraw();
        }
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this.getDecimals() + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    BoxPlots.this.formatString = "%." + this.get() + "f";
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = LOCALE;
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "locale";
                }
            };
        }
        this._locale = null;
        return this.locale;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (null == this.backgroundColor) {
            this._backgroundColor = backgroundColor;
            this.redraw();
        } else {
            this.backgroundColor.set((Object)backgroundColor);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getIqrFillColor() {
        return null == this.iqrFillColor ? this._iqrFillColor : (Color)this.iqrFillColor.get();
    }

    public void setIqrFillColor(Color iqrFillColor) {
        if (null == this.iqrFillColor) {
            this._iqrFillColor = iqrFillColor;
            this.redraw();
        } else {
            this.iqrFillColor.set((Object)iqrFillColor);
        }
    }

    public ObjectProperty<Color> iqrFillColorProperty() {
        if (null == this.iqrFillColor) {
            this.iqrFillColor = new ObjectPropertyBase<Color>(this._iqrFillColor){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "iqrFillColor";
                }
            };
            this._iqrFillColor = null;
        }
        return this.iqrFillColor;
    }

    public Color getIqrStrokeColor() {
        return null == this.iqrStrokeColor ? this._iqrStrokeColor : (Color)this.iqrStrokeColor.get();
    }

    public void setIqrStrokeColor(Color iqrStrokeColor) {
        if (null == this.iqrStrokeColor) {
            this._iqrStrokeColor = iqrStrokeColor;
            this.redraw();
        } else {
            this.iqrStrokeColor.set((Object)iqrStrokeColor);
        }
    }

    public ObjectProperty<Color> iqrStrokeColorProperty() {
        if (null == this.iqrStrokeColor) {
            this.iqrStrokeColor = new ObjectPropertyBase<Color>(this._iqrStrokeColor){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "iqrStrokeColor";
                }
            };
            this._iqrStrokeColor = null;
        }
        return this.iqrStrokeColor;
    }

    public Color getWhiskerStrokeColor() {
        return null == this.whiskerStrokeColor ? this._whiskerStrokeColor : (Color)this.whiskerStrokeColor.get();
    }

    public void setWhiskerStrokeColor(Color whiskerStrokeColor) {
        if (null == this.whiskerStrokeColor) {
            this._whiskerStrokeColor = whiskerStrokeColor;
            this.redraw();
        } else {
            this.whiskerStrokeColor.set((Object)whiskerStrokeColor);
        }
    }

    public ObjectProperty<Color> whiskerStrokeColorProperty() {
        if (null == this.whiskerStrokeColor) {
            this.whiskerStrokeColor = new ObjectPropertyBase<Color>(this._whiskerStrokeColor){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "whiskerStrokeColor";
                }
            };
            this._whiskerStrokeColor = null;
        }
        return this.whiskerStrokeColor;
    }

    public Color getMedianStrokeColor() {
        return null == this.medianStrokeColor ? this._medianStrokeColor : (Color)this.medianStrokeColor.get();
    }

    public void setMedianStrokeColor(Color medianStrokeColor) {
        if (null == this.medianStrokeColor) {
            this._medianStrokeColor = medianStrokeColor;
            this.redraw();
        } else {
            this.medianStrokeColor.set((Object)medianStrokeColor);
        }
    }

    public ObjectProperty<Color> medianStrokeColorProperty() {
        if (null == this.medianStrokeColor) {
            this.medianStrokeColor = new ObjectPropertyBase<Color>(this._medianStrokeColor){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "medianStrokeColor";
                }
            };
            this._medianStrokeColor = null;
        }
        return this.medianStrokeColor;
    }

    public Color getOutlierStrokeColor() {
        return null == this.outlierStrokeColor ? this._outlierStrokeColor : (Color)this.outlierStrokeColor.get();
    }

    public void setOutlierStrokeColor(Color outlierStrokeColor) {
        if (null == this.outlierStrokeColor) {
            this._outlierStrokeColor = outlierStrokeColor;
            this.redraw();
        } else {
            this.outlierStrokeColor.set((Object)outlierStrokeColor);
        }
    }

    public ObjectProperty<Color> outlierStrokeColorProperty() {
        if (null == this.outlierStrokeColor) {
            this.outlierStrokeColor = new ObjectPropertyBase<Color>(this._outlierStrokeColor){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "outlierStrokeColor";
                }
            };
            this._outlierStrokeColor = null;
        }
        return this.outlierStrokeColor;
    }

    public Color getOutlierFillColor() {
        return null == this.outlierFillColor ? this._outlierFillColor : (Color)this.outlierFillColor.get();
    }

    public void setOutlierFillColor(Color outlierFillColor) {
        if (null == this.outlierFillColor) {
            this._outlierFillColor = outlierFillColor;
            this.redraw();
        } else {
            this.outlierFillColor.set((Object)outlierFillColor);
        }
    }

    public ObjectProperty<Color> outlierFillColorProperty() {
        if (null == this.outlierFillColor) {
            this.outlierFillColor = new ObjectPropertyBase<Color>(this._outlierFillColor){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "outlierFillColor";
                }
            };
            this._outlierFillColor = null;
        }
        return this.outlierFillColor;
    }

    public boolean getNameVisible() {
        return null == this.nameVisible ? this._nameVisible : this.nameVisible.get();
    }

    public void setNameVisible(boolean nameVisible) {
        if (null == this.nameVisible) {
            this._nameVisible = nameVisible;
            this.redraw();
        } else {
            this.nameVisible.set(nameVisible);
        }
    }

    public BooleanProperty nameVisibleProperty() {
        if (null == this.nameVisible) {
            this.nameVisible = new BooleanPropertyBase(this._nameVisible){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "nameVisible";
                }
            };
        }
        return this.nameVisible;
    }

    public Color getTextFillColor() {
        return null == this.textFillColor ? this._textFillColor : (Color)this.textFillColor.get();
    }

    public void setTextFillColor(Color textFillColor) {
        if (null == this.textFillColor) {
            this._textFillColor = textFillColor;
            this.redraw();
        } else {
            this.textFillColor.set((Object)textFillColor);
        }
    }

    public ObjectProperty<Color> textFillColorProperty() {
        if (null == this.textFillColor) {
            this.textFillColor = new ObjectPropertyBase<Color>(this._textFillColor){

                protected void invalidated() {
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "textFillColor";
                }
            };
            this._textFillColor = null;
        }
        return this.textFillColor;
    }

    public void setPopupTimeout(long milliseconds) {
        this.popup.setTimeout(milliseconds);
    }

    public double getMedian(ChartItemSeries<T> series) {
        return this.data.get(series).median();
    }

    public double getQ1(ChartItemSeries<T> series) {
        return this.data.get(series).q1();
    }

    public double getQ3(ChartItemSeries<T> series) {
        return this.data.get(series).q3();
    }

    public double getIqr(ChartItemSeries<T> series) {
        return this.data.get(series).iqr();
    }

    public double getMinimum(ChartItemSeries<T> series) {
        return this.data.get(series).minimum();
    }

    public double getMaximum(ChartItemSeries<T> series) {
        return this.data.get(series).maximum();
    }

    public double getMinValue(ChartItemSeries<T> series) {
        return this.data.get(series).minValue();
    }

    public double getMaxValue(ChartItemSeries<T> series) {
        return this.data.get(series).maxValue();
    }

    public List<? extends ChartItem> getOutliers(ChartItemSeries<? extends ChartItem> series) {
        return this.data.get(series).outliers();
    }

    public Axis getYAxis() {
        return null == this.yAxis ? this._yAxis : (Axis)((Object)this.yAxis.get());
    }

    public void setYAxis(Axis yAxis) {
        if (null == this.yAxis) {
            this._yAxis = yAxis;
            this._yAxis.setMinValue(this.min);
            this._yAxis.setMaxValue(this.max);
            this._yAxis.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, (EvtObserver<ChartEvt>)((EvtObserver)e -> this.redraw()));
            this.redraw();
        } else {
            this.yAxis.set((Object)yAxis);
        }
    }

    public ObjectProperty<Axis> yAxisProperty() {
        if (null == this.yAxis) {
            this.yAxis = new ObjectPropertyBase<Axis>(this._yAxis){

                protected void invalidated() {
                    BoxPlots.this._yAxis.setMinValue(BoxPlots.this.min);
                    BoxPlots.this._yAxis.setMaxValue(BoxPlots.this.max);
                    BoxPlots.this._yAxis.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, (EvtObserver<ChartEvt>)((EvtObserver)e -> BoxPlots.this.redraw()));
                    BoxPlots.this.redraw();
                }

                public Object getBean() {
                    return BoxPlots.this;
                }

                public String getName() {
                    return "yAxis";
                }
            };
        }
        return this.yAxis;
    }

    public void resetYAxis() {
        this.getYAxis().removeAllChartEvtObservers();
        this._yAxis = null;
        this.yAxis = null;
        for (Map.Entry<ChartItemSeries<T>, BoxPlotData> d : this.data.entrySet()) {
            BoxPlotData boxPlotData = d.getValue();
            this.min = Math.min(this.min, Math.min(boxPlotData.minValue, boxPlotData.minimum));
            this.max = Math.max(this.max, Math.max(boxPlotData.maxValue, boxPlotData.maximum));
        }
        this.redraw();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.ctx.setTextBaseline(VPos.CENTER);
        }
        this.redraw();
    }

    private void redraw() {
        if (!this.sorted) {
            this.seriesList.forEach(series -> series.sort(Order.ASCENDING));
            this.sorted = true;
        }
        Color backgroundColor = this.getBackgroundColor();
        Color whiskerStrokeColor = this.getWhiskerStrokeColor();
        Color iqrStrokeColor = this.getIqrStrokeColor();
        Color iqrFillColor = Color.TRANSPARENT == this.getIqrFillColor() ? this.getBackgroundColor() : this.getIqrFillColor();
        Color medianStrokeColor = this.getMedianStrokeColor();
        Color outlierStrokeColor = this.getOutlierStrokeColor();
        Color outlierFillColor = this.getOutlierFillColor();
        Color textFillColor = this.getTextFillColor();
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill((Paint)this.getBackgroundColor());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        if (this.seriesList.isEmpty()) {
            return;
        }
        double insetY = 0.0;
        Axis yAxis = this.getYAxis();
        if (null != yAxis) {
            this.min = yAxis.getMinValue();
            this.max = yAxis.getMaxValue();
        }
        double rangeY = this.max - this.min;
        double chartHeight = this.height - 2.0 * insetY;
        double scaleFactorY = chartHeight / rangeY;
        double noOfSeries = this.seriesList.size();
        double boxPlotWidth = this.width / noOfSeries;
        double fontSize = boxPlotWidth * 0.1;
        this.ctx.setFont(Fonts.latoRegular((double)fontSize));
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        for (int i = 0; i < this.data.size(); ++i) {
            BoxPlotData boxPlotData = (BoxPlotData)this.data.values().stream().collect(Collectors.toList()).get(i);
            double minimumY = this.height - insetY - (boxPlotData.minimum() - this.min) * scaleFactorY;
            double q3Y = this.height - insetY - (boxPlotData.q3() - this.min) * scaleFactorY;
            double iqrY = boxPlotData.iqr() * scaleFactorY;
            double maximumY = this.height - insetY - (boxPlotData.maximum() - this.min) * scaleFactorY;
            double medianY = this.height - insetY - (boxPlotData.median() - this.min) * scaleFactorY;
            double outlierDiameter = boxPlotWidth * 0.1;
            double outlierRadius = outlierDiameter * 0.5;
            double offsetX = (double)i * boxPlotWidth;
            double centerX = offsetX + boxPlotWidth * 0.5;
            this.ctx.setStroke((Paint)whiskerStrokeColor);
            this.ctx.strokeLine(centerX, minimumY, centerX, maximumY);
            this.ctx.strokeLine(offsetX + boxPlotWidth * 0.35, minimumY, offsetX + boxPlotWidth * 0.65, minimumY);
            this.ctx.strokeLine(offsetX + boxPlotWidth * 0.35, maximumY, offsetX + boxPlotWidth * 0.65, maximumY);
            this.ctx.setStroke((Paint)iqrStrokeColor);
            this.ctx.setFill((Paint)iqrFillColor);
            this.ctx.fillRect(offsetX + boxPlotWidth * 0.2, q3Y, boxPlotWidth * 0.6, iqrY);
            this.ctx.strokeRect(offsetX + boxPlotWidth * 0.2, q3Y, boxPlotWidth * 0.6, iqrY);
            this.ctx.setStroke((Paint)medianStrokeColor);
            this.ctx.strokeLine(offsetX + boxPlotWidth * 0.2, medianY, offsetX + boxPlotWidth * 0.8, medianY);
            this.ctx.setStroke((Paint)outlierStrokeColor);
            this.ctx.setFill((Paint)outlierFillColor);
            for (int j = 0; j < boxPlotData.outliers().size(); ++j) {
                double value = boxPlotData.outliers().get(i).getValue();
                this.ctx.strokeOval(centerX - outlierRadius, this.height - insetY - (value - this.min) * scaleFactorY, outlierDiameter, outlierDiameter);
                this.ctx.fillOval(centerX - outlierRadius, this.height - insetY - (value - this.min) * scaleFactorY, outlierDiameter, outlierDiameter);
            }
            if (!this.getNameVisible()) continue;
            this.ctx.setFill((Paint)backgroundColor);
            this.ctx.fillRect(centerX - 1.0, minimumY - fontSize * 1.5, 2.0, fontSize);
            this.ctx.setFill((Paint)textFillColor);
            this.ctx.fillText(boxPlotData.name(), centerX, minimumY - fontSize, boxPlotWidth);
        }
    }

    public record BoxPlotData(String name, double median, double q1, double q3, double iqr, double minValue, double maxValue, double minimum, double maximum, List<? extends ChartItem> outliers) {
    }
}

