/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ArcChart;
import eu.hansolo.fx.charts.data.PlotItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class ArcChartBuilder<B extends ArcChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected ArcChartBuilder() {
    }

    public static final ArcChartBuilder create() {
        return new ArcChartBuilder();
    }

    public final B items(PlotItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<PlotItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B connectionOpacity(double OPACITY) {
        this.properties.put("connectionOpacity", (Property)new SimpleDoubleProperty(OPACITY));
        return (B)this;
    }

    public final B coloredConnections(boolean COLORED) {
        this.properties.put("coloredConnections", (Property)new SimpleBooleanProperty(COLORED));
        return (B)this;
    }

    public final B connectionColor(Color COLOR) {
        this.properties.put("connectionColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B selectionColor(Color COLOR) {
        this.properties.put("selectionColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B sortByCluster(boolean SORT) {
        this.properties.put("sortByCluster", (Property)new SimpleBooleanProperty(SORT));
        return (B)this;
    }

    public final B useFullCircle(boolean USE) {
        this.properties.put("useFullCircle", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B weightConnections(boolean WEIGHT) {
        this.properties.put("weightConnections", (Property)new SimpleBooleanProperty(WEIGHT));
        return (B)this;
    }

    public final B weightDots(boolean WEIGHT) {
        this.properties.put("weightDots", (Property)new SimpleBooleanProperty(WEIGHT));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final ArcChart build() {
        ArcChart arcChart = new ArcChart();
        if (this.properties.keySet().contains("itemsArray")) {
            arcChart.setItems((PlotItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            arcChart.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    arcChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    arcChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    arcChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    arcChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    arcChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    arcChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    arcChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    arcChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    arcChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    arcChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    arcChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    arcChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    arcChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    arcChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    arcChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    arcChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "tickMarkColor": {
                    arcChart.setTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textColor": {
                    arcChart.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    arcChart.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "connectionOpactiy": {
                    arcChart.setConnectionOpacity(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "coloredConnections": {
                    arcChart.setColoredConnections(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "connectionColor": {
                    arcChart.setConnectionColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectionColor": {
                    arcChart.setSelectionColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "sortByCluster": {
                    arcChart.setSortByCluster(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useFullCircle": {
                    arcChart.setUseFullCircle(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "weightConnections": {
                    arcChart.setWeightConnections(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "weightDots": {
                    arcChart.setWeightDots(((BooleanProperty)this.properties.get(key)).get());
                }
            }
        }
        return arcChart;
    }
}

