/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.ListStationIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Network
extends BaseNodeType {
    private static Pattern tempNetPattern = Pattern.compile("[1-9XYZ].?");
    int totalNumStations;
    int selectedNumStations;
    StationIterator stations = new ListStationIterator(new ArrayList<Station>());

    public Network() {
    }

    public Network(String code) {
        this.code = code;
    }

    public Network(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Network", reader);
        super.parseAttributes(startE);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("TotalNumberStations")) {
                    this.totalNumStations = StaxUtil.pullInt(reader, "TotalNumberStations");
                    continue;
                }
                if (elName.equals("SelectedNumberStations")) {
                    this.selectedNumStations = StaxUtil.pullInt(reader, "SelectedNumberStations");
                    continue;
                }
                if (elName.equals("Station")) {
                    this.stations = new StationIterator(reader, this);
                    break;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getNetworkId() {
        if (this.isTemporary() && this.getStartDateTime() != null) {
            return this.getNetworkCode() + ZonedDateTime.ofInstant(this.getStartDateTime(), TimeUtils.TZ_UTC).getYear();
        }
        return this.getNetworkCode();
    }

    public String getNetworkCode() {
        return this.getCode();
    }

    public void setNetworkCode(String code) {
        this.setCode(code);
    }

    public StationIterator getStations() {
        return this.stations;
    }

    public int getTotalNumStations() {
        return this.totalNumStations;
    }

    public int getSelectedNumStations() {
        return this.selectedNumStations;
    }

    public void setTotalNumStations(int totalNumStations) {
        this.totalNumStations = totalNumStations;
    }

    public void setSelectedNumStations(int selectedNumStations) {
        this.selectedNumStations = selectedNumStations;
    }

    public void setStations(StationIterator stations) {
        this.stations = stations;
    }

    public String toString() {
        return this.asIdString();
    }

    public String asIdString() {
        String out = this.getCode();
        if (this.isTemporary()) {
            out = out + this.getStartYear();
        }
        return out;
    }

    public int getStartYear() {
        return this.getStartDateTime().atZone(TimeUtils.TZ_UTC).getYear();
    }

    public String getStartYearString() {
        return "" + this.getStartYear();
    }

    public boolean isTemporary() {
        return tempNetPattern.matcher(this.getCode()).matches();
    }

    public void associateInDb(Network net) {
        this.setDbid(net.getDbid());
    }
}

