/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.BundleContextShim;
import dev.equo.solstice.Dictionaries;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.Unchecked;
import dev.equo.solstice.Unimplemented;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.internal.location.EquinoxLocations;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.condition.Condition;
import org.osgi.service.packageadmin.PackageAdmin;

public class ShimIdeBootstrapServices {
    public static void apply(Map<String, String> props, BundleContext contextUntyped) {
        BundleContextShim context = (BundleContextShim)contextUntyped;
        try {
            context.container.getLogServices().start((BundleContext)context);
        }
        catch (BundleException e) {
            context.logger.error("error instantiating logging", (Throwable)e);
        }
        context.registerService(Condition.class, Condition.INSTANCE, Dictionaries.of("osgi.condition.id", "true"));
        ShimIdeBootstrapServices.registerLocations((BundleContext)context, context.container.getLocations());
        context.registerService(EnvironmentInfo.class, context.container.getConfiguration(), null);
        Bundle systemBundle = context.getBundle("System Bundle");
        context.registerService(PackageAdmin.class, (PackageAdmin)systemBundle.adapt(PackageAdmin.class), Dictionaries.empty());
        context.registerService(DebugOptions.class, context.container.getConfiguration().getDebugOptions(), null);
        String instanceArea = context.getProperty("osgi.instance.area");
        if (instanceArea != null) {
            File instanceDir = Unchecked.get(() -> new File(URLEncoder.encode(instanceArea, StandardCharsets.UTF_8)));
            context.registerService(URLConverter.class, new JarUrlResolver(new File(instanceDir, "JarUrlResolver")), Dictionaries.of("protocol", "jar"));
        }
        context.registerService(BundleLocalization.class, new BundleLocalization(){

            public ResourceBundle getLocalization(Bundle bundle, String locale) {
                String localization = (String)bundle.getHeaders().get("Bundle-Localization");
                if (localization == null) {
                    URL defaultLocal = bundle.getEntry("OSGI-INF/l10n/bundle.properties");
                    if (defaultLocal != null) {
                        return this.parse(defaultLocal);
                    }
                    throw new MissingResourceException(NLS.bind((String)CommonMessages.activator_resourceBundleNotFound, (Object)locale), bundle.getSymbolicName(), "");
                }
                return this.parse(bundle.getEntry(localization + ".properties"));
            }

            private PropertyResourceBundle parse(URL url) {
                PropertyResourceBundle propertyResourceBundle;
                block8: {
                    InputStream input = url.openStream();
                    try {
                        propertyResourceBundle = new PropertyResourceBundle(input);
                        if (input == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw Unchecked.wrap(e);
                        }
                    }
                    input.close();
                }
                return propertyResourceBundle;
            }
        }, Dictionaries.empty());
        try {
            String xerces = "org.apache.xerces.jaxp.SAXParserFactoryImpl";
            Class.forName(xerces);
            System.setProperty("javax.xml.parsers.SAXParserFactory", xerces);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        context.registerService(SAXParserFactory.class, new XMLFactory(true), (Dictionary<String, ?>)null);
        context.registerService(DocumentBuilderFactory.class, new XMLFactory(false), (Dictionary<String, ?>)null);
    }

    public static void shimAndAtomos(Map<String, String> props, BundleContext contextUntyped) {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
    }

    static Collection<String> locationKeys() {
        return List.of("osgi.user.area", "osgi.instance.area", "osgi.configuration.area", "osgi.install.area", "eclipse.home.location");
    }

    private static Location getLocation(EquinoxLocations equinoxLocations, String name) {
        try {
            Method method = equinoxLocations.getClass().getMethod(name, new Class[0]);
            return (Location)method.invoke((Object)equinoxLocations, new Object[0]);
        }
        catch (Exception e) {
            throw Unchecked.wrap(e);
        }
    }

    private static void registerLocations(BundleContext bc, EquinoxLocations equinoxLocations) {
        Location location = ShimIdeBootstrapServices.getLocation(equinoxLocations, "getUserLocation");
        if (location != null) {
            ShimIdeBootstrapServices.register(bc, location, "osgi.user.area");
        }
        if ((location = ShimIdeBootstrapServices.getLocation(equinoxLocations, "getInstanceLocation")) != null) {
            ShimIdeBootstrapServices.register(bc, location, "osgi.instance.area");
        }
        if ((location = ShimIdeBootstrapServices.getLocation(equinoxLocations, "getConfigurationLocation")) != null) {
            ShimIdeBootstrapServices.register(bc, location, "osgi.configuration.area");
        }
        if ((location = ShimIdeBootstrapServices.getLocation(equinoxLocations, "getInstallLocation")) != null) {
            ShimIdeBootstrapServices.register(bc, location, "osgi.install.area");
        }
        if ((location = ShimIdeBootstrapServices.getLocation(equinoxLocations, "getEclipseHomeLocation")) != null) {
            ShimIdeBootstrapServices.register(bc, location, "eclipse.home.location");
        }
    }

    private static void register(BundleContext context, Location service, String type) {
        URL defaultUrl;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("type", type);
        URL url = service.getURL();
        if (url != null) {
            properties.put("url", url.toExternalForm());
        }
        if ((defaultUrl = service.getDefault()) != null) {
            properties.put("defaultUrl", defaultUrl.toExternalForm());
        }
        properties.put("service.ranking", Integer.MAX_VALUE);
        properties.put("service.pid", context.getBundle().getBundleId() + "." + service.getClass().getName());
        context.registerService(Location.class, (Object)service, properties);
    }

    static class XMLFactory<T>
    implements ServiceFactory<T> {
        private final boolean isSax;

        public XMLFactory(boolean isSax) {
            this.isSax = isSax;
        }

        public T getService(Bundle bundle, ServiceRegistration<T> registration) {
            try {
                if (this.isSax) {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setFeature("http://xml.org/sax/features/namespaces", true);
                    factory.setFeature("http://xml.org/sax/features/validation", false);
                    return (T)factory;
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newDefaultInstance();
                return (T)factory;
            }
            catch (Exception e) {
                throw Unchecked.wrap(e);
            }
        }

        public void ungetService(Bundle bundle, ServiceRegistration<T> registration, T service) {
        }
    }

    static class JarUrlResolver
    implements URLConverter {
        private final File dir;
        private static final String DOT_JAR_EX_SLASH = ".jar!/";

        JarUrlResolver(File dir) {
            this.dir = dir;
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }

        public URL toFileURL(URL url) throws IOException {
            File file = new File(this.dir, JarUrlResolver.filenameSafe(url.toExternalForm()));
            if (!file.exists()) {
                byte[] content;
                try (InputStream read = url.openStream();){
                    content = read.readAllBytes();
                }
                Files.write(file.toPath(), content, new OpenOption[0]);
            }
            return file.toURI().toURL();
        }

        public URL resolve(URL url) {
            return url;
        }

        private static String filenameSafe(String url) {
            int dotJarIdx = url.indexOf(DOT_JAR_EX_SLASH);
            if (dotJarIdx == -1) {
                throw Unimplemented.onPurpose("This is only for .jar!/ urls, this was " + url);
            }
            int jarNameStart = url.lastIndexOf(47, dotJarIdx);
            String beforeJar = url.substring(0, jarNameStart);
            String jar = url.substring(jarNameStart + 1, dotJarIdx);
            String inZip = url.substring(dotJarIdx + DOT_JAR_EX_SLASH.length());
            return NestedJars.filenameSafeHash(beforeJar) + "--" + JarUrlResolver.safe(jar) + "--" + JarUrlResolver.safe(inZip);
        }

        private static String safe(String in) {
            String allSafeCharacters = in.replaceAll("[^a-zA-Z0-9-+_.]", "-");
            String noDuplicateDash = allSafeCharacters.replaceAll("-+", "-");
            return noDuplicateDash;
        }
    }
}

