/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.transform;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DefaultDataFrame;
import de.unknownreality.dataframe.column.IntegerColumn;
import de.unknownreality.dataframe.transform.ColumnDataFrameTransform;
import java.util.LinkedHashMap;
import java.util.Map;

public class CountTransformer<T extends Comparable<T>>
implements ColumnDataFrameTransform<DataFrameColumn<T, ?>> {
    public static final String COUNTS_COLUMN = "counts";
    private boolean ignoreNA = true;

    public CountTransformer(boolean ignoreNA) {
        this.ignoreNA = ignoreNA;
    }

    public CountTransformer() {
        this(true);
    }

    @Override
    public DataFrame transform(DataFrameColumn<T, ?> source) {
        DataFrameColumn valueColumn;
        DefaultDataFrame countDataFrame = new DefaultDataFrame();
        try {
            valueColumn = (DataFrameColumn)source.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DataFrameRuntimeException(String.format("error creating column instance of '%s'", source.getClass()), e);
        }
        valueColumn.setName(source.getName());
        IntegerColumn countColumn = new IntegerColumn(COUNTS_COLUMN);
        LinkedHashMap<T, Integer> counts = new LinkedHashMap<T, Integer>();
        for (int i = 0; i < source.size(); ++i) {
            if (this.ignoreNA && source.isNA(i)) continue;
            T v = source.get(i);
            Integer count = (Integer)counts.get(v);
            Integer n = count = Integer.valueOf(count == null ? 0 : count);
            Integer n2 = count = Integer.valueOf(count + 1);
            counts.put(v, count);
        }
        for (Map.Entry entry : counts.entrySet()) {
            valueColumn.append((Comparable)entry.getKey());
            countColumn.append((Comparable)entry.getValue());
        }
        countDataFrame.addColumn(valueColumn);
        countDataFrame.addColumn(countColumn);
        return countDataFrame;
    }
}

