/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.sort;

import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.sort.SortColumn;
import java.util.Comparator;

public class RowColumnComparator
implements Comparator<DataRow> {
    private final SortColumn[] sortColumns;

    public RowColumnComparator(SortColumn[] sortColumns) {
        this.sortColumns = sortColumns;
    }

    @Override
    public int compare(DataRow r1, DataRow r2) {
        int c = 0;
        for (int i = 0; i < this.sortColumns.length; ++i) {
            SortColumn sortColumn = this.sortColumns[i];
            String name = sortColumn.getName();
            if (r1.isNA(name) && r2.isNA(name)) {
                c = 0;
                continue;
            }
            if (r1.isNA(name)) {
                return 1;
            }
            if (r2.isNA(name)) {
                return -1;
            }
            Comparable a = (Comparable)r1.get(sortColumn.getName());
            Comparable b = (Comparable)r2.get(sortColumn.getName());
            c = a.compareTo(b);
            int n = c = sortColumn.getDirection() == SortColumn.Direction.Ascending ? c : -c;
            if (c == 0) continue;
            return c;
        }
        return c;
    }
}

