/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.meta;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.io.ColumnInformation;
import de.unknownreality.dataframe.io.DataWriter;
import de.unknownreality.dataframe.io.ReadFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataFrameMeta {
    public static final String META_FILE_EXTENSION = "dfm";
    private Class<? extends ReadFormat> readFormatClass;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Map<String, Class<? extends DataFrameColumn>> columns = new LinkedHashMap<String, Class<? extends DataFrameColumn>>();
    private int size = 0;

    public static DataFrameMeta create(DataFrame dataFrame, Class<? extends ReadFormat> readFormatClass, DataWriter dataWriterBuilder) {
        return DataFrameMeta.create(readFormatClass, dataWriterBuilder.getMetaColumns(dataFrame), dataWriterBuilder.getSettings(dataFrame));
    }

    public static DataFrameMeta create(Class<? extends ReadFormat> readFormatClass, List<DataFrameColumn> columns, Map<String, String> writerAttributes) {
        int size = 0;
        if (!columns.isEmpty()) {
            size = columns.get(0).size();
        }
        return DataFrameMeta.create(size, readFormatClass, columns, writerAttributes);
    }

    public static DataFrameMeta create(int size, Class<? extends ReadFormat> readFormatClass, List<DataFrameColumn> columns, Map<String, String> writerAttributes) {
        DataFrameMeta dataFrameMetaFile = new DataFrameMeta();
        dataFrameMetaFile.readFormatClass = readFormatClass;
        dataFrameMetaFile.attributes = writerAttributes;
        dataFrameMetaFile.size = size;
        for (DataFrameColumn column : columns) {
            dataFrameMetaFile.columns.put(column.getName(), column.getClass());
        }
        return dataFrameMetaFile;
    }

    public Class<? extends ReadFormat> getReadFormatClass() {
        return this.readFormatClass;
    }

    public Map<String, Class<? extends DataFrameColumn>> getColumns() {
        return this.columns;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public int getSize() {
        return this.size;
    }

    public List<ColumnInformation> getColumnInformation() {
        ArrayList<ColumnInformation> columnInformations = new ArrayList<ColumnInformation>();
        int i = 0;
        for (Map.Entry<String, Class<? extends DataFrameColumn>> e : this.columns.entrySet()) {
            ColumnInformation information = new ColumnInformation(i++, e.getKey());
            information.setColumnType(e.getValue());
            columnInformations.add(information);
        }
        return columnInformations;
    }

    public DataFrameMeta() {
    }

    public DataFrameMeta(Map<String, Class<? extends DataFrameColumn>> columns, Class<? extends ReadFormat> readFormatClass, Map<String, String> attributes) {
        this.columns = columns;
        this.readFormatClass = readFormatClass;
        this.attributes = attributes;
    }

    public DataFrameMeta(int size, Map<String, Class<? extends DataFrameColumn>> columns, Class<? extends ReadFormat> readFormatClass, Map<String, String> attributes) {
        this(columns, readFormatClass, attributes);
        this.size = size;
    }
}

