/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join.impl;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinInfo;
import de.unknownreality.dataframe.join.JoinOperation;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import de.unknownreality.dataframe.join.impl.JoinOperationUtil;
import de.unknownreality.dataframe.join.impl.JoinTree;

public class OuterJoin
implements JoinOperation {
    @Override
    public JoinedDataFrame join(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        JoinInfo joinInfo = JoinOperationUtil.createJoinInfo(dfA, dfB, joinColumns, joinSuffixA, joinSuffixB);
        int[] joinIndicesA = JoinOperationUtil.getJoinIndices(dfA, joinInfo);
        int[] joinIndicesB = JoinOperationUtil.getJoinIndices(dfB, joinInfo);
        int joinSize = joinInfo.getHeader().size();
        JoinedDataFrame joinedDataFrame = new JoinedDataFrame(joinInfo);
        joinedDataFrame.set(joinInfo.getHeader());
        JoinTree joinTree = new JoinTree(JoinTree.LeafMode.All, dfA, dfB, joinColumns);
        for (JoinTree.JoinNode node : joinTree.getSavedLeafs()) {
            Comparable[] joinedRowValues;
            if (node.getIndicesB() == null || node.getIndicesB().isEmpty()) {
                for (Integer rowA : node.getIndicesA()) {
                    joinedRowValues = new Comparable[joinSize];
                    JoinOperationUtil.fillValues(joinIndicesA, dfA.getRow(rowA), joinedRowValues);
                    JoinOperationUtil.fillNA(joinedRowValues);
                    joinedDataFrame.append(joinedRowValues);
                }
                continue;
            }
            if (node.getIndicesA() == null || node.getIndicesA().isEmpty()) {
                for (Integer rowB : node.getIndicesB()) {
                    joinedRowValues = new Comparable[joinSize];
                    JoinOperationUtil.fillValues(joinIndicesB, dfB.getRow(rowB), joinedRowValues);
                    JoinOperationUtil.fillNA(joinedRowValues);
                    joinedDataFrame.append(joinedRowValues);
                }
                continue;
            }
            for (Integer rowA : node.getIndicesA()) {
                DataRow dataRowA = dfA.getRow(rowA);
                JoinOperationUtil.appendGroupJoinedRows(node.getIndicesB(), dfB, dataRowA, joinIndicesA, joinIndicesB, joinSize, joinedDataFrame);
            }
        }
        return joinedDataFrame;
    }
}

