/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join.impl;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class JoinOperationUtil {
    public static void fillValues(int[] joinIndices, DataRow row, Comparable<?>[] joinedRowValues) {
        for (int i = 0; i < joinIndices.length; ++i) {
            joinedRowValues[joinIndices[i]] = row.get(i);
        }
    }

    public static int[] getJoinIndices(DataFrame dataFrame, JoinInfo joinInfo) {
        int[] joindIndices = new int[dataFrame.getHeader().size()];
        int i = 0;
        for (String headerName : dataFrame.getHeader()) {
            int joinedIndex = joinInfo.getJoinedIndex(headerName, dataFrame);
            joindIndices[i++] = joinedIndex;
        }
        return joindIndices;
    }

    public static void fillNA(Comparable<?>[] joinedRowValues) {
        for (int i = 0; i < joinedRowValues.length; ++i) {
            if (joinedRowValues[i] != null) continue;
            joinedRowValues[i] = Values.NA;
        }
    }

    public static JoinInfo createJoinInfo(DataFrame dfA, DataFrame dfB, JoinColumn[] joinColumns, String suffixA, String suffixB) {
        String name;
        DataFrameHeader joinHeader = new DataFrameHeader();
        HashSet<String> joinColumnSetA = new HashSet<String>();
        HashSet<String> joinColumnSetB = new HashSet<String>();
        HashMap<String, String> joinedBToAMap = new HashMap<String, String>();
        for (JoinColumn column : joinColumns) {
            joinColumnSetA.add(column.getColumnA());
            joinColumnSetB.add(column.getColumnB());
            joinedBToAMap.put(column.getColumnB(), column.getColumnA());
        }
        JoinInfo info = new JoinInfo(joinHeader, dfA, dfB);
        for (String s : dfA.getHeader()) {
            name = joinColumnSetA.contains(s) ? s : (dfB.getHeader().contains(s) ? s + suffixA : s);
            info.addDataFrameAHeader(s, name);
            joinHeader.add(name, dfA.getHeader().getColumnType(s), dfA.getHeader().getType(s));
        }
        for (String s : dfB.getHeader()) {
            if (joinColumnSetB.contains(s)) {
                name = (String)joinedBToAMap.get(s);
                info.addDataFrameBHeader(s, name);
                continue;
            }
            name = dfA.getHeader().contains(s) ? s + suffixB : s;
            info.addDataFrameBHeader(s, name);
            joinHeader.add(name, dfB.getHeader().getColumnType(s), dfB.getHeader().getType(s));
        }
        return info;
    }

    public static void appendGroupJoinedRows(Collection<Integer> rowIndices, DataFrame dfB, DataRow rowA, int[] joinIndicesA, int[] joinIndicesB, int joinedSize, DataFrame joinedDataFrame) {
        for (Integer rowB : rowIndices) {
            Comparable[] joinedRowValues = new Comparable[joinedSize];
            JoinOperationUtil.fillValues(joinIndicesA, rowA, joinedRowValues);
            JoinOperationUtil.fillValues(joinIndicesB, dfB.getRow(rowB), joinedRowValues);
            JoinOperationUtil.fillNA(joinedRowValues);
            joinedDataFrame.append(joinedRowValues);
        }
    }
}

