/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join.impl;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinInfo;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import de.unknownreality.dataframe.join.impl.JoinOperationUtil;
import de.unknownreality.dataframe.join.impl.JoinTree;

public class DirectionJoinUtil {
    public static JoinedDataFrame createDirectionJoin(DataFrame dfA, DataFrame dfB, JoinInfo joinInfo, JoinColumn[] joinColumns) {
        int[] joinIndicesA = JoinOperationUtil.getJoinIndices(dfA, joinInfo);
        int[] joinIndicesB = JoinOperationUtil.getJoinIndices(dfB, joinInfo);
        int joinSize = joinInfo.getHeader().size();
        JoinedDataFrame joinedDataFrame = new JoinedDataFrame(joinInfo);
        joinedDataFrame.set(joinInfo.getHeader());
        JoinTree joinTree = new JoinTree(JoinTree.LeafMode.FirstOnly, dfA, dfB, joinColumns);
        for (JoinTree.JoinNode node : joinTree.getSavedLeafs()) {
            for (Integer rowA : node.getIndicesA()) {
                DataRow dataRowA = dfA.getRow(rowA);
                if (node.getIndicesB() == null) {
                    Comparable[] joinedRowValues = new Comparable[joinSize];
                    JoinOperationUtil.fillValues(joinIndicesA, dataRowA, joinedRowValues);
                    JoinOperationUtil.fillNA(joinedRowValues);
                    joinedDataFrame.append(joinedRowValues);
                    continue;
                }
                JoinOperationUtil.appendGroupJoinedRows(node.getIndicesB(), dfB, dataRowA, joinIndicesA, joinIndicesB, joinSize, joinedDataFrame);
            }
        }
        return joinedDataFrame;
    }
}

