/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join.impl;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinUtil;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import de.unknownreality.dataframe.join.impl.InnerJoin;
import de.unknownreality.dataframe.join.impl.LeftJoin;
import de.unknownreality.dataframe.join.impl.OuterJoin;
import de.unknownreality.dataframe.join.impl.RightJoin;

public class DefaultJoinUtil
implements JoinUtil {
    public static final String JOIN_SUFFIX_A = ".A";
    public static final String JOIN_SUFFIX_B = ".B";
    public static final RightJoin RIGHT = new RightJoin();
    public static final LeftJoin LEFT = new LeftJoin();
    public static final InnerJoin INNER = new InnerJoin();
    public static final OuterJoin OUTER = new OuterJoin();

    @Override
    public JoinedDataFrame leftJoin(DataFrame dfA, DataFrame dfB, JoinColumn ... joinColumns) {
        return this.leftJoin(dfA, dfB, JOIN_SUFFIX_A, JOIN_SUFFIX_B, joinColumns);
    }

    @Override
    public JoinedDataFrame leftJoin(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        return LEFT.join(dfA, dfB, joinSuffixA, joinSuffixB, joinColumns);
    }

    @Override
    public JoinedDataFrame rightJoin(DataFrame dfA, DataFrame dfB, JoinColumn ... joinColumns) {
        return this.rightJoin(dfA, dfB, JOIN_SUFFIX_A, JOIN_SUFFIX_B, joinColumns);
    }

    @Override
    public JoinedDataFrame rightJoin(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        return RIGHT.join(dfA, dfB, joinSuffixA, joinSuffixB, joinColumns);
    }

    @Override
    public JoinedDataFrame innerJoin(DataFrame dfA, DataFrame dfB, JoinColumn ... joinColumns) {
        return this.innerJoin(dfA, dfB, JOIN_SUFFIX_A, JOIN_SUFFIX_B, joinColumns);
    }

    @Override
    public JoinedDataFrame innerJoin(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        return INNER.join(dfA, dfB, joinSuffixA, joinSuffixB, joinColumns);
    }

    @Override
    public JoinedDataFrame outerJoin(DataFrame dfA, DataFrame dfB, JoinColumn ... joinColumns) {
        return this.outerJoin(dfA, dfB, JOIN_SUFFIX_A, JOIN_SUFFIX_B, joinColumns);
    }

    @Override
    public JoinedDataFrame outerJoin(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        return OUTER.join(dfA, dfB, joinSuffixA, joinSuffixB, joinColumns);
    }
}

