/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipUtil {
    private static final Logger log = LoggerFactory.getLogger(GZipUtil.class);

    public static boolean isGzipped(File file) {
        try {
            return GZipUtil.isGzipped(new FileInputStream(file));
        }
        catch (Exception e) {
            log.error("error opening file", (Throwable)e);
            return false;
        }
    }

    public static boolean isGzipped(InputStream is) {
        int m;
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        is.mark(2);
        try {
            m = is.read() & 0xFF | is.read() << 8 & 0xFF00;
            is.reset();
        }
        catch (IOException e) {
            return false;
        }
        return m == 35615;
    }
}

