/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.io;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DataFrameWriter;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.io.ReadFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public abstract class DataWriter {
    public void write(OutputStream os, DataContainer<?, ?> dataContainer) {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(os));
        this.write(bufferedWriter, dataContainer);
    }

    private BufferedWriter initWriter(Writer writer) throws IOException {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer);
    }

    public void write(Writer writer, DataContainer<?, ?> dataContainer) {
        try {
            this.write(this.initWriter(writer), dataContainer);
        }
        catch (IOException e) {
            throw new DataFrameRuntimeException("error creating buffered writer", e);
        }
    }

    public abstract void write(BufferedWriter var1, DataContainer<?, ?> var2);

    @Deprecated
    public void write(File file, DataFrame dataFrame, boolean writeMeta) {
        DataFrameWriter.write(file, dataFrame, this, writeMeta);
    }

    public void write(File file, DataContainer<?, ?> dataContainer) {
        if (file.getParentFile() != null && !file.getParentFile().isDirectory()) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            this.write(bufferedWriter, dataContainer);
        }
        catch (IOException e) {
            throw new DataFrameRuntimeException(String.format("error writing file '%s'", file.getAbsolutePath()), e);
        }
    }

    public abstract Map<String, String> getSettings(DataFrame var1);

    public abstract List<DataFrameColumn> getMetaColumns(DataFrame var1);

    public abstract ReadFormat getReadFormat();
}

