/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.io;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.io.DataIterator;
import de.unknownreality.dataframe.io.GZipUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public abstract class DataReader<R extends Row, C extends DataIterator<R>> {
    public C load(File file) {
        try {
            if (GZipUtil.isGzipped(file)) {
                GZIPInputStream is = new GZIPInputStream(new FileInputStream(file));
                return this.load(is);
            }
            return this.load(new FileReader(file));
        }
        catch (IOException e) {
            throw new DataFrameRuntimeException(String.format("error loading file '%s'", file.getAbsolutePath()), e);
        }
    }

    public C load(String content) {
        StringReader reader = new StringReader(content);
        return this.load(reader);
    }

    public C load(String resource, ClassLoader classLoader) {
        InputStream is = classLoader.getResourceAsStream(resource);
        return this.load(is);
    }

    public C load(URL url) {
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new DataFrameRuntimeException(String.format("error opening url stream '%s'", url.toString()), e);
        }
        return this.load(is);
    }

    public C load(byte[] bytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return this.load(is);
    }

    public C load(InputStream is) {
        InputStreamReader reader = new InputStreamReader(is);
        return this.load(reader);
    }

    public abstract C load(Reader var1);
}

