/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.index.interval;

import de.unknownreality.dataframe.common.NumberUtil;

public class Interval
implements Comparable<Interval> {
    public final Number low;
    public final Number high;

    public Interval(Number left, Number right) {
        this.low = left;
        this.high = right;
    }

    public Number getLow() {
        return this.low;
    }

    public Number getHigh() {
        return this.high;
    }

    public boolean contains(Number value) {
        return NumberUtil.ge(value, this.low) && NumberUtil.le(value, this.high);
    }

    public boolean intersects(Interval interval) {
        return NumberUtil.le(this.low, interval.high) && NumberUtil.ge(this.high, interval.low);
    }

    @Override
    public int compareTo(Interval interval) {
        int c = NumberUtil.compare(this.low, interval.getLow());
        if (c == 0) {
            return NumberUtil.compare(this.high, interval.getHigh());
        }
        return c;
    }

    public String toString() {
        return "[" + this.low + ", " + this.high + "]";
    }
}

