/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.index;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.index.Index;
import de.unknownreality.dataframe.index.TreeIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class Indices {
    public static final String PRIMARY_KEY_NAME = "%primary_key%";
    private final Map<String, Index> indexMap = new HashMap<String, Index>();
    private final Map<DataFrameColumn, List<Index>> columnIndexMap = new WeakHashMap<DataFrameColumn, List<Index>>();
    private final DataFrame dataFrame;

    public Indices(DataFrame dataFrame) {
        this.dataFrame = dataFrame;
    }

    public boolean isIndexColumn(DataFrameColumn column) {
        return this.columnIndexMap.containsKey(column);
    }

    public void replace(DataFrameColumn existing, DataFrameColumn replacement) {
        if (!this.isIndexColumn(existing)) {
            return;
        }
        List<Index> existingIndices = this.columnIndexMap.get(existing);
        for (Index idx : existingIndices) {
            idx.replaceColumn(existing, replacement);
            idx.clear();
        }
        this.columnIndexMap.remove(existing);
        this.columnIndexMap.put(replacement, existingIndices);
        for (DataRow row : this.dataFrame) {
            for (Index idx : existingIndices) {
                idx.update(row);
            }
        }
    }

    public void copyTo(DataFrame dataFrame) {
        for (Map.Entry<String, Index> entry : this.indexMap.entrySet()) {
            List<DataFrameColumn> indexColumns = entry.getValue().getColumns();
            DataFrameColumn[] dfColumns = new DataFrameColumn[indexColumns.size()];
            boolean invalid = false;
            for (int i = 0; i < indexColumns.size(); ++i) {
                DataFrameColumn dfCol = dataFrame.getColumn(indexColumns.get(i).getName());
                if (dfCol == null) {
                    invalid = true;
                    break;
                }
                dfColumns[i] = dfCol;
            }
            if (invalid) continue;
            dataFrame.addIndex(entry.getKey(), dfColumns);
        }
    }

    public void update(DataRow dataRow) {
        if (this.indicesCount() == 0) {
            return;
        }
        for (Index index : this.indexMap.values()) {
            index.update(dataRow);
        }
    }

    public void updateAllRows() {
        if (this.indicesCount() == 0) {
            return;
        }
        for (DataRow row : this.dataFrame) {
            this.update(row);
        }
    }

    public Collection<Integer> find(String name, Comparable ... values) {
        if (!this.indexMap.containsKey(name)) {
            throw new DataFrameRuntimeException(String.format("index not found'%s'", name));
        }
        return this.indexMap.get(name).find(values);
    }

    public Integer findFirst(String name, Comparable ... values) {
        Collection<Integer> rows = this.find(name, values);
        return rows.isEmpty() ? null : rows.iterator().next();
    }

    public Integer findByPrimaryKey(Comparable ... values) {
        Index primaryKey = this.indexMap.get(PRIMARY_KEY_NAME);
        if (primaryKey == null) {
            throw new DataFrameRuntimeException("no primaryKey found");
        }
        Collection<Integer> indices = primaryKey.find(values);
        if (indices.isEmpty()) {
            return null;
        }
        return indices.iterator().next();
    }

    public void addIndex(String name, DataFrameColumn ... columns) {
        this.addIndex(name, false, columns);
    }

    public void addIndex(String name, boolean unique, DataFrameColumn ... columns) {
        TreeIndex index = new TreeIndex(name, columns);
        index.setUnique(unique);
        this.addIndex(index);
    }

    public void addIndex(Index index) {
        if (this.indexMap.containsKey(index.getName())) {
            throw new DataFrameRuntimeException(String.format("error adding index: index name already exists'%s'", index.getName()));
        }
        this.indexMap.put(index.getName(), index);
        for (DataFrameColumn column : index.getColumns()) {
            List<Index> indexList = this.columnIndexMap.get(column);
            if (indexList == null) {
                indexList = new ArrayList<Index>();
                this.columnIndexMap.put(column, indexList);
            }
            indexList.add(index);
        }
        for (DataRow row : this.dataFrame) {
            index.update(row);
        }
    }

    public int indicesCount() {
        return this.indexMap.size();
    }

    public void setPrimaryKey(DataFrameColumn ... columns) {
        if (this.indexMap.containsKey(PRIMARY_KEY_NAME)) {
            this.removeIndex(PRIMARY_KEY_NAME);
        }
        this.addIndex(PRIMARY_KEY_NAME, true, columns);
    }

    public boolean containsIndex(String name) {
        return this.indexMap.containsKey(name);
    }

    public void clearValues() {
        for (Index index : this.indexMap.values()) {
            index.clear();
        }
    }

    public void updateValue(DataFrameColumn column, DataRow dataRow) {
        if (this.indicesCount() == 0) {
            return;
        }
        if (!this.isIndexColumn(column)) {
            return;
        }
        for (Index indexObject : this.columnIndexMap.get(column)) {
            indexObject.update(dataRow);
        }
    }

    public void updateColumn(DataFrameColumn column) {
        if (this.indicesCount() == 0) {
            return;
        }
        if (!this.isIndexColumn(column)) {
            return;
        }
        Collection columnIndices = this.columnIndexMap.get(column);
        for (Index indexObject : columnIndices) {
            indexObject.clear();
        }
        for (DataRow row : this.dataFrame) {
            for (Index indexObject : columnIndices) {
                indexObject.update(row);
            }
        }
    }

    public void remove(DataRow dataRow) {
        if (this.indicesCount() == 0) {
            return;
        }
        for (Index index : this.indexMap.values()) {
            index.remove(dataRow);
        }
    }

    public void removeIndex(String name) {
        Index index = this.indexMap.get(name);
        if (index == null) {
            return;
        }
        this.indexMap.remove(name);
        for (DataFrameColumn column : index.getColumns()) {
            List<Index> colIndices = this.columnIndexMap.get(column);
            colIndices.remove(index);
            if (!colIndices.isEmpty()) continue;
            this.columnIndexMap.remove(column);
        }
    }

    public void removeColumn(DataFrameColumn column) {
        if (this.indicesCount() == 0) {
            return;
        }
        if (!this.isIndexColumn(column)) {
            return;
        }
        ArrayList columnIndices = new ArrayList(this.columnIndexMap.get(column));
        for (Index index : columnIndices) {
            this.removeIndex(index.getName());
        }
        this.columnIndexMap.remove(column);
    }

    public void clear() {
        this.columnIndexMap.clear();
        this.indexMap.clear();
    }
}

