/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group.aggr;

import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.group.aggr.AggregateFunction;

public class Aggregate {
    public static final AggregateFunction<Integer> count = group -> group.size();

    public static AggregateFunction<Integer> count() {
        return count;
    }

    public static AggregateFunction<Double> mean(String colName) {
        return group -> group.getNumberColumn(colName).mean();
    }

    public static AggregateFunction<Comparable> median(String colName) {
        return group -> (Comparable)group.getNumberColumn(colName).median();
    }

    public static AggregateFunction<Comparable> min(String colName) {
        return group -> (Comparable)group.getNumberColumn(colName).min();
    }

    public static AggregateFunction<Comparable> max(String colName) {
        return group -> (Comparable)group.getNumberColumn(colName).max();
    }

    public static AggregateFunction<Integer> filterCount(FilterPredicate filterPredicate) {
        return group -> group.selectRows(filterPredicate).size();
    }

    public static AggregateFunction<Integer> filterCount(String predicateString) {
        return group -> group.selectRows(predicateString).size();
    }

    public static AggregateFunction<Comparable> first(String colName) {
        return group -> (Comparable)group.getRow(0).get(colName);
    }

    public static AggregateFunction<Comparable> last(String colName) {
        return group -> (Comparable)group.getRow(group.size() - 1).get(colName);
    }

    public static AggregateFunction<Comparable> quantile(String colName, double quantile) {
        return group -> (Comparable)group.getNumberColumn(colName).getQuantile(quantile);
    }

    public static AggregateFunction<Integer> naCount(String column) {
        return group -> {
            int c = 0;
            for (int i = 0; i < group.size(); ++i) {
                if (!group.getRow(i).isNA(column)) continue;
                ++c;
            }
            return c;
        };
    }
}

