/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.group.GroupHeader;

public class GroupValues
implements Row<Comparable, String> {
    private final Comparable[] values;
    private final GroupHeader groupHeader;

    public GroupValues(Comparable[] groupValues, GroupHeader header) {
        this.values = groupValues;
        this.groupHeader = header;
    }

    public Comparable[] getValues() {
        return this.values;
    }

    @Override
    public Comparable get(String headerName) {
        int index = this.groupHeader.getIndex(headerName);
        if (index == -1) {
            throw new DataFrameRuntimeException(String.format("group header name not found '%s'", headerName));
        }
        return this.get(index);
    }

    @Override
    public Comparable get(int index) {
        return this.values[index];
    }

    @Override
    public Double getDouble(int index) {
        Comparable value = this.get(index);
        try {
            return ((Number)Number.class.cast(this.get(index))).doubleValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no double value in group col " + index + " (" + value + ")");
        }
    }

    @Override
    public String getString(int index) {
        Comparable value = this.get(index);
        if (value != null) {
            return value.toString();
        }
        throw new DataFrameRuntimeException("no String value in group col " + index + " (null)");
    }

    @Override
    public Boolean getBoolean(int index) {
        Comparable value = this.get(index);
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        throw new DataFrameRuntimeException("no boolean value in group col " + index + " (" + value + ")");
    }

    @Override
    public Double getDouble(String name) {
        Comparable value = this.get(name);
        try {
            return ((Number)Number.class.cast(this.get(name))).doubleValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no double value in group col " + name + " (" + value + ")");
        }
    }

    @Override
    public String getString(String name) {
        return this.getString(this.groupHeader.getIndex(name));
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.getBoolean(this.groupHeader.getIndex(name));
    }

    @Override
    public Integer getInteger(int index) {
        Comparable value = this.get(index);
        try {
            return ((Number)Number.class.cast(this.get(index))).intValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no int value in group col " + index + " (" + value + ")");
        }
    }

    @Override
    public Integer getInteger(String headerName) {
        Comparable value = this.get(headerName);
        try {
            return ((Number)Number.class.cast(value)).intValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no int value in group col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public Float getFloat(int index) {
        Comparable value = this.get(index);
        try {
            return Float.valueOf(((Number)Number.class.cast(value)).floatValue());
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no float value in group col " + index + " (" + value + ")");
        }
    }

    @Override
    public Float getFloat(String headerName) {
        Comparable value = this.get(headerName);
        try {
            return Float.valueOf(((Number)Number.class.cast(value)).floatValue());
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no float value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public <T> T get(String headerName, Class<T> cl) {
        Comparable value = this.get(headerName);
        try {
            return cl.cast(value);
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no " + cl.getName() + " value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public <T> T getOrNull(String headerName, Class<T> cl) {
        Comparable value = this.get(headerName);
        try {
            return cl.cast(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> T get(int index, Class<T> cl) {
        Comparable value = this.get(index);
        try {
            return cl.cast(value);
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no " + cl.getName() + " value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public <T> T getOrNull(int index, Class<T> cl) {
        Comparable value = this.get(index);
        try {
            return cl.cast(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Long getLong(int index) {
        Comparable value = this.get(index);
        try {
            return ((Number)Number.class.cast(value)).longValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no long value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public Long getLong(String headerName) {
        Comparable value = this.get(headerName);
        try {
            return ((Number)Number.class.cast(value)).longValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no long value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public Short getShort(int index) {
        Comparable value = this.get(index);
        try {
            return ((Number)Number.class.cast(value)).shortValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no short value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public Short getShort(String headerName) {
        Comparable value = this.get(headerName);
        try {
            return ((Number)Number.class.cast(value)).shortValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no short value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public Byte getByte(int index) {
        Comparable value = this.get(index);
        try {
            return ((Number)Number.class.cast(value)).byteValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no byte value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public Byte getByte(String headerName) {
        Comparable value = this.get(headerName);
        try {
            return ((Number)Number.class.cast(value)).byteValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no byte value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

