/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter.compile;

import java.util.HashMap;
import java.util.Map;

public enum FieldFilterOperation {
    EQ("EQ", "eq", "=", "=="),
    NE("NE", "ne", "!="),
    LE("LE", "le", "<="),
    LT("LT", "lt", "<"),
    GE("GE", "ge", ">="),
    GT("GT", "Gt", ">"),
    LIKE("LIKE");

    private String[] aliases;
    private static final Map<String, FieldFilterOperation> ALIASES_MAP;

    private FieldFilterOperation(String ... aliases) {
        this.aliases = aliases;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static FieldFilterOperation find(String alias) {
        return ALIASES_MAP.get(alias);
    }

    static {
        ALIASES_MAP = new HashMap<String, FieldFilterOperation>();
        for (FieldFilterOperation fieldOperation : FieldFilterOperation.values()) {
            for (String alias : fieldOperation.aliases) {
                ALIASES_MAP.put(alias, fieldOperation);
            }
        }
    }
}

