/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter.compile;

import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.filter.compile.FieldFilterOperation;
import de.unknownreality.dataframe.filter.compile.FieldFilterVisitor;
import de.unknownreality.dataframe.filter.compile.PredicateCompilerException;
import de.unknownreality.dataframe.generated.PredicateBaseVisitor;
import de.unknownreality.dataframe.generated.PredicateParser;

public class ColumnPredicateFilterVisitor
extends PredicateBaseVisitor<FilterPredicate> {
    @Override
    public FilterPredicate visitColumn_predicate(PredicateParser.Column_predicateContext ctx) {
        String colNameA = FieldFilterVisitor.getColname(ctx.COLUMN(0).getText());
        String colNameB = FieldFilterVisitor.getColname(ctx.COLUMN(1).getText());
        return ColumnPredicateFilterVisitor.createColumnFieldFilter(colNameA, colNameB, ctx.FIELD_OPERATION().getText());
    }

    private static FilterPredicate createColumnFieldFilter(String colNameA, String colNameB, String operation) {
        FieldFilterOperation fieldFilterOperation = FieldFilterOperation.find(operation);
        switch (fieldFilterOperation) {
            case EQ: {
                return FilterPredicate.eqColumn(colNameA, colNameB);
            }
            case NE: {
                return FilterPredicate.neColumn(colNameA, colNameB);
            }
            case LE: {
                return FilterPredicate.leColumn(colNameA, colNameB);
            }
            case LT: {
                return FilterPredicate.ltColumn(colNameA, colNameB);
            }
            case GE: {
                return FilterPredicate.geColumn(colNameA, colNameB);
            }
            case GT: {
                return FilterPredicate.gtColumn(colNameA, colNameB);
            }
        }
        throw new PredicateCompilerException(String.format("unsupported filter operation '%s'", operation));
    }
}

