/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter;

import de.unknownreality.dataframe.common.KeyValueGetter;
import de.unknownreality.dataframe.filter.ColumnComparePredicate;
import de.unknownreality.dataframe.filter.ComparePredicate;
import de.unknownreality.dataframe.filter.LikePredicate;
import de.unknownreality.dataframe.filter.MatchPredicate;
import de.unknownreality.dataframe.filter.compile.PredicateCompiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class FilterPredicate {
    public static final FilterPredicate EMPTY_FILTER = FilterPredicate.empty();

    public abstract boolean valid(KeyValueGetter<String, ?> var1);

    public abstract String toString();

    public static FilterPredicate empty() {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                return true;
            }

            @Override
            public String toString() {
                return "";
            }
        };
    }

    public FilterPredicate and(FilterPredicate p) {
        return FilterPredicate.and(this, p);
    }

    public FilterPredicate or(FilterPredicate p) {
        return FilterPredicate.or(this, p);
    }

    public FilterPredicate xor(FilterPredicate p) {
        return FilterPredicate.xor(this, p);
    }

    public FilterPredicate nor(FilterPredicate p) {
        return FilterPredicate.nor(this, p);
    }

    public FilterPredicate neg() {
        return FilterPredicate.not(this);
    }

    public static FilterPredicate not(final FilterPredicate filterPredicate) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                return !filterPredicate.valid(kv);
            }

            @Override
            public String toString() {
                return "!(" + filterPredicate.toString() + ")";
            }
        };
    }

    public static FilterPredicate ne(final FilterPredicate p1, final FilterPredicate p2) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> value) {
                return p1.valid(value) != p2.valid(value);
            }

            @Override
            public String toString() {
                return "(" + p1.toString() + ") != (" + p2.toString() + ")";
            }
        };
    }

    public static FilterPredicate eq(final FilterPredicate p1, final FilterPredicate p2) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                return p1.valid(kv) == p2.valid(kv);
            }

            @Override
            public String toString() {
                return "(" + p1.toString() + ") == (" + p2.toString() + ")";
            }
        };
    }

    public static FilterPredicate and(final FilterPredicate ... predicates) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                for (FilterPredicate predicate : predicates) {
                    if (predicate.valid(kv)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < predicates.length; ++i) {
                    sb.append("(").append(predicates[i]).append(")");
                    if (i >= predicates.length - 1) continue;
                    sb.append(" AND ");
                }
                return sb.toString();
            }
        };
    }

    public static FilterPredicate or(final FilterPredicate ... predicates) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                for (FilterPredicate predicate : predicates) {
                    if (!predicate.valid(kv)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < predicates.length; ++i) {
                    sb.append("(").append(predicates[i]).append(")");
                    if (i >= predicates.length - 1) continue;
                    sb.append(" OR ");
                }
                return sb.toString();
            }
        };
    }

    public static FilterPredicate and(final FilterPredicate p1, final FilterPredicate p2) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                return p1.valid(kv) && p2.valid(kv);
            }

            @Override
            public String toString() {
                return "(" + p1.toString() + ") AND (" + p2.toString() + ")";
            }
        };
    }

    public static FilterPredicate or(final FilterPredicate p1, final FilterPredicate p2) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                return p1.valid(kv) || p2.valid(kv);
            }

            @Override
            public String toString() {
                return "(" + p1.toString() + ") OR (" + p2.toString() + ")";
            }
        };
    }

    public static FilterPredicate xor(final FilterPredicate p1, final FilterPredicate p2) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                boolean p1v = p1.valid(kv);
                boolean p2v = p2.valid(kv);
                return p1v && !p2v || p2v && !p1v;
            }

            @Override
            public String toString() {
                return "(" + p1.toString() + ") XOR (" + p2.toString() + ")";
            }
        };
    }

    public static FilterPredicate nor(final FilterPredicate p1, final FilterPredicate p2) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                boolean p1v = p1.valid(kv);
                boolean p2v = p2.valid(kv);
                return !p1v && !p2v;
            }

            @Override
            public String toString() {
                return "(" + p1.toString() + ") NOR (" + p2.toString() + ")";
            }
        };
    }

    public static FilterPredicate ne(String name, Object value) {
        return new ComparePredicate(name, ComparePredicate.Operation.NE, value);
    }

    public static FilterPredicate neColumn(String nameA, String nameB) {
        return new ColumnComparePredicate(nameA, ComparePredicate.Operation.NE, nameB);
    }

    public static FilterPredicate eq(String name, Object value) {
        return new ComparePredicate(name, ComparePredicate.Operation.EQ, value);
    }

    public static FilterPredicate eqColumn(String nameA, String nameB) {
        return new ColumnComparePredicate(nameA, ComparePredicate.Operation.EQ, nameB);
    }

    public static FilterPredicate gt(String name, Object value) {
        return new ComparePredicate(name, ComparePredicate.Operation.GT, value);
    }

    public static FilterPredicate gtColumn(String nameA, String nameB) {
        return new ColumnComparePredicate(nameA, ComparePredicate.Operation.GT, nameB);
    }

    public static FilterPredicate lt(String name, Object value) {
        return new ComparePredicate(name, ComparePredicate.Operation.LT, value);
    }

    public static FilterPredicate ltColumn(String nameA, String nameB) {
        return new ColumnComparePredicate(nameA, ComparePredicate.Operation.LT, nameB);
    }

    public static FilterPredicate ge(String name, Object value) {
        return new ComparePredicate(name, ComparePredicate.Operation.GE, value);
    }

    public static FilterPredicate geColumn(String nameA, String nameB) {
        return new ColumnComparePredicate(nameA, ComparePredicate.Operation.GE, nameB);
    }

    public static FilterPredicate le(String name, Object value) {
        return new ComparePredicate(name, ComparePredicate.Operation.LE, value);
    }

    public static FilterPredicate leColumn(String nameA, String nameB) {
        return new ColumnComparePredicate(nameA, ComparePredicate.Operation.LE, nameB);
    }

    public static FilterPredicate in(String name, Object[] values) {
        ArrayList test = new ArrayList();
        Collections.sort(test, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return FilterPredicate.in(name, Arrays.asList(values));
    }

    public static FilterPredicate in(String name, Collection<Object> values) {
        return FilterPredicate.in(name, new HashSet<Object>(values));
    }

    public static FilterPredicate in(final String name, final Set<Object> values) {
        return new FilterPredicate(){

            @Override
            public boolean valid(KeyValueGetter<String, ?> kv) {
                return values.contains(kv.get(name));
            }

            @Override
            public String toString() {
                return name + " in " + values.toString();
            }
        };
    }

    public static FilterPredicate btwn(String name, Object low, Object high) {
        return FilterPredicate.and(FilterPredicate.gt(name, low), FilterPredicate.lt(name, high));
    }

    public static FilterPredicate like(String name, Object query) {
        return new LikePredicate(name, query != null ? query.toString() : null);
    }

    public static FilterPredicate like(String name, String query) {
        return new LikePredicate(name, query);
    }

    public static FilterPredicate matches(String name, Pattern pattern) {
        return new MatchPredicate(name, pattern);
    }

    public static FilterPredicate matches(String name, String patternString) {
        return new MatchPredicate(name, patternString);
    }

    public static FilterPredicate compile(String predicateString) {
        return PredicateCompiler.compile(predicateString);
    }
}

