/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.KeyValueGetter;
import de.unknownreality.dataframe.common.NumberUtil;
import de.unknownreality.dataframe.filter.FilterPredicate;

public class ComparePredicate
extends FilterPredicate {
    private final String headerName;
    private final Object value;
    private final Operation operation;

    public ComparePredicate(String headerName, Operation op, Object value) {
        this.headerName = headerName;
        this.operation = op;
        this.value = value;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean valid(KeyValueGetter<String, ?> kv) {
        return this.compare(kv.get(this.headerName), this.value);
    }

    protected boolean compare(Object valueA, Object valueB) {
        boolean numberCompare;
        if (this.operation == Operation.EQ && valueA.equals(valueB)) {
            return true;
        }
        if (valueA instanceof String && valueB instanceof Number) {
            Number n = NumberUtil.parseNumberOrNull(valueA.toString());
            if (n != null) {
                valueA = n;
            } else {
                valueB = NumberUtil.toString((Number)valueB);
            }
        }
        boolean bl = numberCompare = valueA instanceof Number && valueB instanceof Number;
        if (!valueA.getClass().equals(valueB.getClass()) && !numberCompare) {
            return this.operation == Operation.NE;
        }
        int c = 0;
        if (numberCompare) {
            c = NumberUtil.compare((Number)valueA, (Number)valueB);
        } else if (valueA instanceof Comparable && valueB instanceof Comparable) {
            c = ((Comparable)valueA).compareTo(valueB);
        }
        return this.isValid(this.operation, c);
    }

    protected boolean isValid(Operation operation, int c) {
        switch (operation) {
            case GT: {
                return c > 0;
            }
            case GE: {
                return c >= 0;
            }
            case LT: {
                return c < 0;
            }
            case LE: {
                return c <= 0;
            }
            case EQ: {
                return c == 0;
            }
            case NE: {
                return c != 0;
            }
        }
        throw new DataFrameRuntimeException(String.format("unknown operation: %s", operation.str));
    }

    @Override
    public String toString() {
        return this.headerName + " " + (Object)((Object)this.operation) + " " + this.value;
    }

    public static enum Operation {
        GT(">"),
        GE(">="),
        LT("<"),
        LE("<="),
        EQ("=="),
        NE("!=");

        private final String str;

        private Operation(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

