/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.common.parser.ParserUtil;
import de.unknownreality.dataframe.csv.CSVIterator;
import de.unknownreality.dataframe.csv.CSVReader;
import de.unknownreality.dataframe.csv.CSVRow;
import de.unknownreality.dataframe.csv.CSVSettings;
import de.unknownreality.dataframe.csv.ColumnSettings;
import de.unknownreality.dataframe.io.ReaderBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSVReaderBuilder
implements ReaderBuilder<CSVRow, CSVReader> {
    private char separator = (char)59;
    private String headerPrefix = "";
    private boolean containsHeader = true;
    private boolean quoteDetection = true;
    private boolean singleQuoteDetection = true;
    private List<String> ignoreColumns = new ArrayList<String>();
    private List<String> selectColumns = new ArrayList<String>();
    private List<String> skipPrefixes = new ArrayList<String>();
    private Map<String, Class<? extends Comparable>> columnTypeMap = new HashMap<String, Class<? extends Comparable>>();

    public static CSVReaderBuilder create() {
        return new CSVReaderBuilder();
    }

    public CSVReaderBuilder withSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public CSVReaderBuilder withQuoteDetection(boolean quoteDetection) {
        this.quoteDetection = quoteDetection;
        return this;
    }

    public CSVReaderBuilder withSingleQuoteDetection(boolean singleQuoteDetection) {
        this.singleQuoteDetection = singleQuoteDetection;
        return this;
    }

    public CSVReaderBuilder addSkipPrefix(String prefix) {
        this.skipPrefixes.add(prefix);
        return this;
    }

    public CSVReaderBuilder withHeaderPrefix(String headerPrefix) {
        this.headerPrefix = headerPrefix;
        return this;
    }

    public CSVReaderBuilder ignoreColumns(String ... cols) {
        for (String col : cols) {
            this.ignoreColumn(col);
        }
        return this;
    }

    public CSVReaderBuilder ignoreColumn(String col) {
        this.ignoreColumns.add(col);
        return this;
    }

    public CSVReaderBuilder selectColumns(String ... cols) {
        for (String col : cols) {
            this.selectColumn(col);
        }
        return this;
    }

    public CSVReaderBuilder selectColumn(String col) {
        this.selectColumns.add(col);
        return this;
    }

    public <T extends Comparable<T>> CSVReaderBuilder setColumnType(String col, Class<T> type) {
        this.columnTypeMap.put(col, type);
        return this;
    }

    public CSVReaderBuilder withHeader(boolean header) {
        this.containsHeader = header;
        return this;
    }

    public CSVReaderBuilder containsHeader(boolean header) {
        this.containsHeader = header;
        return this;
    }

    @Deprecated
    public CSVIterator load(File file) {
        return (CSVIterator)this.build().load(file);
    }

    @Deprecated
    public CSVIterator load(String content) {
        return (CSVIterator)this.build().load(content);
    }

    @Deprecated
    public CSVIterator loadResource(String resourcePath, ClassLoader classLoader) {
        return (CSVIterator)this.build().load(resourcePath, classLoader);
    }

    @Deprecated
    public CSVIterator loadResource(String resourcePath) {
        return (CSVIterator)this.build().load(resourcePath, CSVReaderBuilder.class.getClassLoader());
    }

    @Override
    public CSVReader build() {
        CSVSettings settings = new CSVSettings();
        settings.setContainsHeader(this.containsHeader);
        settings.setHeaderPrefix(this.headerPrefix);
        settings.setSeparator(this.separator);
        settings.setSkipPrefixes(this.skipPrefixes);
        settings.setQuoteDetection(this.quoteDetection);
        settings.setSingleQuoteDetection(this.singleQuoteDetection);
        ColumnSettings columnSettings = new ColumnSettings();
        columnSettings.getColumnTypeMap().putAll(this.columnTypeMap);
        columnSettings.getIgnoreColumns().addAll(this.ignoreColumns);
        columnSettings.getSelectColumns().addAll(this.selectColumns);
        return new CSVReader(settings, columnSettings);
    }

    @Override
    public ReaderBuilder<CSVRow, CSVReader> loadSettings(Map<String, String> attributes) throws Exception {
        this.separator = ParserUtil.parse(Character.class, attributes.get("separator")).charValue();
        this.headerPrefix = attributes.get("headerPrefix");
        this.containsHeader = ParserUtil.parse(Boolean.class, attributes.get("containsHeader"));
        return this;
    }
}

