/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.DataFrameBuilder;
import de.unknownreality.dataframe.common.StringSplitter;
import de.unknownreality.dataframe.csv.CSVException;
import de.unknownreality.dataframe.csv.CSVHeader;
import de.unknownreality.dataframe.csv.CSVRow;
import de.unknownreality.dataframe.csv.CSVRuntimeException;
import de.unknownreality.dataframe.csv.CSVSettings;
import de.unknownreality.dataframe.csv.ColumnSettings;
import de.unknownreality.dataframe.io.BufferedStreamIterator;
import de.unknownreality.dataframe.io.ColumnInformation;
import de.unknownreality.dataframe.io.DataIterator;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVIterator
extends BufferedStreamIterator<CSVRow>
implements DataIterator<CSVRow> {
    private static final Logger log = LoggerFactory.getLogger(CSVIterator.class);
    private int lineNumber = 0;
    private CSVSettings csvSettings;
    private ColumnSettings columnSettings;
    private CSVHeader header = new CSVHeader();
    private int cols = -1;
    private Set<String> ignoredColumns;
    private Set<String> includedColumns;
    Map<String, Class<? extends Comparable>> colTypes;
    Map<String, Integer> selectedColumnsIndex = new HashMap<String, Integer>();
    private List<ColumnInformation> columnInformations = new ArrayList<ColumnInformation>();
    private CSVRow bufferedRow = null;
    private boolean[] skipIndices;
    private StringSplitter stringSplitter = new StringSplitter();

    public CSVIterator(BufferedReader reader, CSVSettings csvSettings, ColumnSettings columnSettings) {
        super(reader);
        this.csvSettings = csvSettings;
        this.columnSettings = columnSettings;
        this.ignoredColumns = new HashSet<String>(columnSettings.getIgnoreColumns());
        this.includedColumns = new HashSet<String>(columnSettings.getSelectColumns());
        this.colTypes = new HashMap<String, Class<? extends Comparable>>(columnSettings.getColumnTypeMap());
        this.stringSplitter.setDetectQuotes(csvSettings.isQuoteDetection());
        this.stringSplitter.setDetectSingleQuotes(csvSettings.isSingleQuoteDetection());
        int j = 0;
        for (String col : columnSettings.getSelectColumns()) {
            this.selectedColumnsIndex.put(col, j++);
        }
        this.initHeader();
    }

    @Deprecated
    public DataFrameBuilder toDataFrame() {
        return DataFrameBuilder.createFrom(this);
    }

    public void initHeader() {
        try {
            CSVRow row = this.getNext();
            this.skipIndices = new boolean[row.size()];
            int skipIndex = 0;
            if (this.csvSettings.isContainsHeader()) {
                if (!row.get(0).startsWith(this.csvSettings.getHeaderPrefix())) {
                    throw new CSVException("invalid header prefix in first line");
                }
                String name = row.get(0);
                String string = name = this.csvSettings.getHeaderPrefix() == null ? name : name.substring(this.csvSettings.getHeaderPrefix().length());
                if (this.includeColumn(name)) {
                    this.header.add(name);
                    this.skipIndices[skipIndex++] = false;
                } else {
                    this.header.incrementEmptyColumnIndex();
                    this.skipIndices[skipIndex++] = true;
                }
                for (int i = 1; i < row.size(); ++i) {
                    name = row.get(i);
                    if (!this.includeColumn(name)) {
                        this.skipIndices[skipIndex++] = true;
                        continue;
                    }
                    this.skipIndices[skipIndex++] = false;
                    this.header.add(name);
                }
            } else {
                for (int i = 0; i < row.size(); ++i) {
                    if (!this.includeColumn(this.header.getNextEmptyColumnName())) {
                        this.header.incrementEmptyColumnIndex();
                        this.skipIndices[skipIndex++] = true;
                        continue;
                    }
                    this.skipIndices[skipIndex++] = false;
                    this.header.add();
                }
                this.bufferedRow = row;
            }
            for (int i = 0; i < this.header.size(); ++i) {
                String name = this.header.get(i);
                Class<? extends Comparable> type = this.colTypes.get(name);
                ColumnInformation columnInformation = type != null ? new ColumnInformation(i, name, type) : new ColumnInformation(i, name, true);
                this.columnInformations.add(columnInformation);
            }
        }
        catch (Exception e) {
            throw new CSVRuntimeException("error creating csv header", e);
        }
        this.loadNext();
    }

    private boolean includeColumn(String col) {
        if (this.includedColumns.isEmpty()) {
            return !this.ignoredColumns.contains(col);
        }
        return this.includedColumns.contains(col);
    }

    @Override
    public CSVRow next() {
        if (this.bufferedRow != null) {
            CSVRow nextRow = this.bufferedRow;
            this.bufferedRow = null;
            return nextRow;
        }
        return (CSVRow)super.next();
    }

    @Override
    protected CSVRow getNext() {
        try {
            ++this.lineNumber;
            String line = this.getLine();
            while (line != null && "".equals(line.trim())) {
                line = this.getLine();
            }
            if (line == null) {
                return null;
            }
            for (String prefix : this.csvSettings.getSkipPrefixes()) {
                if (prefix == null || "".equals(prefix) || !line.startsWith(prefix)) continue;
                return this.getNext();
            }
            String[] values = this.stringSplitter.splitQuoted(line, Character.valueOf(this.csvSettings.getSeparator()));
            if (this.cols == -1) {
                this.cols = values.length;
            } else if (values.length != this.cols) {
                throw new CSVException(String.format("unequal number of column %d != %d in line %d", values.length, this.cols, this.lineNumber));
            }
            if (this.skipIndices != null && this.header.size() != values.length) {
                String[] filteredValues = new String[this.header.size()];
                int j = 0;
                for (int i = 0; i < values.length; ++i) {
                    if (this.skipIndices[i]) continue;
                    filteredValues[j++] = values[i];
                }
                values = filteredValues;
            }
            return new CSVRow(this.header, values, this.lineNumber);
        }
        catch (Exception e) {
            log.error("error reading file: {}:{}", (Object)this.lineNumber, (Object)e);
            this.close();
            throw new CSVRuntimeException(String.format("error reading csv row: %d", this.lineNumber), e);
        }
    }

    @Override
    public List<ColumnInformation> getColumnsInformation() {
        return this.columnInformations;
    }

    @Override
    public Iterator<CSVRow> iterator() {
        return this;
    }
}

