/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.parser;

import de.unknownreality.dataframe.common.parser.Parser;
import de.unknownreality.dataframe.common.parser.ParserNotFoundException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ParserUtil {
    private static final Map<Class<?>, Parser<?>> parserMap = new ConcurrentHashMap();

    private static Map<Class<?>, Parser<?>> getParserMap() {
        return parserMap;
    }

    private static void init() {
        parserMap.put(String.class, new Parser<String>(){

            @Override
            public String parse(String s) {
                return s;
            }
        });
        parserMap.put(Double.class, new Parser<Double>(){

            @Override
            public Double parse(String s) {
                return Double.parseDouble(s);
            }
        });
        parserMap.put(Integer.class, new Parser<Integer>(){

            @Override
            public Integer parse(String s) {
                return Integer.parseInt(s);
            }
        });
        parserMap.put(Float.class, new Parser<Float>(){

            @Override
            public Float parse(String s) {
                return Float.valueOf(Float.parseFloat(s));
            }
        });
        parserMap.put(Long.class, new Parser<Long>(){

            @Override
            public Long parse(String s) {
                return Long.parseLong(s);
            }
        });
        parserMap.put(Boolean.class, new Parser<Boolean>(){

            @Override
            public Boolean parse(String s) throws ParseException {
                if (s == null || !"false".equals(s = s.toLowerCase()) && !"true".equals(s) && !"f".equals(s) && !"t".equals(s)) {
                    throw new ParseException(String.format("illegal boolean value: %s", s), 0);
                }
                if (s.equals("f")) {
                    return false;
                }
                switch (s) {
                    case "f": {
                        return false;
                    }
                    case "t": {
                        return true;
                    }
                }
                return Boolean.parseBoolean(s);
            }
        });
        parserMap.put(Short.class, new Parser<Short>(){

            @Override
            public Short parse(String s) {
                return Short.parseShort(s);
            }
        });
        parserMap.put(Character.class, new Parser<Character>(){

            @Override
            public Character parse(String s) {
                return Character.valueOf(s.charAt(0));
            }
        });
        parserMap.put(Byte.class, new Parser<Byte>(){

            @Override
            public Byte parse(String s) {
                return Byte.parseByte(s);
            }
        });
    }

    private static <T> T parseArray(Class<T> cl, String x) throws ParseException {
        Parser<?> p = ParserUtil.getParserMap().get(cl.getComponentType());
        Class<?> cc = cl.getComponentType();
        String[] vals = x.split("[;,|]");
        Object r = Array.newInstance(cc, vals.length);
        for (int i = 0; i < vals.length; ++i) {
            Array.set(r, i, p.parse(vals[i]));
        }
        return cl.cast(r);
    }

    public static <T> T parse(Class<T> cl, String x) throws ParseException, ParserNotFoundException {
        if (cl.isArray() && !ParserUtil.getParserMap().containsKey(cl.getComponentType()) && !ParserUtil.getParserMap().containsKey(cl)) {
            throw new ParserNotFoundException(cl);
        }
        try {
            if (cl.isArray()) {
                return ParserUtil.parseArray(cl, x);
            }
            Parser<T> p = ParserUtil.getParser(cl);
            return p.parse(x);
        }
        catch (Exception e) {
            throw new ParseException("error parsing '" + x + "' to " + cl.getName(), 0);
        }
    }

    public static boolean hasParser(Class<?> cl) {
        return ParserUtil.getParserMap().get(cl) != null;
    }

    public static <T> Parser<T> getParser(Class<T> cl) throws ParserNotFoundException {
        Parser<?> parser = ParserUtil.getParserMap().get(cl);
        if (parser == null) {
            throw new ParserNotFoundException(cl);
        }
        return parser;
    }

    public static <T> Parser<T> findParserOrNull(Class<T> cl) {
        try {
            return ParserUtil.getParser(cl);
        }
        catch (ParserNotFoundException parserNotFoundException) {
            return null;
        }
    }

    public static <T> T parseOrNull(Class<T> cl, String x) {
        if (cl.isArray() && !ParserUtil.getParserMap().containsKey(cl.getComponentType()) && !ParserUtil.getParserMap().containsKey(cl)) {
            return null;
        }
        try {
            if (cl.isArray()) {
                return ParserUtil.parseArray(cl, x);
            }
            Parser<T> p = ParserUtil.getParser(cl);
            return p.parse(x);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> void addParser(Class<T> c, Parser<T> p) {
        ParserUtil.getParserMap().put(c, p);
    }

    static {
        ParserUtil.init();
    }
}

