/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common;

import java.util.ArrayList;
import java.util.List;

public class StringSplitter {
    private boolean detectSingleQuotes = true;
    private boolean detectQuotes = true;

    public static StringSplitter create() {
        return new StringSplitter();
    }

    public StringSplitter setDetectQuotes(boolean detectQuotes) {
        this.detectQuotes = detectQuotes;
        return this;
    }

    public StringSplitter setDetectSingleQuotes(boolean detectSingleQuotes) {
        this.detectSingleQuotes = detectSingleQuotes;
        return this;
    }

    public boolean isDetectQuotes() {
        return this.detectQuotes;
    }

    public boolean isDetectSingleQuotes() {
        return this.detectSingleQuotes;
    }

    public String[] splitQuoted(String input, Character split) {
        ArrayList<String> parts = new ArrayList<String>();
        this.splitQuoted(input, split, new ListParts(parts));
        String[] result = new String[parts.size()];
        return parts.toArray(result);
    }

    public void splitQuoted(String input, Character split, String[] parts) {
        this.splitQuoted(input, split, new ArrayParts(parts));
    }

    public void splitQuoted(String input, Character split, Parts parts) {
        if (input.length() == 0) {
            return;
        }
        boolean inQuotation = false;
        boolean inDoubleQuotation = false;
        boolean escapeNext = false;
        boolean startOrSplit = true;
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escapeNext) {
                sb.append(c);
                escapeNext = false;
                continue;
            }
            if (c == '\\') {
                escapeNext = true;
                continue;
            }
            if (this.detectSingleQuotes && c == '\'') {
                if (inQuotation) {
                    inQuotation = false;
                    continue;
                }
                if (!inDoubleQuotation && startOrSplit) {
                    inQuotation = true;
                    startOrSplit = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (this.detectQuotes && c == '\"') {
                if (inDoubleQuotation) {
                    inDoubleQuotation = false;
                    continue;
                }
                if (!inDoubleQuotation && startOrSplit) {
                    inDoubleQuotation = true;
                    startOrSplit = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == split.charValue() && !inDoubleQuotation && !inQuotation) {
                parts.add(sb.toString());
                sb.setLength(0);
                startOrSplit = true;
                continue;
            }
            startOrSplit = false;
            sb.append(c);
        }
        parts.add(sb.toString());
    }

    private static class ArrayParts
    implements Parts {
        private String[] array;
        private int p = 0;

        public ArrayParts(String[] array) {
            this.array = array;
        }

        @Override
        public void add(String part) {
            this.array[this.p++] = part;
        }
    }

    private static class ListParts
    implements Parts {
        private List<String> list;

        public ListParts(List<String> list) {
            this.list = list;
        }

        @Override
        public void add(String part) {
            this.list.add(part);
        }
    }

    private static interface Parts {
        public void add(String var1);
    }
}

