/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.column;

import de.unknownreality.dataframe.column.BasicColumn;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.parser.Parser;
import de.unknownreality.dataframe.common.parser.ParserUtil;

public class StringColumn
extends BasicColumn<String, StringColumn> {
    private final Parser<String> parser = ParserUtil.findParserOrNull(String.class);

    public StringColumn() {
    }

    public StringColumn(String name) {
        super(name);
    }

    public StringColumn(String name, String[] values) {
        super(name, (Comparable[])values);
    }

    public StringColumn(String name, String[] values, int size) {
        super(name, (Comparable[])values, size);
    }

    @Override
    public Parser<String> getParser() {
        return this.parser;
    }

    @Override
    protected StringColumn getThis() {
        return this;
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public StringColumn copy() {
        String[] copyValues = new String[((String[])this.values).length];
        this.toArray((Comparable[])copyValues);
        return new StringColumn(this.getName(), copyValues, this.size());
    }

    @Override
    public <H> String getValueFromRow(Row<?, H> row, H headerName) {
        return row.getString(headerName);
    }

    @Override
    public String getValueFromRow(Row<?, ?> row, int headerIndex) {
        return row.getString(headerIndex);
    }

    @Override
    public StringColumn copyEmpty() {
        return new StringColumn(this.getName());
    }
}

