/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.column;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.MapFunction;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.ValueComparator;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;

public abstract class BasicColumn<T extends Comparable<T>, C extends BasicColumn<T, C>>
extends DataFrameColumn<T, C> {
    public static final double GROW_FACTOR = 1.6;
    public static final int INIT_SIZE = 128;
    private int size = 0;
    protected T[] values;

    public BasicColumn(String name) {
        this.size = 0;
        this.setName(name);
        this.values = (Comparable[])Array.newInstance(this.getType(), 128);
    }

    public BasicColumn() {
        this(null);
    }

    public BasicColumn(String name, T[] values, int size) {
        this.values = values;
        this.setName(name);
        this.size = size;
    }

    public BasicColumn(String name, T[] values) {
        this(name, (Comparable[])values, values.length);
    }

    @Override
    public C setCapacity(int capacity) {
        if (capacity < this.size) {
            throw new DataFrameRuntimeException("capacity can not be lower than current size");
        }
        this.values = (Comparable[])Arrays.copyOf(this.values, capacity);
        return (C)((BasicColumn)this.getThis());
    }

    @Override
    protected void doSort(Comparator<T> comparator) {
        Arrays.sort(this.values, 0, this.size(), comparator);
    }

    @Override
    protected void doSort() {
        Arrays.sort(this.values, 0, this.size(), ValueComparator.COMPARATOR);
    }

    @Override
    protected void doSet(int index, T value) {
        if (value == null || value == Values.NA) {
            this.doSetNA(index);
            return;
        }
        this.setValue(index, value);
    }

    protected void setValue(int index, T value) {
        this.values[index] = value;
    }

    @Override
    protected void doMap(MapFunction<T> mapFunction) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.isNA(i)) continue;
            this.values[i] = (Comparable)mapFunction.map(this.values[i]);
        }
    }

    @Override
    protected void doReverse() {
        for (int i = 0; i < this.size() / 2; ++i) {
            T temp = this.values[i];
            this.values[i] = this.values[this.size() - i - 1];
            this.values[this.size() - i - 1] = temp;
        }
    }

    @Override
    public T get(int index) {
        return this.values[index];
    }

    @Override
    public boolean isValueValid(Comparable value) {
        return Values.NA.isNA(value) || this.getType().isAssignableFrom(value.getClass());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(T o) {
        return Arrays.asList(this.values).contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported by this iterator");
            }

            @Override
            public boolean hasNext() {
                return this.index < BasicColumn.this.size();
            }

            @Override
            public T next() {
                if (this.index >= BasicColumn.this.values.length) {
                    throw new NoSuchElementException(String.format("element not found: index out of bounds %s >= %s]", this.index, BasicColumn.this.values.length));
                }
                return BasicColumn.this.values[this.index++];
            }
        };
    }

    public Set<T> uniq() {
        HashSet<T> u = new HashSet<T>(Arrays.asList(this.values));
        u.remove(null);
        return u;
    }

    @Override
    public Comparable[] toArray() {
        return (Comparable[])Arrays.copyOf(this.values, this.size());
    }

    @Override
    public T[] toArray(T[] a) {
        if (a.length < this.size()) {
            return (Comparable[])Arrays.copyOf(this.values, this.size(), a.getClass());
        }
        System.arraycopy(this.values, 0, a, 0, this.size());
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    @Override
    protected boolean doAppend(T t) {
        if (this.size >= this.values.length - 1) {
            this.values = (Comparable[])Arrays.copyOf(this.values, (int)((double)this.values.length * 1.6));
        }
        this.values[this.size++] = t;
        return true;
    }

    @Override
    protected boolean doAppendNA() {
        return this.doAppend(null);
    }

    @Override
    public boolean isNA(int index) {
        return this.values.length <= index || this.values[index] == null;
    }

    @Override
    protected void doSetNA(int index) {
        this.values[index] = null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return new HashSet<T>(Arrays.asList(this.values)).containsAll(c);
    }

    @Override
    protected boolean doAppendAll(Collection<? extends T> c) {
        for (Comparable o : c) {
            this.doAppend(o);
        }
        return true;
    }

    @Override
    public List<T> toList() {
        return new ArrayList<T>(Arrays.asList(Arrays.copyOf(this.values, this.size)));
    }

    @Override
    public List<T> asList() {
        return Collections.unmodifiableList(new BasicValueList<T>(this.values, this.size));
    }

    @Override
    public void clear() {
        this.values = (Comparable[])Array.newInstance(this.getType(), 128);
        this.size = 0;
    }

    class BasicValueList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;
        private int size;

        BasicValueList(E[] array, int size) {
            this.a = Objects.requireNonNull(array);
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOf(this.a, this.size, Object[].class);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                return Arrays.copyOf(this.a, size, a.getClass());
            }
            System.arraycopy(this.a, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public E get(int index) {
            return this.a[index];
        }

        @Override
        public int indexOf(Object o) {
            E[] a = this.a;
            if (o == null) {
                for (int i = 0; i < this.size; ++i) {
                    if (a[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    if (!o.equals(a[i])) continue;
                    return i;
                }
            }
            return -1;
        }
    }
}

