/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.ColumnAppender;
import de.unknownreality.dataframe.ColumnSelection;
import de.unknownreality.dataframe.ColumnTypeMap;
import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameException;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.DataRows;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.column.BooleanColumn;
import de.unknownreality.dataframe.column.ByteColumn;
import de.unknownreality.dataframe.column.DoubleColumn;
import de.unknownreality.dataframe.column.FloatColumn;
import de.unknownreality.dataframe.column.IntegerColumn;
import de.unknownreality.dataframe.column.LongColumn;
import de.unknownreality.dataframe.column.NumberColumn;
import de.unknownreality.dataframe.column.ShortColumn;
import de.unknownreality.dataframe.column.StringColumn;
import de.unknownreality.dataframe.common.mapping.DataMapper;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.filter.compile.PredicateCompiler;
import de.unknownreality.dataframe.group.DataGrouping;
import de.unknownreality.dataframe.group.GroupUtil;
import de.unknownreality.dataframe.group.impl.TreeGroupUtil;
import de.unknownreality.dataframe.index.Index;
import de.unknownreality.dataframe.index.Indices;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinUtil;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import de.unknownreality.dataframe.join.impl.DefaultJoinUtil;
import de.unknownreality.dataframe.sort.RowColumnComparator;
import de.unknownreality.dataframe.sort.SortColumn;
import de.unknownreality.dataframe.transform.DataFrameTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataFrame
implements DataFrame {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataFrame.class);
    public static final int DEFAULT_HEAD_SIZE = 20;
    public static final int DEFAULT_TAIL_SIZE = 20;
    private int size;
    private final Map<String, DataFrameColumn> columnsMap = new LinkedHashMap<String, DataFrameColumn>();
    private DataFrameColumn[] columns = null;
    private DataFrameHeader header = new DataFrameHeader();
    private final Indices indices = new Indices(this);
    private JoinUtil joinUtil = new DefaultJoinUtil();
    private GroupUtil groupUtil = new TreeGroupUtil();
    private AtomicInteger version = new AtomicInteger(0);
    private String name;

    public DefaultDataFrame() {
    }

    public DefaultDataFrame(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getVersion() {
        return this.version.get();
    }

    @Override
    public DefaultDataFrame setPrimaryKey(String ... colNames) {
        DataFrameColumn[] columns = new DataFrameColumn[colNames.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.getColumn(colNames[i]);
        }
        return this.setPrimaryKey(columns);
    }

    @Override
    public DefaultDataFrame setPrimaryKey(DataFrameColumn ... cols) {
        this.indices.setPrimaryKey(cols);
        return this;
    }

    @Override
    public DefaultDataFrame removePrimaryKey() {
        this.indices.removeIndex("%primary_key%");
        return this;
    }

    @Override
    public DefaultDataFrame removeIndex(String name) {
        this.indices.removeIndex(name);
        return this;
    }

    @Override
    public DefaultDataFrame renameColumn(String name, String newName) {
        DataFrameColumn column = this.columnsMap.get(name);
        if (column == null) {
            return this;
        }
        this.header.rename(name, newName);
        column.setName(newName);
        this.columnsMap.remove(name);
        this.columnsMap.put(newName, column);
        return this;
    }

    @Override
    public DefaultDataFrame replaceColumn(String existing, DataFrameColumn replacement) {
        DataFrameColumn existingColumn = this.getColumn(existing);
        return this.replaceColumn(existingColumn, replacement);
    }

    @Override
    public DefaultDataFrame replaceColumn(DataFrameColumn existing, DataFrameColumn replacement) {
        int existingIndex = this.header.getIndex(existing.getName());
        this.columns[existingIndex] = replacement;
        this.header.replace(existing, replacement);
        this.columnsMap.remove(existing.getName());
        this.columnsMap.put(replacement.getName(), replacement);
        this.indices.replace(existing, replacement);
        this.version.incrementAndGet();
        return this;
    }

    @Override
    public ColumnSelection selectColumns(String ... columnNames) {
        DataFrameColumn[] columns = new DataFrameColumn[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columns[i] = this.getColumn(columnNames[i]);
        }
        return this.selectColumns(columns);
    }

    @Override
    public ColumnSelection selectColumns(DataFrameColumn ... columns) {
        return new ColumnSelection(this, columns);
    }

    @Override
    public DefaultDataFrame addColumn(DataFrameColumn column) {
        if (column.size() == 0 && this.size != 0) {
            column.appendAll(Arrays.asList(new Values.NA[this.size]));
        }
        if (this.columns != null && column.size() != this.size) {
            throw new DataFrameRuntimeException("column lengths must be equal");
        }
        if (column.getDataFrame() != null && column.getDataFrame() != this) {
            throw new DataFrameRuntimeException("column can not be added to multiple data frames. use column.copy() first");
        }
        this.addToColumns(column);
        if (this.columns.length == 1) {
            this.size = column.size();
        }
        try {
            column.setDataFrame(this);
        }
        catch (DataFrameException e) {
            throw new DataFrameRuntimeException("error adding column", e);
        }
        this.header.add(column.getName(), column.getClass(), column.getType());
        this.columnsMap.put(column.getName(), column);
        return this;
    }

    private void addToColumns(DataFrameColumn column) {
        DataFrameColumn[] newColumns = new DataFrameColumn[this.columns == null ? 1 : this.columns.length + 1];
        if (this.columns != null) {
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
        }
        newColumns[newColumns.length - 1] = column;
        this.columns = newColumns;
    }

    @Override
    public DefaultDataFrame addBooleanColumn(String name) {
        BooleanColumn column = new BooleanColumn(name);
        return this.addColumn(column);
    }

    @Override
    public DefaultDataFrame addByteColumn(String name) {
        ByteColumn column = new ByteColumn(name);
        return this.addColumn(column);
    }

    @Override
    public DefaultDataFrame addDoubleColumn(String name) {
        DoubleColumn column = new DoubleColumn(name);
        return this.addColumn(column);
    }

    @Override
    public DefaultDataFrame addFloatColumn(String name) {
        FloatColumn column = new FloatColumn(name);
        return this.addColumn(column);
    }

    @Override
    public DefaultDataFrame addIntegerColumn(String name) {
        IntegerColumn column = new IntegerColumn(name);
        return this.addColumn(column);
    }

    @Override
    public DefaultDataFrame addLongColumn(String name) {
        LongColumn column = new LongColumn(name);
        return this.addColumn(column);
    }

    @Override
    public DefaultDataFrame addShortColumn(String name) {
        ShortColumn column = new ShortColumn(name);
        return this.addColumn(column);
    }

    @Override
    public DefaultDataFrame addStringColumn(String name) {
        StringColumn column = new StringColumn(name);
        return this.addColumn(column);
    }

    @Override
    public <T extends Comparable<T>> DataFrame addColumn(Class<T> type, String name) {
        return this.addColumn(type, name, ColumnTypeMap.create());
    }

    @Override
    public <T extends Comparable<T>> DataFrame addColumn(Class<T> type, String name, ColumnTypeMap columnTypeMap) {
        return this.addColumn(type, name, columnTypeMap, null);
    }

    @Override
    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> DataFrame addColumn(Class<T> type, String name, ColumnTypeMap columnTypeMap, ColumnAppender<T> appender) {
        Class columnType = columnTypeMap.getColumnType(type);
        if (columnType == null) {
            throw new DataFrameRuntimeException(String.format("no  column type found for %s", type.getName()));
        }
        return this.addColumn(columnType, name, appender);
    }

    @Override
    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> DataFrame addColumn(Class<C> type, String name, ColumnAppender<T> appender) {
        try {
            DataFrameColumn col = (DataFrameColumn)type.newInstance();
            col.setName(name);
            if (appender != null) {
                for (DataRow row : this) {
                    T val = appender.createRowValue(row);
                    if (val == null || val == Values.NA) {
                        col.doAppendNA();
                        continue;
                    }
                    col.doAppend(val);
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    col.doAppendNA();
                }
            }
            this.addColumn(col);
        }
        catch (InstantiationException e) {
            log.error("error creating instance of column [{}], empty constructor required", type, (Object)e);
            throw new DataFrameRuntimeException(String.format("error creating instance of column [%s], empty constructor required", type), e);
        }
        catch (IllegalAccessException e) {
            throw new DataFrameRuntimeException(String.format("error creating instance of column [%s], empty constructor required", type), e);
        }
        return this;
    }

    @Override
    public DefaultDataFrame addColumns(Collection<DataFrameColumn> columns) {
        for (DataFrameColumn column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    @Override
    public DefaultDataFrame addColumns(DataFrameColumn ... columns) {
        for (DataFrameColumn column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    @Override
    public DefaultDataFrame append(DataFrame dataFrame, int rowIndex) {
        if (this.columns == null) {
            throw new DataFrameRuntimeException("dataframe contains no columns");
        }
        if (dataFrame.getHeader().size() != this.columns.length) {
            throw new DataFrameRuntimeException("value for each column required");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            DataFrameColumn column = this.columns[i];
            column.startDataFrameAppend();
            Comparable value = dataFrame.getValue(i, rowIndex);
            if (value == null || Values.NA.equals(value)) {
                column.appendNA();
            } else {
                column.append(value);
            }
            column.endDataFrameAppend();
        }
        ++this.size;
        this.indices.update(this.getRow(this.size - 1));
        return this;
    }

    @Override
    public DefaultDataFrame append(Comparable ... values) {
        Comparable value;
        DataFrameColumn column;
        int i;
        if (this.columns == null) {
            throw new DataFrameRuntimeException("dataframe contains no columns");
        }
        if (values.length != this.columns.length) {
            throw new DataFrameRuntimeException("value for each column required");
        }
        for (i = 0; i < this.columns.length; ++i) {
            column = this.columns[i];
            value = values[i];
            if (column.isValueValid(value)) continue;
            throw new DataFrameRuntimeException(String.format("value %d has wrong type (%s != %s)", i, value == null ? "null" : value.getClass().getName(), column.getType().getName()));
        }
        for (i = 0; i < this.columns.length; ++i) {
            column = this.columns[i];
            column.startDataFrameAppend();
            value = values[i];
            if (value == null || value == Values.NA) {
                column.appendNA();
            } else {
                column.append(value);
            }
            column.endDataFrameAppend();
        }
        ++this.size;
        this.indices.update(this.getRow(this.size - 1));
        return this;
    }

    @Override
    public DefaultDataFrame append(DataRow row) {
        for (String h : this.header) {
            DataFrameColumn column = this.columnsMap.get(h);
            column.startDataFrameAppend();
            Comparable value = (Comparable)row.get(h);
            if (value == null || value == Values.NA) {
                column.appendNA();
            } else {
                column.append(value);
            }
            column.endDataFrameAppend();
        }
        ++this.size;
        this.indices.update(this.getRow(this.size - 1));
        return this;
    }

    @Override
    public DefaultDataFrame appendMatchingRow(DataRow row) {
        for (int i = 0; i < row.size(); ++i) {
            DataFrameColumn column = this.columns[i];
            column.startDataFrameAppend();
            Comparable value = row.get(i);
            if (value == null || value == Values.NA) {
                column.appendNA();
            } else {
                column.append(value);
            }
            column.endDataFrameAppend();
        }
        ++this.size;
        this.indices.update(this.getRow(this.size - 1));
        return this;
    }

    @Override
    public DefaultDataFrame update(DataRow dataRow) {
        for (String h : this.header) {
            DataFrameColumn column = this.getColumn(h);
            Comparable newValue = (Comparable)dataRow.get(h);
            if (newValue == null) continue;
            if (newValue == Values.NA) {
                column.setNA(dataRow.getIndex());
                continue;
            }
            column.set(dataRow.getIndex(), newValue);
        }
        return this;
    }

    @Override
    public DefaultDataFrame set(DataFrameHeader header) {
        this.version.incrementAndGet();
        this.columns = null;
        this.header.clear();
        this.size = 0;
        this.indices.clearValues();
        this.columnsMap.clear();
        for (String columnName : header) {
            Class<DataFrameColumn> cl = header.getColumnType(columnName);
            try {
                DataFrameColumn column = cl.newInstance();
                column.setName(columnName);
                this.addColumn(column);
            }
            catch (Exception e) {
                throw new DataFrameRuntimeException("error creating column instance", e);
            }
        }
        return this;
    }

    @Override
    public DefaultDataFrame set(DataRows dataRows) {
        return this.set(dataRows, null);
    }

    protected DefaultDataFrame set(DataRows dataRows, Indices indices) {
        DataFrame temp = dataRows.toDataFrame();
        this.set(temp, indices);
        return this;
    }

    protected DefaultDataFrame set(DataFrame dataFrame, Indices indices) {
        this.version.incrementAndGet();
        this.columnsMap.clear();
        this.columns = null;
        this.size = 0;
        this.header = new DataFrameHeader();
        for (DataFrameColumn column : dataFrame.getColumns()) {
            try {
                column.setDataFrame(null);
                this.addColumn(column);
            }
            catch (DataFrameException e) {
                log.error("error adding column", (Throwable)e);
            }
        }
        if (indices == this.indices) {
            this.indices.clearValues();
        } else if (indices != null) {
            indices.copyTo(this);
        } else {
            this.indices.clear();
        }
        this.indices.updateAllRows();
        return this;
    }

    @Override
    public DefaultDataFrame removeColumn(String header) {
        DataFrameColumn column = this.getColumn(header);
        if (column == null) {
            log.error("error column not found {}", (Object)header);
            return this;
        }
        return this.removeColumn(column);
    }

    @Override
    public DefaultDataFrame removeColumn(DataFrameColumn column) {
        try {
            column.setDataFrame(null);
        }
        catch (DataFrameException e) {
            throw new DataFrameRuntimeException("error removing column", e);
        }
        this.version.incrementAndGet();
        this.removeFromColumns(column);
        this.header.remove(column.getName());
        this.indices.removeColumn(column);
        this.columnsMap.remove(column.getName());
        return this;
    }

    private void removeFromColumns(DataFrameColumn column) {
        if (this.columns == null) {
            throw new DataFrameRuntimeException("error removing column: dataframe contains no column");
        }
        if (this.columns.length == 1 && this.columns[0] == column) {
            this.columns = null;
            return;
        }
        DataFrameColumn[] newColumns = new DataFrameColumn[this.columns.length - 1];
        int newIndex = 0;
        boolean columnFound = false;
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == column) {
                columnFound = true;
                continue;
            }
            newColumns[newIndex++] = this.columns[i];
        }
        if (!columnFound) {
            throw new DataFrameRuntimeException(String.format("error removing column: column not found '%s'", column.getName()));
        }
        this.columns = newColumns;
    }

    @Override
    public DefaultDataFrame sort(SortColumn ... columns) {
        DataRows rows = this.getRows(0, this.size);
        Collections.sort(rows, new RowColumnComparator(columns));
        this.set(rows, this.indices);
        return this;
    }

    @Override
    public DefaultDataFrame sort(Comparator<DataRow> comp) {
        DataRows rows = this.getRows(0, this.size);
        Collections.sort(rows, comp);
        this.set(rows, this.indices);
        return this;
    }

    @Override
    public DefaultDataFrame sort(String name) {
        return this.sort(name, SortColumn.Direction.Ascending);
    }

    @Override
    public DefaultDataFrame sort(String name, SortColumn.Direction dir) {
        DataRows rows = this.getRows(0, this.size);
        Collections.sort(rows, new RowColumnComparator(new SortColumn[]{new SortColumn(name, dir)}));
        this.set(rows, this.indices);
        return this;
    }

    @Override
    public DefaultDataFrame shuffle() {
        DataRows rows = this.getRows(0, this.size);
        Collections.shuffle(rows);
        this.set(rows, this.indices);
        return this;
    }

    @Override
    public DefaultDataFrame select(String colName, Comparable value) {
        return this.select(FilterPredicate.eq(colName, value));
    }

    @Override
    public DataRow selectFirst(String colName, Comparable value) {
        return this.selectFirst(FilterPredicate.eq(colName, value));
    }

    @Override
    public DataRow selectFirst(String predicateString) {
        return this.selectFirst(FilterPredicate.compile(predicateString));
    }

    @Override
    public DataRow selectFirst(FilterPredicate predicate) {
        for (DataRow row : this) {
            if (!predicate.valid(row)) continue;
            return row;
        }
        return null;
    }

    @Override
    public DefaultDataFrame select(FilterPredicate predicate) {
        DefaultDataFrame df = new DefaultDataFrame();
        df.set(this.getHeader());
        this.indices.copyTo(df);
        for (DataRow row : this) {
            if (!predicate.valid(row)) continue;
            df.append(row);
        }
        return df;
    }

    @Override
    public DefaultDataFrame select(String predicateString) {
        return this.select(PredicateCompiler.compile(predicateString));
    }

    @Override
    public DefaultDataFrame filter(String predicateString) {
        this.filter(FilterPredicate.compile(predicateString));
        return this;
    }

    @Override
    public DefaultDataFrame filter(FilterPredicate predicate) {
        this.set(this.select(predicate), this.getIndices());
        return this;
    }

    @Override
    public DataRows selectRows(String colName, Comparable value) {
        return this.selectRows(FilterPredicate.eq(colName, value));
    }

    @Override
    public DataRows selectRows(String predicateString) {
        return this.selectRows(FilterPredicate.compile(predicateString));
    }

    @Override
    public DataRows selectRows(FilterPredicate predicate) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this) {
            if (!predicate.valid(row)) continue;
            rows.add(row);
        }
        return new DataRows(this, rows);
    }

    @Override
    public DefaultDataFrame transform(DataFrameTransform transformer) {
        return transformer.transform(this);
    }

    @Override
    public DataRow selectByPrimaryKey(Comparable ... keyValues) {
        Integer index = this.indices.findByPrimaryKey(keyValues);
        if (index == null || index < 0) {
            return null;
        }
        return this.getRow(index);
    }

    @Override
    public DefaultDataFrame reverse() {
        this.version.incrementAndGet();
        for (DataFrameColumn col : this.columns) {
            col.doReverse();
        }
        this.indices.updateAllRows();
        return this;
    }

    @Override
    public DefaultDataFrame addIndex(String indexName, String ... columnNames) {
        DataFrameColumn[] columns = new DataFrameColumn[columnNames.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.getColumn(columnNames[i]);
        }
        return this.addIndex(indexName, columns);
    }

    @Override
    public DefaultDataFrame addIndex(String indexName, DataFrameColumn ... columns) {
        this.indices.addIndex(indexName, columns);
        return this;
    }

    @Override
    public DefaultDataFrame addIndex(Index index) {
        this.indices.addIndex(index);
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @Deprecated
    public DefaultDataFrame subset(int from, int to) {
        return this.filterSubset(from, to);
    }

    @Override
    public DefaultDataFrame filterSubset(int from, int to) {
        this.set(this.selectSubset(from, to), this.indices);
        return this;
    }

    @Override
    public DefaultDataFrame selectSubset(int from, int to) {
        DefaultDataFrame newFrame = new DefaultDataFrame();
        newFrame.set(this.getRows(from, to), this.indices);
        return newFrame;
    }

    @Override
    public DataRows getRows(int from, int to) {
        DataRows rows = new DataRows(this);
        for (int i = from; i < to; ++i) {
            rows.add(this.getRow(i));
        }
        return rows;
    }

    @Override
    public DataRows getRows() {
        return this.getRows(0, this.size);
    }

    @Override
    public DataFrameHeader getHeader() {
        return this.header;
    }

    @Override
    public DefaultDataFrame concat(DataFrame other) {
        if (!this.header.equals(other.getHeader())) {
            throw new DataFrameRuntimeException("data frames not compatible");
        }
        for (DataRow row : other) {
            this.append(row);
        }
        return this;
    }

    @Override
    public DefaultDataFrame concat(Collection<DataFrame> dataFrames) {
        for (DataFrame dataFrame : dataFrames) {
            if (!this.header.equals(dataFrame.getHeader())) {
                throw new DataFrameRuntimeException("data frames not compatible");
            }
            for (DataRow row : dataFrame) {
                this.append(row);
            }
        }
        return this;
    }

    @Override
    public DefaultDataFrame concat(DataFrame ... dataFrames) {
        return this.concat(Arrays.asList(dataFrames));
    }

    @Override
    public boolean isCompatible(DataFrame input) {
        return this.header.equals(input.getHeader());
    }

    @Override
    public DataRow getRow(int i) {
        return new DataRow(this, i);
    }

    @Override
    public Collection<String> getColumnNames() {
        return new ArrayList<String>(this.columnsMap.keySet());
    }

    @Override
    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> DataFrameColumn<T, C> getColumn(String name) {
        return this.columnsMap.get(name);
    }

    @Override
    public <T extends DataFrameColumn> T getColumn(String name, Class<T> cl) {
        DataFrameColumn column = this.columnsMap.get(name);
        if (column == null) {
            throw new DataFrameRuntimeException(String.format("column '%s' not found", name));
        }
        if (!cl.isInstance(column)) {
            throw new DataFrameRuntimeException(String.format("column '%s' has wrong type", name));
        }
        return (T)((DataFrameColumn)cl.cast(column));
    }

    @Override
    public <T extends Number, C extends NumberColumn<T, C>> NumberColumn<T, C> getNumberColumn(String name) {
        return this.getColumn(name, NumberColumn.class);
    }

    @Override
    public StringColumn getStringColumn(String name) {
        return this.getColumn(name, StringColumn.class);
    }

    @Override
    public DoubleColumn getDoubleColumn(String name) {
        return this.getColumn(name, DoubleColumn.class);
    }

    @Override
    public IntegerColumn getIntegerColumn(String name) {
        return this.getColumn(name, IntegerColumn.class);
    }

    @Override
    public FloatColumn getFloatColumn(String name) {
        return this.getColumn(name, FloatColumn.class);
    }

    @Override
    public BooleanColumn getBooleanColumn(String name) {
        return this.getColumn(name, BooleanColumn.class);
    }

    @Override
    public ByteColumn getByteColumn(String name) {
        return this.getColumn(name, ByteColumn.class);
    }

    @Override
    public LongColumn getLongColumn(String name) {
        return this.getColumn(name, LongColumn.class);
    }

    @Override
    public ShortColumn getShortColumn(String name) {
        return this.getColumn(name, ShortColumn.class);
    }

    @Override
    public DataGrouping groupBy(String ... column) {
        return this.groupUtil.groupBy(this, column);
    }

    @Override
    public JoinedDataFrame joinLeft(DataFrame dataFrame, String ... joinColumns) {
        JoinColumn[] joinColumnsArray = new JoinColumn[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            joinColumnsArray[i] = new JoinColumn(joinColumns[i]);
        }
        return this.joinLeft(dataFrame, joinColumnsArray);
    }

    @Override
    public JoinedDataFrame joinLeft(DataFrame dataFrame, JoinColumn ... joinColumns) {
        return this.joinUtil.leftJoin((DataFrame)this, dataFrame, joinColumns);
    }

    @Override
    public JoinedDataFrame joinLeft(DataFrame dataFrame, String suffixA, String suffixB, JoinColumn ... joinColumns) {
        return this.joinUtil.leftJoin((DataFrame)this, dataFrame, suffixA, suffixB, joinColumns);
    }

    @Override
    public JoinedDataFrame joinRight(DataFrame dataFrame, String ... joinColumns) {
        JoinColumn[] joinColumnsArray = new JoinColumn[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            joinColumnsArray[i] = new JoinColumn(joinColumns[i]);
        }
        return this.joinRight(dataFrame, joinColumnsArray);
    }

    @Override
    public JoinedDataFrame joinRight(DataFrame dataFrame, JoinColumn ... joinColumns) {
        return this.joinUtil.rightJoin((DataFrame)this, dataFrame, joinColumns);
    }

    @Override
    public JoinedDataFrame joinRight(DataFrame dataFrame, String suffixA, String suffixB, JoinColumn ... joinColumns) {
        return this.joinUtil.rightJoin((DataFrame)this, dataFrame, suffixA, suffixB, joinColumns);
    }

    @Override
    public JoinedDataFrame joinInner(DataFrame dataFrame, String ... joinColumns) {
        JoinColumn[] joinColumnsArray = new JoinColumn[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            joinColumnsArray[i] = new JoinColumn(joinColumns[i]);
        }
        return this.joinInner(dataFrame, joinColumnsArray);
    }

    @Override
    public JoinedDataFrame joinInner(DataFrame dataFrame, JoinColumn ... joinColumns) {
        return this.joinUtil.innerJoin((DataFrame)this, dataFrame, joinColumns);
    }

    @Override
    public JoinedDataFrame joinInner(DataFrame dataFrame, String suffixA, String suffixB, JoinColumn ... joinColumns) {
        return this.joinUtil.innerJoin((DataFrame)this, dataFrame, suffixA, suffixB, joinColumns);
    }

    @Override
    public JoinedDataFrame joinOuter(DataFrame dataFrame, String ... joinColumns) {
        JoinColumn[] joinColumnsArray = new JoinColumn[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            joinColumnsArray[i] = new JoinColumn(joinColumns[i]);
        }
        return this.joinOuter(dataFrame, joinColumnsArray);
    }

    @Override
    public JoinedDataFrame joinOuter(DataFrame dataFrame, JoinColumn ... joinColumns) {
        return this.joinUtil.outerJoin((DataFrame)this, dataFrame, joinColumns);
    }

    @Override
    public JoinedDataFrame joinOuter(DataFrame dataFrame, String suffixA, String suffixB, JoinColumn ... joinColumns) {
        return this.joinUtil.outerJoin((DataFrame)this, dataFrame, suffixA, suffixB, joinColumns);
    }

    @Override
    public DefaultDataFrame copy() {
        DataRows rows = this.getRows(0, this.size);
        DefaultDataFrame copy = new DefaultDataFrame();
        copy.set(rows, this.indices);
        return copy;
    }

    @Override
    public boolean containsColumn(DataFrameColumn column) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != column) continue;
            return true;
        }
        return false;
    }

    protected void notifyColumnValueChanged(DataFrameColumn column, int index, Comparable value) {
        if (this.indices.isIndexColumn(column)) {
            this.indices.updateValue(column, this.getRow(index));
        }
    }

    protected void notifyColumnChanged(DataFrameColumn column) {
        if (this.indices.isIndexColumn(column)) {
            this.indices.updateColumn(column);
        }
    }

    @Override
    public boolean isIndexColumn(DataFrameColumn column) {
        return this.indices.isIndexColumn(column);
    }

    @Override
    public DataRows selectRowsByIndex(String name, Comparable ... values) {
        Collection<Integer> rowIndices = this.indices.find(name, values);
        return this.selectRows(rowIndices);
    }

    @Override
    public DataRows selectRows(Collection<Integer> rowIndices) {
        if (!rowIndices.isEmpty()) {
            ArrayList<DataRow> rows = new ArrayList<DataRow>();
            for (Integer i : rowIndices) {
                rows.add(this.getRow(i));
            }
            return new DataRows(this, rows);
        }
        return new DataRows(this, new ArrayList<DataRow>(0));
    }

    @Override
    public DataRow selectFirstRowByIndex(String name, Comparable ... values) {
        Integer idx = this.indices.findFirst(name, values);
        return idx == null ? null : this.getRow(idx);
    }

    @Override
    public DataFrame selectByIndex(String name, Comparable ... values) {
        DataRows rows = this.selectRowsByIndex(name, values);
        DefaultDataFrame df = new DefaultDataFrame();
        df.set(rows, this.indices);
        return df;
    }

    @Override
    public Collection<DataFrameColumn> getColumns() {
        return Arrays.asList(this.columns);
    }

    @Override
    public Iterable<? extends DataRow> rows() {
        return this;
    }

    protected Indices getIndices() {
        return this.indices;
    }

    public GroupUtil getGroupUtil() {
        return this.groupUtil;
    }

    public JoinUtil getJoinUtil() {
        return this.joinUtil;
    }

    public void setGroupUtil(GroupUtil groupUtil) {
        this.groupUtil = groupUtil;
    }

    public void setJoinUtil(JoinUtil joinUtil) {
        this.joinUtil = joinUtil;
    }

    @Override
    public <T> List<T> map(Class<T> cl) {
        return DataMapper.map(this, cl);
    }

    @Override
    public Iterator<DataRow> iterator() {
        return new Iterator<DataRow>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DefaultDataFrame.this.size;
            }

            @Override
            public DataRow next() {
                if (this.index == DefaultDataFrame.this.size()) {
                    throw new NoSuchElementException("index out of bounds");
                }
                return DefaultDataFrame.this.getRow(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported for data frames");
            }
        };
    }

    @Override
    public Comparable getValue(int col, int row) {
        if (this.columns == null) {
            throw new DataFrameRuntimeException("dataframe contains no columns");
        }
        if (col >= this.columns.length || row > this.size) {
            throw new DataFrameRuntimeException("index out of bounds");
        }
        return this.columns[col].get(row);
    }

    @Override
    public void setValue(int col, int row, Comparable newValue) {
        if (this.columns == null) {
            throw new DataFrameRuntimeException("dataframe contains no columns");
        }
        if (col >= this.columns.length || row > this.size) {
            throw new DataFrameRuntimeException("index out of bounds");
        }
        if (newValue == null || newValue == Values.NA) {
            this.columns[col].setNA(row);
        } else {
            this.columns[col].set(row, newValue);
        }
        this.indices.update(this.getRow(row));
    }

    @Override
    public boolean isNA(int col, int row) {
        if (this.columns == null) {
            throw new DataFrameRuntimeException("dataframe contains no columns");
        }
        if (col >= this.columns.length || row > this.size) {
            throw new DataFrameRuntimeException("index out of bounds");
        }
        return this.columns[col].isNA(row);
    }

    @Override
    public DataFrame head(int size) {
        return this.selectSubset(0, Math.min(this.size(), size));
    }

    @Override
    public DataFrame head() {
        return this.head(20);
    }

    @Override
    public DataFrame tail(int size) {
        return this.selectSubset(Math.max(0, this.size() - size), this.size());
    }

    @Override
    public DataFrame tail() {
        return this.tail(20);
    }

    @Override
    public void clear() {
        for (DataFrameColumn col : this.columns) {
            col.clear();
        }
        this.size = 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DefaultDataFrame)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        DataFrame d = (DataFrame)o;
        if (this.size() != d.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getRow(i).equals(d.getRow(i))) continue;
            return false;
        }
        return true;
    }
}

