/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.row.UpdatableRow;

public class DataRow
extends UpdatableRow<String, DataFrameHeader, Comparable> {
    private DataFrame dataFrame;
    private int size;
    private int rowVersion;

    public DataRow(DataFrame dataFrame, int index) {
        super(dataFrame.getHeader(), index);
        this.rowVersion = dataFrame.getVersion();
        this.size = ((DataFrameHeader)this.getHeader()).size();
        this.dataFrame = dataFrame;
    }

    public boolean isVersionValid() {
        return this.rowVersion == this.dataFrame.getVersion();
    }

    private void checkValidity() {
        if (!this.isVersionValid()) {
            throw new DataFrameRuntimeException("row is no longer valid, the dataframe changed since the row object was created");
        }
    }

    @Override
    public Comparable get(int index) {
        this.checkValidity();
        Comparable val = this.dataFrame.getValue(index, this.getIndex());
        if (val == null) {
            return Values.NA;
        }
        return val;
    }

    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isCompatible(Comparable value, String headerName) {
        if (value == null || value instanceof Values.NA) {
            return true;
        }
        Class<Comparable> type = ((DataFrameHeader)this.getHeader()).getType(headerName);
        if (Number.class.isAssignableFrom(type)) {
            return Number.class.isAssignableFrom(value.getClass());
        }
        return type.isAssignableFrom(value.getClass());
    }

    @Override
    public boolean isCompatible(Comparable value, int headerIndex) {
        Class<Comparable> type = ((DataFrameHeader)this.getHeader()).getType(headerIndex);
        return type.isAssignableFrom(value.getClass());
    }

    @Override
    protected void setValue(int index, Comparable value) {
        this.checkValidity();
        this.dataFrame.setValue(index, this.getIndex(), value);
    }

    public Comparable[] getRowValues(int i) {
        this.checkValidity();
        if (i >= this.dataFrame.size()) {
            throw new DataFrameRuntimeException("index out of bounds");
        }
        Comparable[] values = new Comparable[this.dataFrame.getHeader().size()];
        for (int j = 0; j < this.dataFrame.getHeader().size(); ++j) {
            Comparable value = this.dataFrame.getValue(j, i);
            values[j] = Values.NA.isNA(value) ? Values.NA : value;
        }
        return values;
    }
}

